/*
 * Decompiled with CFR 0.152.
 */
package com.iamhabib.easy_preference;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import java.util.Set;

public class EasyPreference {
    public static Builder with(Context context) {
        return new Builder(context);
    }

    public static class Builder {
        SharedPreferences preferences;
        SharedPreferences.Editor editor;
        Context context;

        public Builder(Context context) {
            this.context = context;
            this.preferences = context.getSharedPreferences("EasyPreferencePref", 0);
            this.editor = this.preferences.edit();
        }

        public Builder addBoolean(String key, boolean value) {
            this.editor.putBoolean(key, value);
            return this;
        }

        public Builder addString(String key, String value) {
            this.editor.putString(key, value);
            return this;
        }

        public Builder addInt(String key, int value) {
            this.editor.putInt(key, value);
            return this;
        }

        public Builder addFloat(String key, float value) {
            this.editor.putFloat(key, value);
            return this;
        }

        public Builder addLong(String key, long value) {
            this.editor.putLong(key, value);
            return this;
        }

        public Builder addStringSet(String key, Set<String> value) {
            this.editor.putStringSet(key, value);
            return this;
        }

        public Builder addObject(String key, Object value) {
            Gson gson = new Gson();
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Builder save() {
            this.editor.commit();
            return this;
        }

        public boolean getBoolean(String key, boolean defalutValue) {
            return this.preferences.getBoolean(key, defalutValue);
        }

        public String getString(String key, String defalutValue) {
            return this.preferences.getString(key, defalutValue);
        }

        public int getInt(String key, int defalutValue) {
            return this.preferences.getInt(key, defalutValue);
        }

        public float getFloat(String key, float defalutValue) {
            return this.preferences.getFloat(key, defalutValue);
        }

        public long getLong(String key, long defalutValue) {
            return this.preferences.getLong(key, defalutValue);
        }

        public Set<String> getStringSet(String key, Set<String> defalutValue) {
            return this.preferences.getStringSet(key, defalutValue);
        }

        public <GenericClass> GenericClass getObject(String key, Class<GenericClass> classType) {
            if (this.preferences.contains(key)) {
                Gson gson = new Gson();
                return (GenericClass)gson.fromJson(this.preferences.getString(key, ""), classType);
            }
            return null;
        }

        public Builder remove(String key) {
            this.editor.remove(key);
            return this;
        }

        public Builder clearAll() {
            this.editor.clear();
            return this;
        }
    }
}

