/*
 * Decompiled with CFR 0.152.
 */
package com.iadvize.kotlingraylog;

import android.content.Context;
import android.content.SharedPreferences;
import com.iadvize.kotlingraylog.Graylog;
import com.securepreferences.SecurePreferences;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u001e\u001a\u00020\u00172\n\u0010\u001f\u001a\u00060 j\u0002`!J\u0019\u0010\"\u001a\u00020\u00172\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/iadvize/kotlingraylog/Graylog;", "", "()V", "LOG_INTERVAL", "", "LOG_QUEUE_KEY", "", "LOG_QUEUE_MAX", "", "LOG_SEND_MAX", "USER_DEFAULTS_KEY", "client", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "jsonHeader", "Lokhttp3/MediaType;", "scheduler", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "securedPreferences", "Landroid/content/SharedPreferences;", "url", "Ljava/net/URL;", "checkAndSend", "", "clearQueue", "getQueue", "", "init", "context", "Landroid/content/Context;", "log", "attributes", "Lorg/json/JSONObject;", "Lcom/iadvize/kotlingraylog/LogValues;", "save", "save$kotlin_graylog_release", "start", "kotlin-graylog_release"})
public final class Graylog {
    private static final String LOG_QUEUE_KEY = "graylog.queue";
    private static final int LOG_QUEUE_MAX = 1000;
    private static final int LOG_SEND_MAX = 10;
    private static final long LOG_INTERVAL = 300L;
    private static final String USER_DEFAULTS_KEY = "graylog.logs";
    private static final MediaType jsonHeader;
    private static final OkHttpClient client;
    private static final ScheduledThreadPoolExecutor scheduler;
    private static SharedPreferences securedPreferences;
    private static URL url;
    public static final Graylog INSTANCE;

    public final void init(@NotNull Context context, @NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        securedPreferences = (SharedPreferences)new SecurePreferences(context.getApplicationContext(), USER_DEFAULTS_KEY, null);
        Graylog.url = url;
        this.start();
    }

    public final void log(@NotNull JSONObject attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (securedPreferences != null) {
            BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(attributes, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ JSONObject $attributes;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object2 = result;
                            if (object2 instanceof Result.Failure) {
                                throw ((Result.Failure)object2).exception;
                            }
                            CoroutineScope coroutineScope = this.p$;
                            RequestBody body = RequestBody.create((MediaType)Graylog.access$getJsonHeader$p(Graylog.INSTANCE), (String)this.$attributes.toString());
                            Request request = new Request.Builder().url(Graylog.access$getUrl$p(Graylog.INSTANCE)).post(body).build();
                            Graylog.access$getClient$p(Graylog.INSTANCE).newCall(request).enqueue(new Callback(this){
                                final /* synthetic */ log.2 this$0;

                                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                    Graylog.INSTANCE.save$kotlin_graylog_release(this.this$0.$attributes);
                                }

                                public void onResponse(@NotNull Call call, @NotNull Response response) {
                                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                                }
                                {
                                    this.this$0 = $outer;
                                }
                            });
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$attributes = jSONObject;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Logger.getLogger(Graylog.class.getName()).warning(Graylog.class.getName() + " is not initialized. You must call the init() method.");
            this.save$kotlin_graylog_release(attributes);
        }
    }

    public final void save$kotlin_graylog_release(@NotNull JSONObject attributes) {
        block2: {
            Set set;
            Set it;
            Set queue;
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            SharedPreferences sharedPreferences = securedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            String string = LOG_QUEUE_KEY;
            SharedPreferences sharedPreferences2 = sharedPreferences;
            Set set2 = new LinkedHashSet();
            Set set3 = queue = sharedPreferences2.getStringSet(string, set2);
            if (set3 == null || (it = (set = set3)).size() >= 1000) break block2;
            it.add(attributes.toString());
            SharedPreferences sharedPreferences3 = securedPreferences;
            if (sharedPreferences3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            sharedPreferences3.edit().putStringSet(LOG_QUEUE_KEY, it).apply();
        }
    }

    private final void checkAndSend() {
        block3: {
            List queueList;
            Set set;
            Set it;
            Collection collection;
            Set queue;
            SharedPreferences sharedPreferences = securedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            String string = LOG_QUEUE_KEY;
            SharedPreferences sharedPreferences2 = sharedPreferences;
            Set set2 = new LinkedHashSet();
            Set set3 = queue = sharedPreferences2.getStringSet(string, set2);
            if (set3 == null || !(!(collection = (Collection)(it = (set = set3))).isEmpty())) break block3;
            List listToSend = queueList.subList(0, (queueList = CollectionsKt.toList((Iterable)it)).size() > 10 ? 10 : it.size());
            for (String log2 : listToSend) {
                it.remove(log2);
                INSTANCE.log(new JSONObject(log2));
            }
            SharedPreferences sharedPreferences3 = securedPreferences;
            if (sharedPreferences3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            sharedPreferences3.edit().putStringSet(LOG_QUEUE_KEY, it).apply();
        }
    }

    public final void clearQueue() {
        if (securedPreferences != null) {
            SharedPreferences sharedPreferences = securedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            sharedPreferences.edit().remove(LOG_QUEUE_KEY).apply();
        }
    }

    @Nullable
    public final Set<String> getQueue() {
        Set set;
        if (securedPreferences != null) {
            SharedPreferences sharedPreferences = securedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
            }
            String string = LOG_QUEUE_KEY;
            SharedPreferences sharedPreferences2 = sharedPreferences;
            Set set2 = new LinkedHashSet();
            set = sharedPreferences2.getStringSet(string, set2);
        } else {
            set = null;
        }
        return set;
    }

    private final void start() {
        Runnable periodicCronTask2 = start.periodicCronTask.1.INSTANCE;
        scheduler.scheduleAtFixedRate(periodicCronTask2, 0L, 300L, TimeUnit.SECONDS);
    }

    private Graylog() {
    }

    static {
        Graylog graylog;
        INSTANCE = graylog = new Graylog();
        jsonHeader = MediaType.parse((String)"application/json; charset=utf-8");
        client = new OkHttpClient.Builder().build();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        if (scheduledExecutorService == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ScheduledThreadPoolExecutor");
        }
        scheduler = (ScheduledThreadPoolExecutor)scheduledExecutorService;
    }

    @NotNull
    public static final /* synthetic */ SharedPreferences access$getSecuredPreferences$p(Graylog $this) {
        Graylog graylog = $this;
        SharedPreferences sharedPreferences = securedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"securedPreferences");
        }
        return sharedPreferences;
    }

    public static final /* synthetic */ void access$setSecuredPreferences$p(Graylog $this, @NotNull SharedPreferences sharedPreferences) {
        Graylog graylog = $this;
        securedPreferences = sharedPreferences;
    }

    @Nullable
    public static final /* synthetic */ MediaType access$getJsonHeader$p(Graylog $this) {
        Graylog graylog = $this;
        return jsonHeader;
    }

    @NotNull
    public static final /* synthetic */ URL access$getUrl$p(Graylog $this) {
        Graylog graylog = $this;
        URL uRL = url;
        if (uRL == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"url");
        }
        return uRL;
    }

    public static final /* synthetic */ void access$setUrl$p(Graylog $this, @NotNull URL uRL) {
        Graylog graylog = $this;
        url = uRL;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(Graylog $this) {
        Graylog graylog = $this;
        return client;
    }

    public static final /* synthetic */ void access$checkAndSend(Graylog $this) {
        $this.checkAndSend();
    }
}

