/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.lib7z;

import android.content.res.AssetManager;
import android.text.TextUtils;
import com.hzy.lib7z.IExtractCallback;
import java.io.File;

public class Z7Extractor {
    public static final long DEFAULT_IN_BUF_SIZE = 0x1000000L;

    public static String getLzmaVersion() {
        return Z7Extractor.nGetLzmaVersion();
    }

    public static int extractFile(String filePath, String outPath, IExtractCallback callback) {
        File inputFile = new File(filePath);
        if (TextUtils.isEmpty((CharSequence)filePath) || !inputFile.exists() || TextUtils.isEmpty((CharSequence)outPath) || !Z7Extractor.prepareOutPath(outPath)) {
            if (callback != null) {
                callback.onError(999, "File Path Error!");
            }
            return 999;
        }
        return Z7Extractor.nExtractFile(filePath, outPath, callback, 0x1000000L);
    }

    public static int extractAsset(AssetManager assetManager, String fileName, String outPath, IExtractCallback callback) {
        if (TextUtils.isEmpty((CharSequence)fileName) || TextUtils.isEmpty((CharSequence)outPath) || !Z7Extractor.prepareOutPath(outPath)) {
            if (callback != null) {
                callback.onError(999, "File Path Error!");
            }
            return 999;
        }
        return Z7Extractor.nExtractAsset(assetManager, fileName, outPath, callback, 0x1000000L);
    }

    private static boolean prepareOutPath(String outPath) {
        File outDir = new File(outPath);
        if (!outDir.exists() && outDir.mkdirs()) {
            return true;
        }
        return outDir.exists() && outDir.isDirectory();
    }

    private static native int nExtractFile(String var0, String var1, IExtractCallback var2, long var3);

    private static native int nExtractAsset(AssetManager var0, String var1, String var2, IExtractCallback var3, long var4);

    private static native String nGetLzmaVersion();

    static {
        System.loadLibrary("un7zip");
    }
}

