/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.lib7z;

import android.content.res.AssetManager;
import android.text.TextUtils;
import com.hzy.lib7z.ExtractCallback;
import java.io.File;

public class Z7Extractor {
    public static final long DEFAULT_IN_BUF_SIZE = 0x200000L;

    public static String getLzmaVersion() {
        return Z7Extractor.nGetLzmaVersion();
    }

    public static boolean extractFile(String filePath, String outPath, ExtractCallback callback) {
        callback = callback == null ? ExtractCallback.EMPTY_CALLBACK : callback;
        File inputFile = new File(filePath);
        if (TextUtils.isEmpty((CharSequence)filePath) || !inputFile.exists() || TextUtils.isEmpty((CharSequence)outPath) || !Z7Extractor.prepareOutPath(outPath)) {
            callback.onError(999, "File Path Error!");
            return false;
        }
        return Z7Extractor.nExtractFile(filePath, outPath, callback, 0x200000L);
    }

    public static boolean extractAsset(AssetManager assetManager, String fileName, String outPath, ExtractCallback callback) {
        ExtractCallback extractCallback = callback = callback == null ? ExtractCallback.EMPTY_CALLBACK : callback;
        if (TextUtils.isEmpty((CharSequence)fileName) || TextUtils.isEmpty((CharSequence)outPath) || !Z7Extractor.prepareOutPath(outPath)) {
            callback.onError(999, "File Path Error!");
            return false;
        }
        return Z7Extractor.nExtractAsset(assetManager, fileName, outPath, callback, 0x200000L);
    }

    private static boolean prepareOutPath(String outPath) {
        File outDir = new File(outPath);
        if (!outDir.exists() && outDir.mkdirs()) {
            return true;
        }
        return outDir.exists() && outDir.isDirectory();
    }

    private static native boolean nExtractFile(String var0, String var1, ExtractCallback var2, long var3);

    private static native boolean nExtractAsset(AssetManager var0, String var1, String var2, ExtractCallback var3, long var4);

    private static native String nGetLzmaVersion();

    static {
        System.loadLibrary("un7zip");
    }
}

