/*
 * Decompiled with CFR 0.152.
 */
package com.hzh.lifecycle.dispatch.lifecycle;

import com.hzh.lifecycle.dispatch.lifecycle.Lifecycle;
import com.hzh.lifecycle.dispatch.listener.ActivityLifecycleListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActivityLifecycle
implements Lifecycle<ActivityLifecycleListener> {
    private final CopyOnWriteArrayList<ActivityLifecycleListener> lifecycleListeners = new CopyOnWriteArrayList();
    private boolean isCreated;
    private boolean isStarted;
    private boolean isResumed;

    @Override
    public void addListener(ActivityLifecycleListener listener) {
        if (this.lifecycleListeners.contains(listener)) {
            return;
        }
        this.lifecycleListeners.add(listener);
        if (this.isCreated) {
            listener.onCreate();
        } else {
            listener.onDestroy();
        }
        if (this.isStarted) {
            listener.onStart();
        } else {
            listener.onStop();
        }
        if (this.isResumed) {
            listener.onResume();
        } else {
            listener.onPause();
        }
    }

    @Override
    public void removeListener(ActivityLifecycleListener listener) {
        if (this.lifecycleListeners.size() > 0 && this.lifecycleListeners.contains(listener)) {
            this.lifecycleListeners.remove(listener);
        }
    }

    @Override
    public void removeAllListener() {
        if (this.lifecycleListeners.size() > 0) {
            this.lifecycleListeners.clear();
        }
    }

    @Override
    public boolean containListener(ActivityLifecycleListener listener) {
        if (this.lifecycleListeners.size() <= 0) {
            return false;
        }
        return this.lifecycleListeners.contains(listener);
    }

    @Override
    public List<ActivityLifecycleListener> getAllListener() {
        return null;
    }

    public void onCreate() {
        this.isCreated = true;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onCreate();
        }
    }

    public void onStart() {
        this.isStarted = true;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onStart();
        }
    }

    public void onResume() {
        this.isResumed = true;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onResume();
        }
    }

    public void onPause() {
        this.isResumed = false;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onPause();
        }
    }

    public void onStop() {
        this.isStarted = false;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onStop();
        }
    }

    public void onDestroy() {
        this.isCreated = false;
        for (ActivityLifecycleListener listener : this.lifecycleListeners) {
            listener.onDestroy();
        }
    }
}

