/*
 * Decompiled with CFR 0.152.
 */
package com.hzh.lifecycle.dispatch.lifecycle;

import com.hzh.lifecycle.dispatch.lifecycle.Lifecycle;
import com.hzh.lifecycle.dispatch.listener.FragmentLifecycleListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FragmentLifecycle
implements Lifecycle<FragmentLifecycleListener> {
    private final CopyOnWriteArrayList<FragmentLifecycleListener> lifecycleListeners = new CopyOnWriteArrayList();
    private boolean isAttach;
    private boolean isStarted;
    private boolean isDestroyed;

    @Override
    public void addListener(FragmentLifecycleListener listener) {
        if (this.lifecycleListeners.contains(listener)) {
            return;
        }
        this.lifecycleListeners.add(listener);
        if (this.isAttach) {
            listener.onAttach();
        }
        if (!this.isAttach) {
            listener.onDetach();
        }
        if (this.isStarted) {
            listener.onStart();
        }
        if (!this.isStarted) {
            listener.onStop();
        }
        if (this.isDestroyed) {
            listener.onDestroy();
        }
    }

    @Override
    public void removeListener(FragmentLifecycleListener listener) {
        if (this.lifecycleListeners.size() > 0 && this.lifecycleListeners.contains(listener)) {
            this.lifecycleListeners.remove(listener);
        }
    }

    @Override
    public void removeAllListener() {
        if (this.lifecycleListeners.size() > 0) {
            this.lifecycleListeners.clear();
        }
    }

    @Override
    public boolean containListener(FragmentLifecycleListener listener) {
        if (this.lifecycleListeners.size() <= 0) {
            return false;
        }
        return this.lifecycleListeners.contains(listener);
    }

    @Override
    public List<FragmentLifecycleListener> getAllListener() {
        ArrayList<FragmentLifecycleListener> list = new ArrayList<FragmentLifecycleListener>();
        list.addAll(this.lifecycleListeners);
        return list;
    }

    public void onAttach() {
        this.isAttach = true;
        for (FragmentLifecycleListener listener : this.lifecycleListeners) {
            listener.onAttach();
        }
    }

    public void onStart() {
        this.isStarted = true;
        for (FragmentLifecycleListener listener : this.lifecycleListeners) {
            listener.onStart();
        }
    }

    public void onStop() {
        this.isStarted = false;
        for (FragmentLifecycleListener listener : this.lifecycleListeners) {
            listener.onStop();
        }
    }

    public void onDestroy() {
        this.isDestroyed = true;
        for (FragmentLifecycleListener listener : this.lifecycleListeners) {
            listener.onDestroy();
        }
    }

    public void onDetach() {
        this.isAttach = false;
        for (FragmentLifecycleListener listener : this.lifecycleListeners) {
            listener.onDetach();
        }
    }
}

