/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.qualityReport;

import com.superrtc.qualityReport.ReportBase;
import com.superrtc.qualityReport.ReportType;
import com.superrtc.qualityReport.ReportUtils;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReportMsgBuffer {
    private static final String TAG = "ReportMsgBuffer";
    private final int MAX_SIZE = 300;
    private final int LOST_SIZE = 30;
    private LinkedList<ReportBase> list = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private final Condition fullCondition = this.lock.newCondition();
    private final Condition emptyCondition = this.lock.newCondition();
    int pushCount = 0;
    int popCount = 0;
    int emptyCount = 0;

    public void pushReportMsg(ReportBase reportBase) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.list.size() == 300) {
                ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_ERROR.ordinal(), TAG, "\u3010Push ReportBase \u961f\u5217\u5df2\u6ee1\u3011list size:" + this.list.size());
                for (int k = 0; k < 30; ++k) {
                    this.list.pollLast();
                }
            }
            if (reportBase.type != ReportType.REPORT_OP_INIT) {
                this.list.addFirst(reportBase);
                if (reportBase.type == ReportType.REPORT_OP_DATA) {
                    ++this.pushCount;
                    if (this.pushCount == 15) {
                        ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "\u3010Push ReportData Data\u3011 type:" + reportBase.type.name() + "  list size:" + this.list.size());
                        this.pushCount = 0;
                    }
                } else {
                    ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "\u3010Push ReportEvent Data\u3011  type:" + reportBase.type.name() + "  list size:" + this.list.size());
                }
            } else {
                this.list.addLast(reportBase);
                ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "\u3010Push ReportInit\u3011 type:" + reportBase.type.name() + "    list size:" + this.list.size());
            }
            this.fullCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReportBase getReportMsg() throws InterruptedException {
        ReportBase reportBase;
        this.lock.lock();
        try {
            while (this.list.size() == 0) {
                ++this.emptyCount;
                if (this.emptyCount == 15) {
                    ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, " \u3010Pop ReportBase \u961f\u5217\u4e3a\u7a7a\u3011 list size:" + this.list.size());
                    this.emptyCount = 0;
                }
                this.fullCondition.await();
            }
            reportBase = this.list.pollLast();
            ++this.popCount;
            if (this.popCount == 15) {
                ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, " \u3010Pop ReportData\u3011  type:" + reportBase.type.name() + "  list size:" + this.list.size());
                this.popCount = 0;
            }
            this.emptyCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
        return reportBase;
    }
}

