/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.livepusher;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.superrtc.livepusher.Permissions;
import com.superrtc.livepusher.PermissionsResultAction;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PermissionsManager {
    private static final String TAG = PermissionsManager.class.getSimpleName();
    private final Set<String> mPendingRequests = new HashSet<String>(1);
    private final Set<String> mPermissions = new HashSet<String>(1);
    private final List<WeakReference<PermissionsResultAction>> mPendingActions = new ArrayList<WeakReference<PermissionsResultAction>>(1);
    private static PermissionsManager mInstance = null;
    public static final String ACCEPT_CAMERA = "android.permission.CAMERA";
    public static final String ACCESS_RECORD_AUDIO = "android.permission.RECORD_AUDIO";
    public static final String ACCESS_INTERNET = "android.permission.INTERNET";
    public static final String ACCESS_MODIFY_AUDIO_SETTINGS = "android.permission.MODIFY_AUDIO_SETTINGS";
    public static final String STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";

    public static PermissionsManager getInstance() {
        if (mInstance == null) {
            mInstance = new PermissionsManager();
        }
        return mInstance;
    }

    private PermissionsManager() {
        this.initializePermissionsMap();
    }

    private synchronized void initializePermissionsMap() {
        this.mPermissions.add(ACCEPT_CAMERA);
        this.mPermissions.add(ACCESS_RECORD_AUDIO);
        this.mPermissions.add(ACCESS_INTERNET);
        this.mPermissions.add(ACCESS_MODIFY_AUDIO_SETTINGS);
        this.mPermissions.add(STORAGE);
    }

    @NonNull
    private synchronized String[] getManifestPermissions(@NonNull Activity activity) {
        String[] stringArray;
        PackageInfo packageInfo = null;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            Log.d((String)TAG, (String)activity.getPackageName());
            packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"A problem occurred when retrieving permissions", (Throwable)nameNotFoundException);
        }
        if (packageInfo != null && (stringArray = packageInfo.requestedPermissions) != null) {
            for (String string : stringArray) {
                Log.d((String)TAG, (String)("Manifest contained permission: " + string));
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private synchronized void addPendingAction(@NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        if (permissionsResultAction == null) {
            return;
        }
        permissionsResultAction.registerPermissions(stringArray);
        this.mPendingActions.add(new WeakReference<PermissionsResultAction>(permissionsResultAction));
    }

    private synchronized void removePendingAction(@Nullable PermissionsResultAction permissionsResultAction) {
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        while (iterator.hasNext()) {
            WeakReference<PermissionsResultAction> weakReference = iterator.next();
            if (weakReference.get() != permissionsResultAction && weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    public synchronized boolean hasPermission(@Nullable Context context, @NonNull String string) {
        return context != null && (ActivityCompat.checkSelfPermission((Context)context, (String)string) == 0 || !this.mPermissions.contains(string));
    }

    public synchronized boolean hasAllPermissions(@Nullable Context context, @NonNull String[] stringArray) {
        if (context == null) {
            return false;
        }
        boolean bl = true;
        for (String string : stringArray) {
            bl &= this.hasPermission(context, string);
        }
        return bl;
    }

    public synchronized void requestAllManifestPermissionsIfNecessary(@Nullable Activity activity, @Nullable PermissionsResultAction permissionsResultAction) {
        if (activity == null) {
            return;
        }
        String[] stringArray = this.getManifestPermissions(activity);
        this.requestPermissionsIfNecessaryForResult(activity, stringArray, permissionsResultAction);
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@Nullable Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        if (activity == null) {
            return;
        }
        this.addPendingAction(stringArray, permissionsResultAction);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM(activity, stringArray, permissionsResultAction);
        } else {
            List<String> list = this.getPermissionsListToRequest(activity, stringArray, permissionsResultAction);
            if (list.isEmpty()) {
                this.removePendingAction(permissionsResultAction);
            } else {
                String[] stringArray2 = list.toArray(new String[list.size()]);
                this.mPendingRequests.addAll(list);
                ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray2, (int)1);
            }
        }
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@NonNull Fragment fragment, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        FragmentActivity fragmentActivity = fragment.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        this.addPendingAction(stringArray, permissionsResultAction);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM((Activity)fragmentActivity, stringArray, permissionsResultAction);
        } else {
            List<String> list = this.getPermissionsListToRequest((Activity)fragmentActivity, stringArray, permissionsResultAction);
            if (list.isEmpty()) {
                this.removePendingAction(permissionsResultAction);
            } else {
                String[] stringArray2 = list.toArray(new String[list.size()]);
                this.mPendingRequests.addAll(list);
                fragment.requestPermissions(stringArray2, 1);
            }
        }
    }

    public synchronized void notifyPermissionsChange(@NonNull String[] stringArray, @NonNull int[] nArray) {
        int n = stringArray.length;
        if (nArray.length < n) {
            n = nArray.length;
        }
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        block0: while (iterator.hasNext()) {
            PermissionsResultAction permissionsResultAction = (PermissionsResultAction)iterator.next().get();
            for (int k = 0; k < n; ++k) {
                if (permissionsResultAction != null && !permissionsResultAction.onResult(stringArray[k], nArray[k])) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (int k = 0; k < n; ++k) {
            this.mPendingRequests.remove(stringArray[k]);
        }
    }

    private void doPermissionWorkBeforeAndroidM(@NonNull Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        for (String string : stringArray) {
            if (permissionsResultAction == null) continue;
            if (!this.mPermissions.contains(string)) {
                permissionsResultAction.onResult(string, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)string) != 0) {
                permissionsResultAction.onResult(string, Permissions.DENIED);
                continue;
            }
            permissionsResultAction.onResult(string, Permissions.GRANTED);
        }
    }

    @NonNull
    private List<String> getPermissionsListToRequest(@NonNull Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (!this.mPermissions.contains(string)) {
                if (permissionsResultAction == null) continue;
                permissionsResultAction.onResult(string, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)string) != 0) {
                if (this.mPendingRequests.contains(string)) continue;
                arrayList.add(string);
                continue;
            }
            if (permissionsResultAction == null) continue;
            permissionsResultAction.onResult(string, Permissions.GRANTED);
        }
        return arrayList;
    }
}

