/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    public final Integer qp;

    @CalledByNative
    private EncodedImage(ByteBuffer byteBuffer, int n, int n2, long l, FrameType frameType, int n3, boolean bl, Integer n4) {
        this.buffer = byteBuffer;
        this.encodedWidth = n;
        this.encodedHeight = n2;
        this.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(l);
        this.captureTimeNs = l;
        this.frameType = frameType;
        this.rotation = n3;
        this.completeFrame = bl;
        this.qp = n4;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private int encodedWidth;
        private int encodedHeight;
        private long captureTimeNs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        private Integer qp;

        private Builder() {
        }

        public Builder setBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            return this;
        }

        public Builder setEncodedWidth(int n) {
            this.encodedWidth = n;
            return this;
        }

        public Builder setEncodedHeight(int n) {
            this.encodedHeight = n;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long l) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(l);
            return this;
        }

        public Builder setCaptureTimeNs(long l) {
            this.captureTimeNs = l;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int n) {
            this.rotation = n;
            return this;
        }

        public Builder setCompleteFrame(boolean bl) {
            this.completeFrame = bl;
            return this;
        }

        public Builder setQp(Integer n) {
            this.qp = n;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp);
        }
    }

    public static enum FrameType {
        EmptyFrame(0),
        VideoFrameKey(3),
        VideoFrameDelta(4);

        private final int nativeIndex;

        private FrameType(int n2) {
            this.nativeIndex = n2;
        }

        public int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int n) {
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != n) continue;
                return frameType;
            }
            throw new IllegalArgumentException("Unknown native frame type: " + n);
        }
    }
}

