/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;

public class DeviceUuidFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static UUID uuid;

    public DeviceUuidFactory(Context context) {
        if (uuid == null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                try {
                    uuid = !"9774d56d682e549c".equals(string2) ? UUID.nameUUIDFromBytes(string2.getBytes("utf8")) : this.generateDeviceUuid(context);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
        }
    }

    private UUID generateDeviceUuid(Context context) {
        String string = Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.DISPLAY + Build.FINGERPRINT + Build.HOST + Build.ID + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.TAGS + Build.TYPE + Build.USER;
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        String string3 = wifiManager.getConnectionInfo().getMacAddress();
        if (DeviceUuidFactory.isEmpty(string2) && DeviceUuidFactory.isEmpty(string3)) {
            return UUID.randomUUID();
        }
        String string4 = string + string2 + string3;
        return UUID.nameUUIDFromBytes(string4.getBytes());
    }

    public UUID getDeviceUuid() {
        return uuid;
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).trim().length() == 0) {
            return true;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }
}

