/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.text.TextUtils;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;

import java.io.File;

import static com.hyphenate.chat.EMClient.TAG;

/**
 * \~chinese
 * 文件类消息的基类
 * 
 * \~english
 * the base class of file type message
 */
public abstract class EMFileMessageBody extends EMMessageBody {
    
    public enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING
    }

	/**
	 * @param localPath
	 * @deprecated Use {@link #EMFileMessageBody(Uri)}
	 */
	@Deprecated
	public EMFileMessageBody(String localPath) {
    	this(UriUtils.getLocalUriFromString(localPath));
	}

	public EMFileMessageBody(Uri localPath) {
		emaObject = new EMAFileMessageBody(localPath);
	}

	/**
	 * @param localPath
	 * @param type
	 * @deprecated Use {@link #EMFileMessageBody(Uri, int)}
	 */
	@Deprecated
	EMFileMessageBody(String localPath, int type) {
    	this(Uri.fromFile(new File(localPath)), type);
	}

	EMFileMessageBody(Uri localPath, int type) {
		switch (type) {
		case EMAMessageBody.EMAMessageBodyType_FILE:
			emaObject = new EMAFileMessageBody(localPath, type);
			setFileLength(UriUtils.getFileLength(EMClient.getInstance().getContext(), localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_IMAGE:
			emaObject = new EMAImageMessageBody(localPath, null);
			setFileLength(UriUtils.getFileLength(EMClient.getInstance().getContext(), localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_VIDEO:
			emaObject = new EMAVideoMessageBody(localPath, null);
			setFileLength(UriUtils.getFileLength(EMClient.getInstance().getContext(), localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_VOICE:
		    emaObject = new EMAVoiceMessageBody(localPath, 0);
			setFileLength(UriUtils.getFileLength(EMClient.getInstance().getContext(), localPath));
		    break;
		default:
			break;
		}
	}

	public EMFileMessageBody(EMAFileMessageBody body) {
		emaObject = body;
	}
	

	/**
	 * \~chinese
	 * 获得文件名
	 * 
	 * @return
	 * 
	 * \~english
	 * get file name
	 * @return
	 */
	public String getFileName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}

	public void setFileName(String fileName) {
		((EMAFileMessageBody)emaObject).setDisplayName(fileName);
	}

	/**
	 * \~chinese
	 * 本地图片，语音等文件的路径
	 * 
	 * @return
	 * @deprecated 使用 {@link #getLocalUri()}
	 * 
	 * \~english
	 * local file path
	 *
	 * @return
	 * @deprecated Use {@link #getLocalUri()}
	 */
	@Deprecated
	public String getLocalUrl() {
		Uri fileUri = getLocalUri();
		String filePath = UriUtils.getFilePath(EMClient.getInstance().getContext(), fileUri);
		if(TextUtils.isEmpty(filePath) && VersionUtils.isTargetQ(EMClient.getInstance().getContext())) {
			EMLog.e(TAG, "androidQ版本以上手机请调用file getLocalUri()");
			return fileUri != null ? fileUri.toString() : "";
		}
		return filePath;
	}

	/**
	 * @param localUrl
	 * @deprecated Use {@link #setLocalUrl(Uri)}
	 */
	@Deprecated
	public void setLocalUrl(String localUrl) {
		Uri fileUri = UriUtils.getLocalUriFromString(localUrl);
		((EMAFileMessageBody)emaObject).setLocalPath(fileUri != null ? fileUri.toString() : "");
	}

	/**
	 * \~chinese
	 * 本地图片，语音等文件的路径
	 *
	 * @return
	 *
	 * \~english
	 * local file path
	 */
	public Uri getLocalUri() {
		return UriUtils.getLocalUriFromString(((EMAFileMessageBody)emaObject).getLocalUrl());
	}

	public void setLocalUrl(Uri localUrl) {
		((EMAFileMessageBody)emaObject).setLocalPath(UriUtils.getUriString(localUrl));
	}

	/**
	 * \~chinese
	 * 远程图片，声音等的url
	 * 
	 * @return
	 * 
	 * \~english
	 * get file remote url
	 * @return
	 */
	public String getRemoteUrl() {
		return ((EMAFileMessageBody)emaObject).getRemoteUrl();
	}

	public void setRemoteUrl(String remoteUrl) {
		((EMAFileMessageBody)emaObject).setRemotePath(remoteUrl);
	}

	public void setSecret(String secret) {
		((EMAFileMessageBody)emaObject).setSecretKey(secret);
	}

	public String getSecret() {
		return ((EMAFileMessageBody)emaObject).getSecret();
	}
	
	public String displayName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}
	
	public void setFileLength(long length) {
		((EMAFileMessageBody)emaObject).setFileLength(length);
	}
	
	public EMDownloadStatus downloadStatus() {
	    EMADownloadStatus _status = ((EMAFileMessageBody)emaObject).downloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
	
	public void setDownloadStatus(EMDownloadStatus status) {
		((EMAFileMessageBody)emaObject).setDownloadStatus(EMADownloadStatus.valueOf(status.name()));
	}

}
