package com.hyphenate.chat;

/**
 * \~chinese
 * 音频录制的配置信息中音频比特率
 *    音频比特率，可选项为（8000, 10000, 15000, 20000, 36000, 32000, 64000, 128000）；
 *
 *
 * \~english
 * Audio bit rate in audio recording configuration information
 *    the audio bps.value in one of (8000, 10000, 15000, 20000, 36000, 32000, 64000, 128000)
 */


public enum EMAudioBpsType {
    BPS_8K("BPS_8K",8000),
    BPS_10K("BPS_10K",10000),
    BPS_15K("BPS_15K",15000),
    BPS_20K("BPS_20K",20000),
    BPS_32K("BPS_32K",32000),
    BPS_36K("BPS_36K",36000),
    BPS_64K("BPS_64K",64000),
    BPS_128K("BPS_128K",128000);

    private String value;
    private int desc;

    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
    public int getDesc() {
        return desc;
    }
    public void setDesc(int desc) {
        this.desc = desc;
    }
    private EMAudioBpsType(String value, int desc) {
        this.value = value;
        this.desc = desc;
    }
}
