/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.liveplayer;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.apkfuns.logutils.LogUtils;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.VideoView;
import com.superrtc.util.EMUniAppSurfaceView;
import com.superrtc.util.EMUniStreamParam;
import com.superrtc.util.LiveUntils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import java.util.Map;

public class EMLivePlayerWXModule
extends WXComponent<EMUniAppSurfaceView> {
    private static final String TAG = "EMLivePlayerWXModule";
    private String subStreamId = null;
    private String subRtcId;
    private EMUniStreamParam normalParam;
    private EMediaSession mediaSession;
    private Context mainContext;
    private Handler handler;
    private boolean isLogToConsole = false;
    private int iceConntionCode;

    public EMLivePlayerWXModule(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.iceConntionCode = LiveUntils.UniappNoticeCode.ICECONNECTION_NEW.noticeCode;
    }

    protected EMUniAppSurfaceView initComponentHostView(@NonNull Context context) {
        EMUniAppSurfaceView eMUniAppSurfaceView = new EMUniAppSurfaceView(context);
        LiveUntils.initGlobal(true, this.getContext());
        this.mainContext = context;
        this.normalParam = new EMUniStreamParam();
        this.createHandle();
        this.setLogToConsole("create EMLivePlayerWXModule success");
        return eMUniAppSurfaceView;
    }

    @WXComponentProp(name="objectFit")
    public void setObjectFit(String string) {
        if (string.equals("fill")) {
            ((EMUniAppSurfaceView)this.getHostView()).setScaleMode(VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFill);
        } else if (string.equals("fit")) {
            ((EMUniAppSurfaceView)this.getHostView()).setScaleMode(VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit);
        }
        this.setLogToConsole("objectFit:" + string);
    }

    @WXComponentProp(name="muted")
    public void setMuted(Boolean bl) {
        this.normalParam.setAudioOff(bl);
        this.setLogToConsole("setMuted:" + bl);
    }

    @WXComponentProp(name="enableCamera")
    public void setEnableCamera(Boolean bl) {
        this.normalParam.setVideoOff(bl == false);
        this.setLogToConsole("setEnableCamera:" + bl);
    }

    @WXComponentProp(name="streamId")
    public void setStreamId(String string) {
        this.subStreamId = string;
        this.setLogToConsole("setStreamId:" + this.subStreamId);
    }

    @WXComponentProp(name="rtcLogToConsole")
    public void setRtcLogToConsole(Boolean bl) {
        this.setLogToConsole("setRtcLogToConsole:" + bl);
        this.isLogToConsole = bl;
    }

    @WXComponentProp(name="openSpeaker")
    public void openSpeaker(Boolean bl) {
        LiveUntils.isOpenSpeaker = bl;
        if (this.subRtcId != null) {
            if (bl.booleanValue()) {
                LiveUntils.openSpeaker();
            } else {
                LiveUntils.closeSpeaker();
            }
        }
    }

    @JSMethod
    public void play(String string) {
        Log.d((String)TAG, (String)("Subscribe stream data:" + string));
        JSONObject jSONObject = null;
        if (string != null) {
            try {
                jSONObject = JSONObject.parseObject((String)string);
                boolean bl = jSONObject.getBoolean("reopen");
                if (bl && (this.iceConntionCode == LiveUntils.UniappNoticeCode.ICECONNECTION_FAILED.noticeCode || this.iceConntionCode == LiveUntils.UniappNoticeCode.ICECONNECTION_CLOSED.noticeCode)) {
                    this.stop();
                    this.setLogToConsole("stop Subscribe stream  iceConntionCode:" + this.iceConntionCode);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.setLogToConsole("Subscribe stream data:" + string);
            Log.d((String)TAG, (String)"Subscribe stream  parameter is null");
            return;
        }
        this.setLogToConsole("Subscribe stream data:" + string);
        if (this.mediaSession != null) {
            Log.d((String)TAG, (String)"stream has being subscribed");
            this.setLogToConsole("stream has being subscribed");
            return;
        }
        if (LiveUntils.isOpenSpeaker) {
            LiveUntils.openSpeaker();
        } else {
            LiveUntils.closeSpeaker();
        }
        this.mediaSession = new EMediaSession();
        if (jSONObject != null) {
            this.mediaSession.sessionId = jSONObject.getString("sessId");
            this.subStreamId = jSONObject.getString("streamId");
        }
        if (this.mediaSession.sessionId == null || this.subStreamId == null) {
            this.subStreamId = null;
            this.subRtcId = null;
            this.mediaSession = null;
            this.normalParam.init();
            this.setLogToConsole("Subscribe  stream parameter:" + string + "is error");
            return;
        }
        EMediaManager.getInstance().subscribe(this.subStreamId, this);
        this.setLogToConsole("Subscribe stream end");
    }

    @JSMethod
    public void stop() {
        this.setLogToConsole("unSubscribe  subStreamId stop");
        if (this.mediaSession == null) {
            Log.d((String)TAG, (String)"unSubscribe failed subStreamId is null");
            this.setLogToConsole("unSubscribe failed subStreamId is null");
            return;
        }
        EMediaManager.getInstance().unsubscribe(this.subStreamId);
        this.subStreamId = null;
        this.subRtcId = null;
        this.mediaSession = null;
        this.normalParam.init();
        this.setLogToConsole("unSubscribe subStreamId end");
    }

    @JSMethod
    public void setData(String string) {
        Log.i((String)TAG, (String)("GET_DATA:" + string));
        this.setLogToConsole("setData:" + string);
        if (string != null) {
            String string2;
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject.containsKey((Object)"sdp")) {
                string2 = jSONObject.getString("sdp");
                EMediaManager.getInstance().setRemoteDescription(this.subRtcId, string2);
            }
            if (jSONObject.containsKey((Object)"cands") && (string2 = jSONObject.getJSONArray("cands")) != null) {
                for (int k = 0; k < string2.size(); ++k) {
                    String string3 = string2.get(k).toString();
                    EMediaManager.getInstance().setRemoteIceCandidate(this.subRtcId, string3);
                }
            }
        }
    }

    public void setCallbackSdp(String string) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)LiveUntils.FEATURE);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("op", (Object)102);
        jSONObject3.put("rtcId", (Object)this.subRtcId);
        jSONObject3.put("sdp", (Object)string);
        jSONObject3.put("subSId", (Object)this.subStreamId);
        jSONObject3.put("cctx", (Object)1);
        jSONObject3.put("sessId", (Object)this.mediaSession.sessionId);
        String string2 = LiveUntils.getStringDate();
        jSONObject3.put("tsxTime", (Object)string2);
        String string3 = LiveUntils.generateTsxId();
        jSONObject3.put("tsxId", (Object)string3);
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.DATA.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    @JSMethod(uiThread=false)
    public void setCallbackCand(String string) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)LiveUntils.FEATURE);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("op", (Object)105);
        jSONObject3.put("rtcId", (Object)this.subRtcId);
        JSONArray jSONArray = new JSONArray();
        string = string.replace("\\", "");
        jSONArray.add((Object)string);
        jSONObject3.put("cands", (Object)jSONArray);
        jSONObject3.put("sessId", (Object)this.mediaSession.sessionId);
        String string2 = LiveUntils.getStringDate();
        jSONObject3.put("tsxTime", (Object)string2);
        String string3 = LiveUntils.generateTsxId();
        jSONObject3.put("tsxId", (Object)string3);
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.DATA.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setStateChange(int n, String string) {
        if (n >= LiveUntils.UniappNoticeCode.ICECONNECTION_NEW.noticeCode && n <= LiveUntils.UniappNoticeCode.ICECONNECTION_DISCONNECTED.noticeCode) {
            this.iceConntionCode = n;
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("code", (Object)n);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("streamId", (Object)this.subStreamId);
        jSONObject3.put("description", (Object)string);
        jSONObject3.put("isPusher", (Object)false);
        jSONObject2.put("info", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.STATECHANGE.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setNetStatus(int n, String string) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("code", (Object)n);
        jSONObject2.put("info", (Object)string);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.NETSATTUS.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setStats(RtcConnection rtcConnection, RtcConnection.RtcStatistics rtcStatistics) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        jSONObject2.put("aKBps", (Object)rtcStatistics.remoteAudioBps);
        jSONObject2.put("aP", (Object)rtcStatistics.remoteAudioPacket);
        jSONObject2.put("aPL", (Object)rtcStatistics.remoteAudioPacketsLost);
        jSONObject2.put("aPLR", (Object)rtcStatistics.remoteAudioPacketsLostrate);
        jSONObject2.put("vKBps", (Object)rtcStatistics.remoteVideoBps);
        jSONObject2.put("vFps", (Object)rtcStatistics.remoteFps);
        jSONObject2.put("vW", (Object)rtcStatistics.remoteWidth);
        jSONObject2.put("vH", (Object)rtcStatistics.remoteHeight);
        jSONObject2.put("vP", (Object)rtcStatistics.remoteVideoPacket);
        jSONObject2.put("vPL", (Object)rtcStatistics.remoteVideoPacketsLost);
        jSONObject2.put("vPLR", (Object)rtcStatistics.remoteAudioPacketsLostrate);
        jSONObject2.put("audioInputLevel", (Object)rtcStatistics.audioInputLevel);
        jSONObject2.put("streamType", (Object)rtcStatistics.audioInputLevel);
        jSONObject2.put("appCPUUsage", (Object)rtcStatistics.appCPUUsage);
        jSONObject2.put("systemCPUUsage", (Object)rtcStatistics.systemCPUUsage);
        jSONObject2.put("streamId", (Object)EMediaManager.getInstance().getStreamId(rtcConnection));
        jSONObject2.put("rtcId", (Object)rtcConnection.name);
        jSONObject2.put("isPub", (Object)false);
        jSONObject2.put("aCodec", (Object)rtcConnection.getRuseacodectype());
        jSONObject2.put("vCodec", (Object)rtcConnection.getRusevcodectype());
        jSONObject3.put("data", (Object)jSONObject2);
        jSONObject.put("detail", (Object)jSONObject3);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.STATS.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setLogToConsole(String string) {
        LogUtils.d((Object)(" EMLivePlayerWXModule  streamId:" + this.subStreamId + " " + string));
        if (this.isLogToConsole) {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)LiveUntils.LOG);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("rtcId", (Object)this.subRtcId);
            jSONObject3.put("logInfo", (Object)string);
            jSONObject2.put("data", (Object)jSONObject3);
            jSONObject.put("detail", (Object)jSONObject2);
            Message message = Message.obtain();
            message.what = LiveUntils.LiveCallBackType.DATA.Code;
            message.obj = jSONObject;
            this.handler.sendMessage(message);
        }
    }

    private void createHandle() {
        this.handler = new Handler(this.mainContext.getMainLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 0: {
                        EMLivePlayerWXModule.this.fireEvent(LiveUntils.BIND_STATE_CHANGE, (Map)((JSONObject)message.obj));
                        break;
                    }
                    case 1: {
                        EMLivePlayerWXModule.this.fireEvent(LiveUntils.BIND_NET_STATUS, (Map)((JSONObject)message.obj));
                        break;
                    }
                    case 2: {
                        EMLivePlayerWXModule.this.fireEvent(LiveUntils.CALLBACK_DATA, (Map)((JSONObject)message.obj));
                        Log.e((String)EMLivePlayerWXModule.TAG, (String)("LivePlayer setCallback data :" + message.obj.toString()));
                        break;
                    }
                    case 3: {
                        EMLivePlayerWXModule.this.fireEvent(LiveUntils.CALLBACK_STATS, (Map)((JSONObject)message.obj));
                    }
                }
            }
        };
    }

    public void setSubRtcId(String string) {
        this.subRtcId = string;
    }

    public String getSubRtcId() {
        return this.subRtcId;
    }

    public EMUniStreamParam getNormalParam() {
        return this.normalParam;
    }

    public void onActivityResume() {
        super.onActivityResume();
    }

    public void onActivityPause() {
        super.onActivityPause();
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        this.stop();
    }
}

