/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.os.Handler;
import android.os.HandlerThread;
import com.superrtc.EglBase;
import com.superrtc.Logging;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;
import com.superrtc.YuvConverter;
import com.superrtc.YuvHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;

public class VideoFileRenderer
implements VideoSink {
    private static final String TAG = "VideoFileRenderer";
    private final HandlerThread renderThread;
    private final Handler renderThreadHandler;
    private final HandlerThread fileThread;
    private final Handler fileThreadHandler;
    private final FileOutputStream videoOutFile;
    private final String outputFileName;
    private final int outputFileWidth;
    private final int outputFileHeight;
    private final int outputFrameSize;
    private final ByteBuffer outputFrameBuffer;
    private EglBase eglBase;
    private YuvConverter yuvConverter;
    private int frameCount;

    public VideoFileRenderer(String string, int n, int n2, final EglBase.Context context) throws IOException {
        if (n % 2 == 1 || n2 % 2 == 1) {
            throw new IllegalArgumentException("Does not support uneven width or height");
        }
        this.outputFileName = string;
        this.outputFileWidth = n;
        this.outputFileHeight = n2;
        this.outputFrameSize = n * n2 * 3 / 2;
        this.outputFrameBuffer = ByteBuffer.allocateDirect(this.outputFrameSize);
        this.videoOutFile = new FileOutputStream(string);
        this.videoOutFile.write(("YUV4MPEG2 C420 W" + n + " H" + n2 + " Ip F30:1 A1:1\n").getBytes(Charset.forName("US-ASCII")));
        this.renderThread = new HandlerThread("VideoFileRendererRenderThread");
        this.renderThread.start();
        this.renderThreadHandler = new Handler(this.renderThread.getLooper());
        this.fileThread = new HandlerThread("VideoFileRendererFileThread");
        this.fileThread.start();
        this.fileThreadHandler = new Handler(this.fileThread.getLooper());
        ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

            @Override
            public void run() {
                VideoFileRenderer.this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
                VideoFileRenderer.this.eglBase.createDummyPbufferSurface();
                VideoFileRenderer.this.eglBase.makeCurrent();
                VideoFileRenderer.this.yuvConverter = new YuvConverter();
            }
        });
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        this.renderThreadHandler.post(() -> this.renderFrameOnRenderThread(videoFrame));
    }

    private void renderFrameOnRenderThread(VideoFrame videoFrame) {
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        int n = videoFrame.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n2 = videoFrame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f2 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f3 = (float)n / (float)n2;
        int n3 = buffer.getWidth();
        int n4 = buffer.getHeight();
        if (f3 > f2) {
            n4 = (int)((float)n4 * (f2 / f3));
        } else {
            n3 = (int)((float)n3 * (f3 / f2));
        }
        int n5 = (buffer.getWidth() - n3) / 2;
        int n6 = (buffer.getHeight() - n4) / 2;
        VideoFrame.Buffer buffer2 = buffer.cropAndScale(n5, n6, n3, n4, n, n2);
        videoFrame.release();
        VideoFrame.I420Buffer i420Buffer = buffer2.toI420();
        buffer2.release();
        this.fileThreadHandler.post(() -> {
            YuvHelper.I420Rotate(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), this.outputFrameBuffer, i420Buffer.getWidth(), i420Buffer.getHeight(), videoFrame.getRotation());
            i420Buffer.release();
            try {
                this.videoOutFile.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
                this.videoOutFile.write(this.outputFrameBuffer.array(), this.outputFrameBuffer.arrayOffset(), this.outputFrameSize);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error writing video to disk", iOException);
            }
            ++this.frameCount;
        });
    }

    public void release() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.renderThreadHandler.post(() -> {
            this.yuvConverter.release();
            this.eglBase.release();
            this.renderThread.quit();
            countDownLatch.countDown();
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        this.fileThreadHandler.post(() -> {
            try {
                this.videoOutFile.close();
                Logging.d(TAG, "Video written to disk as " + this.outputFileName + ". The number of frames is " + this.frameCount + " and the dimensions of the frames are " + this.outputFileWidth + "x" + this.outputFileHeight + ".");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error closing output file", iOException);
            }
            this.fileThread.quit();
        });
        try {
            this.fileThread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Logging.e(TAG, "Interrupted while waiting for the write to disk to complete.", interruptedException);
        }
    }
}

