/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.FBOprogram;

import android.opengl.GLES20;
import android.util.Log;

public class ShaderHelper {
    private static final String TAG = "ShaderHelper";

    public static int compileVertexShader(String string) {
        return ShaderHelper.compileShader(35633, string);
    }

    public static int compileFragmentShader(String string) {
        return ShaderHelper.compileShader(35632, string);
    }

    private static int compileShader(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        if (n2 == 0) {
            Log.w((String)TAG, (String)(" Warning! Could not create new shader, glGetError:" + GLES20.glGetError()));
            return 0;
        }
        GLES20.glShaderSource((int)n2, (String)string);
        GLES20.glCompileShader((int)n2);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        Log.i((String)TAG, (String)("Result of compiling source:\n" + string + "\n" + GLES20.glGetShaderInfoLog((int)n2)));
        if (nArray[0] == 0) {
            GLES20.glDeleteShader((int)n2);
            Log.w((String)TAG, (String)(" Warning! Compilation of shader failed, glGetError:" + GLES20.glGetError()));
            return 0;
        }
        return n2;
    }

    public static int linkProgram(int n, int n2) {
        int n3 = GLES20.glCreateProgram();
        if (n3 == 0) {
            Log.w((String)TAG, (String)(" Warning! Could not create new program, glGetError:" + GLES20.glGetError()));
            return 0;
        }
        GLES20.glAttachShader((int)n3, (int)n);
        GLES20.glAttachShader((int)n3, (int)n2);
        GLES20.glLinkProgram((int)n3);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
        Log.i((String)TAG, (String)("Result of linking program:" + GLES20.glGetProgramInfoLog((int)n3)));
        if (nArray[0] == 0) {
            GLES20.glDeleteProgram((int)n3);
            Log.w((String)TAG, (String)(" Warning! Linking of program failed, glGetError:" + GLES20.glGetError()));
            return 0;
        }
        return n3;
    }

    public static boolean validateProgram(int n) {
        GLES20.glValidateProgram((int)n);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n, (int)35715, (int[])nArray, (int)0);
        Log.i((String)TAG, (String)("Result of validating program:" + nArray[0] + "\nLog:" + GLES20.glGetProgramInfoLog((int)n)));
        return nArray[0] != 0;
    }

    public static int buildProgram(String string, String string2) {
        int n = ShaderHelper.compileVertexShader(string);
        int n2 = ShaderHelper.compileFragmentShader(string2);
        int n3 = ShaderHelper.linkProgram(n, n2);
        ShaderHelper.validateProgram(n3);
        return n3;
    }
}

