/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

import java.util.List;

/**
 * \~chinease
 * 聊天会话变更的监听器
 *
 * \~english
 * Refesh conversation list UI when this callback is received
 */
public interface EMConversationListener {

	/**
     * \~chinese
	 * 会话变更回调函数
     *
     * \~english
	 * callback when conversation updated
	 */
    void onCoversationUpdate();

	/**
	 * \~chinese
	 * 收到会话已读回调函数
	 * @param from 发送channel ack方
	 * @param to   接收channel ack方
	 *
	 * \~english
	 * received conversation read ack
	 * @param from the username who send channel ack
	 * @param to   the username who receive channel ack
	 */
	void onConversationRead(String from, String to);
}
