/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Environment;
import com.apkfuns.log2file.LogFileEngineFactory;
import com.apkfuns.logutils.LogUtils;
import com.apkfuns.logutils.file.LogFileEngine;
import com.superrtc.PeerConnection;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.util.EMUniStreamParam;
import com.superrtc.util.HeadsetPlugReceiver;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class LiveUntils {
    public static String BIND_STATE_CHANGE = "bindstatechange";
    public static String BIND_NET_STATUS = "bindnetstatus";
    public static String CALLBACK_DATA = "callbackData";
    public static String CALLBACK_STATS = "callbackStats";
    public static String FEATURE = "feature";
    public static String CUSTOM = "custom";
    public static String LOG = "log";
    private static HeadsetPlugReceiver headsetPlugReceiver;
    public static int mic_disabled_time;
    public static boolean is_uniapp;
    public static EMediaPublishConfiguration config;
    private static AudioManager audioManager;
    public static boolean isOpenSpeaker;

    public static void initGlobal(boolean bl, Context context) {
        if (is_uniapp != bl && (is_uniapp = bl)) {
            System.loadLibrary("hyphenate_av");
            EMediaManager.initGlobal(context);
            audioManager = (AudioManager)context.getSystemService("audio");
            headsetPlugReceiver = new HeadsetPlugReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            context.registerReceiver((BroadcastReceiver)headsetPlugReceiver, intentFilter);
            LogUtils.getLogConfig().configAllowLog(true).configTagPrefix("Easemob").configShowBorders(true).configFormatTag("%d{HH:mm:ss:SSS} %t %c{-5}");
            String string = LiveUntils.getFilePath(context, "logs");
            LogUtils.getLog2FileConfig().configLog2FileEnable(true).configLog2FilePath(string).configLog2FileNameFormat("UinApp%d{yyyyMMdd}.txt").configLogFileEngine((LogFileEngine)new LogFileEngineFactory(context));
        }
    }

    public static String getFilePath(Context context, String string) {
        String string2 = "";
        string2 = "mounted".equals(Environment.getExternalStorageState()) ? context.getExternalFilesDir(string).getAbsolutePath() : context.getFilesDir() + File.separator + string;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string2;
    }

    private void registerHeadsetPlugReceiver() {
    }

    public static EMediaPublishConfiguration configWrap(EMUniStreamParam eMUniStreamParam) {
        if (eMUniStreamParam == null) {
            return null;
        }
        config = eMUniStreamParam.streamType == EMUniStreamParam.StreamType.NORMAL ? EMediaPublishConfiguration.initNormalConfig() : EMediaPublishConfiguration.initDesktopConfig();
        config.setExtension(eMUniStreamParam.extension);
        config.setMute(eMUniStreamParam.audioOff);
        config.setVideoOff(eMUniStreamParam.videoOff);
        if (eMUniStreamParam.videoWidth > 0) {
            config.setVwidth(eMUniStreamParam.videoWidth);
        }
        if (eMUniStreamParam.videoHeight > 0) {
            config.setVheight(eMUniStreamParam.videoHeight);
        }
        config.setPubView(eMUniStreamParam.shareView);
        config.setUseBackCamera(eMUniStreamParam.useBackCamera);
        config.setMaxVideoKbps(eMUniStreamParam.maxVideoKbps);
        config.setMaxAudioKbps(eMUniStreamParam.maxAudioKbps);
        config.setExternalVideoSource(eMUniStreamParam.usingExternalSource);
        RtcConnection.enableFixedVideoResolution(eMUniStreamParam.enableFixedVideoResolution);
        if (eMUniStreamParam.minVideoKbps > 0) {
            RtcConnection.setMinVideoKbps(eMUniStreamParam.minVideoKbps);
        }
        RtcConnection.setAudioSampleRate(eMUniStreamParam.audioSampleRate);
        RtcConnection.setIsClarityFirst(eMUniStreamParam.isClarityFirst);
        return config;
    }

    public static UniappNoticeCode ConvertUniappCode(PeerConnection.IceConnectionState iceConnectionState) {
        switch (iceConnectionState) {
            case NEW: {
                return UniappNoticeCode.ICECONNECTION_NEW;
            }
            case CHECKING: {
                return UniappNoticeCode.ICECONNECTION_CHECKING;
            }
            case COMPLETED: {
                return UniappNoticeCode.ICECONNECTION_COMPLETED;
            }
            case CONNECTED: {
                return UniappNoticeCode.ICECONNECTION_CONNECTED;
            }
            case FAILED: {
                return UniappNoticeCode.ICECONNECTION_FAILED;
            }
            case DISCONNECTED: {
                return UniappNoticeCode.ICECONNECTION_DISCONNECTED;
            }
            case CLOSED: {
                return UniappNoticeCode.ICECONNECTION_CLOSED;
            }
        }
        return UniappNoticeCode.ICECONNECTION_NEW;
    }

    public static String generateRtcId() {
        String string = "rtc";
        String string2 = LiveUntils.getRandomString(3);
        int n = -1;
        Random random = new Random();
        n = random.nextInt(9) + 0;
        String string3 = String.format("%s-%d-%s", string, n, string2);
        return string3;
    }

    public static String generateTsxId() {
        String string = LiveUntils.getRandomString(4);
        String string2 = LiveUntils.getRandomString(4);
        int n = -1;
        Random random = new Random();
        n = random.nextInt(1000) + 0;
        String string3 = String.format("%s-%d-%s", string, n, string2);
        return string3;
    }

    static String getRandomString(int n) {
        String string = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        for (int k = 0; k < n; ++k) {
            int n2 = random.nextInt(26);
            stringBuffer.append(string.charAt(n2));
        }
        return stringBuffer.toString();
    }

    public static String getStringDate() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static void openSpeaker() {
        if (!audioManager.isSpeakerphoneOn()) {
            audioManager.setSpeakerphoneOn(true);
        }
        audioManager.setMode(3);
    }

    public static void closeSpeaker() {
        if (audioManager.isSpeakerphoneOn()) {
            audioManager.setSpeakerphoneOn(false);
        }
        audioManager.setMode(3);
    }

    static {
        mic_disabled_time = 0;
        is_uniapp = false;
        config = null;
        isOpenSpeaker = true;
    }

    public static enum UniappNoticeCode {
        ICECONNECTION_NEW(2000),
        ICECONNECTION_CHECKING(2001),
        ICECONNECTION_CONNECTED(2002),
        ICECONNECTION_COMPLETED(2003),
        ICECONNECTION_FAILED(2004),
        ICECONNECTION_CLOSED(2005),
        ICECONNECTION_DISCONNECTED(2006),
        SEND_FIRST_AUDIO_FRAME(2100),
        SEND_FIRST_VIDEO_FRAME(2101),
        RECV_FIRST_AUDIO_FRAME(2102),
        RECV_FIRST_VIDEO_FRAME(2103),
        HAS_NO_AUDIO_DATA(2104),
        HAS_NO_VIDEO_DATA(2105),
        OPEN_CRAMERA_FAILED(3000),
        OPEN_MIC_FAILED(3001),
        MEDIA_CONNECTED(4000),
        MEDIA_POORQUALITY(4001),
        MEDIA_DISCONNECTED(4002);

        public final int noticeCode;

        private UniappNoticeCode(int n2) {
            this.noticeCode = n2;
        }
    }

    public static enum LiveCallBackType {
        STATECHANGE(0),
        NETSATTUS(1),
        DATA(2),
        STATS(3);

        public final int Code;

        private LiveCallBackType(int n2) {
            this.Code = n2;
        }
    }
}

