/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@TargetApi(value=19)
public class CpuMonitor {
    private static final String TAG = "CpuMonitor";
    private static final int MOVING_AVERAGE_SAMPLES = 5;
    private static final int CPU_STAT_SAMPLE_PERIOD_MS = 2000;
    private static final int CPU_STAT_LOG_PERIOD_MS = 6000;
    private final Context appContext;
    private final MovingAverage userCpuUsage;
    private final MovingAverage systemCpuUsage;
    private final MovingAverage totalCpuUsage;
    private final MovingAverage frequencyScale;
    @Nullable
    private ScheduledExecutorService executor;
    private long lastStatLogTimeMs;
    private long[] cpuFreqMax;
    private int cpusPresent;
    private int actualCpusPresent;
    private boolean initialized;
    private boolean cpuOveruse;
    private String[] maxPath;
    private String[] curPath;
    private double[] curFreqScales;
    @Nullable
    private ProcStat lastProcStat;

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 24;
    }

    public CpuMonitor(Context context) {
        if (!CpuMonitor.isSupported()) {
            throw new RuntimeException("CpuMonitor is not supported on this Android version.");
        }
        Log.d((String)TAG, (String)"CpuMonitor ctor.");
        this.appContext = context.getApplicationContext();
        this.userCpuUsage = new MovingAverage(5);
        this.systemCpuUsage = new MovingAverage(5);
        this.totalCpuUsage = new MovingAverage(5);
        this.frequencyScale = new MovingAverage(5);
        this.lastStatLogTimeMs = SystemClock.elapsedRealtime();
        this.scheduleCpuUtilizationTask();
    }

    public void pause() {
        if (this.executor != null) {
            Log.d((String)TAG, (String)"pause");
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    public void resume() {
        Log.d((String)TAG, (String)"resume");
        this.resetStat();
        this.scheduleCpuUtilizationTask();
    }

    public synchronized void reset() {
        if (this.executor != null) {
            Log.d((String)TAG, (String)"reset");
            this.resetStat();
            this.cpuOveruse = false;
        }
    }

    public synchronized int getCpuUsageCurrent() {
        return this.doubleToPercent(this.userCpuUsage.getCurrent() + this.systemCpuUsage.getCurrent());
    }

    public synchronized int getCpuUsageAverage() {
        return this.doubleToPercent(this.userCpuUsage.getAverage() + this.systemCpuUsage.getAverage());
    }

    public synchronized int getFrequencyScaleAverage() {
        return this.doubleToPercent(this.frequencyScale.getAverage());
    }

    private void scheduleCpuUtilizationTask() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CpuMonitor.this.cpuUtilizationTask();
            }
        }, 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    private void cpuUtilizationTask() {
        boolean bl = this.sampleCpuUtilization();
        if (bl && SystemClock.elapsedRealtime() - this.lastStatLogTimeMs >= 6000L) {
            this.lastStatLogTimeMs = SystemClock.elapsedRealtime();
            String string = this.getStatString();
            Log.d((String)TAG, (String)string);
        }
    }

    private void init() {
        try (FileInputStream fileInputStream = new FileInputStream("/sys/devices/system/cpu/present");
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
             Scanner scanner = new Scanner(bufferedReader).useDelimiter("[-\n]");){
            scanner.nextInt();
            this.cpusPresent = 1 + scanner.nextInt();
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)TAG, (String)"Cannot do CPU stats since /sys/devices/system/cpu/present is missing");
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Cannot do CPU stats due to /sys/devices/system/cpu/present parsing problem");
        }
        this.cpuFreqMax = new long[this.cpusPresent];
        this.maxPath = new String[this.cpusPresent];
        this.curPath = new String[this.cpusPresent];
        this.curFreqScales = new double[this.cpusPresent];
        for (int k = 0; k < this.cpusPresent; ++k) {
            this.cpuFreqMax[k] = 0L;
            this.curFreqScales[k] = 0.0;
            this.maxPath[k] = "/sys/devices/system/cpu/cpu" + k + "/cpufreq/cpuinfo_max_freq";
            this.curPath[k] = "/sys/devices/system/cpu/cpu" + k + "/cpufreq/scaling_cur_freq";
        }
        this.lastProcStat = new ProcStat(0L, 0L, 0L);
        this.resetStat();
        this.initialized = true;
    }

    private synchronized void resetStat() {
        this.userCpuUsage.reset();
        this.systemCpuUsage.reset();
        this.totalCpuUsage.reset();
        this.frequencyScale.reset();
        this.lastStatLogTimeMs = SystemClock.elapsedRealtime();
    }

    private int getBatteryLevel() {
        Intent intent = this.appContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int n = 0;
        int n2 = intent.getIntExtra("scale", 100);
        if (n2 > 0) {
            n = (int)(100.0f * (float)intent.getIntExtra("level", 0) / (float)n2);
        }
        return n;
    }

    private synchronized boolean sampleCpuUtilization() {
        ProcStat procStat;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (!this.initialized) {
            this.init();
        }
        if (this.cpusPresent == 0) {
            return false;
        }
        this.actualCpusPresent = 0;
        for (int k = 0; k < this.cpusPresent; ++k) {
            long l4;
            this.curFreqScales[k] = 0.0;
            if (this.cpuFreqMax[k] == 0L) {
                l4 = this.readFreqFromFile(this.maxPath[k]);
                if (l4 > 0L) {
                    Log.d((String)TAG, (String)("Core " + k + ". Max frequency: " + l4));
                    l = l4;
                    this.cpuFreqMax[k] = l4;
                    this.maxPath[k] = null;
                }
            } else {
                l = this.cpuFreqMax[k];
            }
            l4 = this.readFreqFromFile(this.curPath[k]);
            if (l4 == 0L && l == 0L) continue;
            if (l4 > 0L) {
                ++this.actualCpusPresent;
            }
            l2 += l4;
            l3 += l;
            if (l <= 0L) continue;
            this.curFreqScales[k] = (double)l4 / (double)l;
        }
        if (l2 == 0L || l3 == 0L) {
            Log.e((String)TAG, (String)"Could not read max or current frequency for any CPU");
            return false;
        }
        double d2 = (double)l2 / (double)l3;
        if (this.frequencyScale.getCurrent() > 0.0) {
            d2 = (this.frequencyScale.getCurrent() + d2) * 0.5;
        }
        if ((procStat = this.readProcStat()) == null) {
            return false;
        }
        long l5 = procStat.userTime - this.lastProcStat.userTime;
        long l6 = procStat.systemTime - this.lastProcStat.systemTime;
        long l7 = procStat.idleTime - this.lastProcStat.idleTime;
        long l8 = l5 + l6 + l7;
        if (d2 == 0.0 || l8 == 0L) {
            return false;
        }
        this.frequencyScale.addValue(d2);
        double d3 = (double)l5 / (double)l8;
        this.userCpuUsage.addValue(d3);
        double d4 = (double)l6 / (double)l8;
        this.systemCpuUsage.addValue(d4);
        double d5 = (d3 + d4) * d2;
        this.totalCpuUsage.addValue(d5);
        this.lastProcStat = procStat;
        return true;
    }

    private int doubleToPercent(double d2) {
        return (int)(d2 * 100.0 + 0.5);
    }

    private synchronized String getStatString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CPU User: ").append(this.doubleToPercent(this.userCpuUsage.getCurrent())).append("/").append(this.doubleToPercent(this.userCpuUsage.getAverage())).append(". System: ").append(this.doubleToPercent(this.systemCpuUsage.getCurrent())).append("/").append(this.doubleToPercent(this.systemCpuUsage.getAverage())).append(". Freq: ").append(this.doubleToPercent(this.frequencyScale.getCurrent())).append("/").append(this.doubleToPercent(this.frequencyScale.getAverage())).append(". Total usage: ").append(this.doubleToPercent(this.totalCpuUsage.getCurrent())).append("/").append(this.doubleToPercent(this.totalCpuUsage.getAverage())).append(". Cores: ").append(this.actualCpusPresent);
        stringBuilder.append("( ");
        for (int k = 0; k < this.cpusPresent; ++k) {
            stringBuilder.append(this.doubleToPercent(this.curFreqScales[k])).append(" ");
        }
        stringBuilder.append("). Battery: ").append(this.getBatteryLevel());
        if (this.cpuOveruse) {
            stringBuilder.append(". Overuse.");
        }
        return stringBuilder.toString();
    }

    private long readFreqFromFile(String string) {
        long l = 0L;
        try (FileInputStream fileInputStream = new FileInputStream(string);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2 = bufferedReader.readLine();
            l = CpuMonitor.parseLong(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    private static long parseLong(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Log.e((String)TAG, (String)"parseLong error.", (Throwable)numberFormatException);
        }
        return l;
    }

    @Nullable
    private ProcStat readProcStat() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try (FileInputStream fileInputStream = new FileInputStream("/proc/stat");
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string = bufferedReader.readLine();
            String[] stringArray = string.split("\\s+");
            int n = stringArray.length;
            if (n >= 5) {
                l = CpuMonitor.parseLong(stringArray[1]);
                l += CpuMonitor.parseLong(stringArray[2]);
                l2 = CpuMonitor.parseLong(stringArray[3]);
                l3 = CpuMonitor.parseLong(stringArray[4]);
            }
            if (n >= 8) {
                l += CpuMonitor.parseLong(stringArray[5]);
                l2 += CpuMonitor.parseLong(stringArray[6]);
                l2 += CpuMonitor.parseLong(stringArray[7]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)TAG, (String)"Cannot open /proc/stat for reading", (Throwable)fileNotFoundException);
            return null;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Problems parsing /proc/stat", (Throwable)exception);
            return null;
        }
        return new ProcStat(l, l2, l3);
    }

    private static class MovingAverage {
        private final int size;
        private double sum;
        private double currentValue;
        private double[] circBuffer;
        private int circBufferIndex;

        public MovingAverage(int n) {
            if (n <= 0) {
                throw new AssertionError((Object)"Size value in MovingAverage ctor should be positive.");
            }
            this.size = n;
            this.circBuffer = new double[n];
        }

        public void reset() {
            Arrays.fill(this.circBuffer, 0.0);
            this.circBufferIndex = 0;
            this.sum = 0.0;
            this.currentValue = 0.0;
        }

        public void addValue(double d2) {
            this.sum -= this.circBuffer[this.circBufferIndex];
            this.circBuffer[this.circBufferIndex++] = d2;
            this.currentValue = d2;
            this.sum += d2;
            if (this.circBufferIndex >= this.size) {
                this.circBufferIndex = 0;
            }
        }

        public double getCurrent() {
            return this.currentValue;
        }

        public double getAverage() {
            return this.sum / (double)this.size;
        }
    }

    private static class ProcStat {
        final long userTime;
        final long systemTime;
        final long idleTime;

        ProcStat(long l, long l2, long l3) {
            this.userTime = l;
            this.systemTime = l2;
            this.idleTime = l3;
        }
    }
}

