/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.livepusher;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.superrtc.livepusher.Permissions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class PermissionsResultAction {
    private static final String TAG = PermissionsResultAction.class.getSimpleName();
    private final Set<String> mPermissions = new HashSet<String>(1);
    private Looper mLooper = Looper.getMainLooper();

    public PermissionsResultAction() {
    }

    public PermissionsResultAction(@NonNull Looper looper) {
        this.mLooper = looper;
    }

    public abstract void onGranted();

    public abstract void onDenied(String var1);

    public synchronized boolean shouldIgnorePermissionNotFound(String string) {
        Log.d((String)TAG, (String)("Permission not found: " + string));
        return true;
    }

    @CallSuper
    protected final synchronized boolean onResult(@NonNull String string, int n) {
        if (n == 0) {
            return this.onResult(string, Permissions.GRANTED);
        }
        return this.onResult(string, Permissions.DENIED);
    }

    @CallSuper
    protected final synchronized boolean onResult(final @NonNull String string, Permissions permissions) {
        this.mPermissions.remove(string);
        if (permissions == Permissions.GRANTED) {
            if (this.mPermissions.isEmpty()) {
                new Handler(this.mLooper).post(new Runnable(){

                    @Override
                    public void run() {
                        PermissionsResultAction.this.onGranted();
                    }
                });
                return true;
            }
        } else {
            if (permissions == Permissions.DENIED) {
                new Handler(this.mLooper).post(new Runnable(){

                    @Override
                    public void run() {
                        PermissionsResultAction.this.onDenied(string);
                    }
                });
                return true;
            }
            if (permissions == Permissions.NOT_FOUND) {
                if (this.shouldIgnorePermissionNotFound(string)) {
                    if (this.mPermissions.isEmpty()) {
                        new Handler(this.mLooper).post(new Runnable(){

                            @Override
                            public void run() {
                                PermissionsResultAction.this.onGranted();
                            }
                        });
                        return true;
                    }
                } else {
                    new Handler(this.mLooper).post(new Runnable(){

                        @Override
                        public void run() {
                            PermissionsResultAction.this.onDenied(string);
                        }
                    });
                    return true;
                }
            }
        }
        return false;
    }

    @CallSuper
    protected final synchronized void registerPermissions(@NonNull String[] stringArray) {
        Collections.addAll(this.mPermissions, stringArray);
    }
}

