/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.livepusher;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.apkfuns.logutils.LogUtils;
import com.superrtc.livepusher.PermissionsManager;
import com.superrtc.livepusher.PermissionsResultAction;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.VideoView;
import com.superrtc.util.EMUniAppSurfaceView;
import com.superrtc.util.EMUniStreamParam;
import com.superrtc.util.LiveUntils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import java.util.Map;

public class EMLivePushWXModule
extends WXComponent<EMUniAppSurfaceView> {
    private EMUniStreamParam normalParam;
    private static final String TAG = "EMLivePushWXModule";
    private String localStreamId = null;
    private String localRtcId;
    private EMediaSession mediaSession;
    private Context mainContext;
    private Handler handler;
    private String codec;
    private boolean isLogToConsole = false;
    private boolean reOpen = false;
    private int iceConntionCode;

    public EMLivePushWXModule(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.iceConntionCode = LiveUntils.UniappNoticeCode.ICECONNECTION_NEW.noticeCode;
    }

    protected EMUniAppSurfaceView initComponentHostView(@NonNull Context context) {
        EMUniAppSurfaceView eMUniAppSurfaceView = new EMUniAppSurfaceView(context);
        LiveUntils.initGlobal(true, this.getContext());
        this.mainContext = context;
        this.normalParam = new EMUniStreamParam();
        this.localRtcId = LiveUntils.generateRtcId();
        this.createHandle();
        LiveUntils.mic_disabled_time = 0;
        this.requestPermissions();
        this.setLogToConsole("create EMLivePushWXModule success");
        return eMUniAppSurfaceView;
    }

    @WXComponentProp(name="objectFit")
    public void setObjectFit(String string) {
        if (string.equals("fill")) {
            ((EMUniAppSurfaceView)this.getHostView()).setScaleMode(VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFill);
        } else if (string.equals("fit")) {
            ((EMUniAppSurfaceView)this.getHostView()).setScaleMode(VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit);
        }
        this.setLogToConsole("setObjectFit:" + string);
    }

    @WXComponentProp(name="muted")
    public void setMuted(Boolean bl) {
        this.normalParam.setAudioOff(bl);
        if (this.mediaSession != null) {
            EMediaManager.getInstance().setMuteEnabled(bl);
            this.setOptionCallBack();
        }
        this.setLogToConsole("setMuted:" + bl);
    }

    @WXComponentProp(name="enableCamera")
    public void setEnableCamera(Boolean bl) {
        this.normalParam.setVideoOff(bl == false);
        if (this.mediaSession != null) {
            EMediaManager.getInstance().setVideoEnabled(bl);
            this.setOptionCallBack();
        }
        this.setLogToConsole("setEnableCamera:" + bl);
    }

    @WXComponentProp(name="devicePosition")
    public void setDevicePosition(String string) {
        if (string.equals("front")) {
            this.normalParam.setUseBackCamera(false);
        } else if (string.equals("back")) {
            this.normalParam.setUseBackCamera(true);
        }
        if (this.mediaSession != null) {
            EMediaManager.getInstance().switchCamera();
        }
        this.setLogToConsole("setDevicePosition:" + string);
    }

    @WXComponentProp(name="videoWidth")
    public void setVideoWidth(int n) {
        this.normalParam.setVideoWidth(n);
        this.setLogToConsole("setVideoWidth:" + n);
    }

    @WXComponentProp(name="videoHeight")
    public void setVideoHeight(int n) {
        this.normalParam.setVideoHeight(n);
        this.setLogToConsole("setVideoHeight:" + n);
    }

    @WXComponentProp(name="minBitrate")
    public void setMinBitrate(int n) {
        this.normalParam.setMinVideoKbps(n);
        this.setLogToConsole("setMinBitrate:" + n);
    }

    @WXComponentProp(name="maxBitrate")
    public void setMaxBitrate(int n) {
        this.normalParam.setVideoWidth(n);
        this.setLogToConsole("setMaxBitrate:" + n);
    }

    @WXComponentProp(name="mirror")
    public void setMirror(boolean bl) {
        if (bl) {
            EMediaManager.getInstance().setLocalVideoViewMirror(RtcConnection.MIRROR.ON);
        } else {
            EMediaManager.getInstance().setLocalVideoViewMirror(RtcConnection.MIRROR.OFF);
        }
        this.setLogToConsole("setMirror:" + bl);
    }

    @WXComponentProp(name="isClarityFirst")
    public void setIsClarityFirst(boolean bl) {
        this.normalParam.setClarityFirst(bl);
        this.setLogToConsole("setIsClarityFirst:" + bl);
    }

    @WXComponentProp(name="rtcLogToConsole")
    public void setRtcLogToConsole(Boolean bl) {
        this.isLogToConsole = bl;
    }

    @JSMethod
    public void start(String string) {
        JSONObject jSONObject = null;
        if (string != null) {
            try {
                jSONObject = JSONObject.parseObject((String)string);
                boolean bl = jSONObject.getBoolean("reopen");
                if (bl && (this.iceConntionCode == LiveUntils.UniappNoticeCode.ICECONNECTION_FAILED.noticeCode || this.iceConntionCode == LiveUntils.UniappNoticeCode.ICECONNECTION_CLOSED.noticeCode)) {
                    this.reOpen = true;
                    this.stop();
                    this.setLogToConsole("stop Publish local iceConntionCode:" + this.iceConntionCode);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"local stream pub parameter is null");
            this.setLogToConsole("local stream pub parameter is null");
            return;
        }
        Log.d((String)TAG, (String)("Publish local stream data:" + string));
        this.setLogToConsole("Publish local stream data:" + string);
        if (this.mediaSession != null) {
            Log.d((String)TAG, (String)"local stream has being published");
            this.setLogToConsole("local stream has being published");
            return;
        }
        this.mediaSession = new EMediaSession();
        if (jSONObject != null) {
            String string2;
            this.mediaSession.rtcCfg = jSONObject.getString("rtcCfg");
            this.mediaSession.myName = jSONObject.getString("uId");
            this.mediaSession.sessionId = jSONObject.getString("sessId");
            JSONArray jSONArray = jSONObject.getJSONArray("vcodes");
            if (jSONArray != null && jSONArray.size() > 0 && ((string2 = jSONArray.getString(0)).equals("H264") || string2.equals("VP8"))) {
                this.codec = string2;
            }
        }
        if (this.mediaSession.rtcCfg == null || this.mediaSession.myName == null || this.mediaSession.sessionId == null) {
            this.mediaSession = null;
            this.normalParam.init();
            this.setLogToConsole("Publish  stream parameter:" + string + "is error");
            return;
        }
        if (this.normalParam.getVideoWidth() == 0 || this.normalParam.getVideoHeight() == 0) {
            this.normalParam.setVideoWidth(960);
            this.normalParam.setVideoHeight(640);
        }
        this.normalParam.setStreamType(EMUniStreamParam.StreamType.NORMAL);
        EMediaPublishConfiguration eMediaPublishConfiguration = LiveUntils.configWrap(this.normalParam);
        if (eMediaPublishConfiguration == null) {
            Log.i((String)TAG, (String)("Publish local stream, video off: " + eMediaPublishConfiguration.isVideoOff() + ", audio off: " + eMediaPublishConfiguration.isMute() + ", stream type: " + (Object)((Object)eMediaPublishConfiguration.getPubType())));
            this.setLogToConsole("Publish local stream, video off: " + eMediaPublishConfiguration.isVideoOff() + ", audio off: " + eMediaPublishConfiguration.isMute() + ", stream type: " + (Object)((Object)eMediaPublishConfiguration.getPubType()));
            this.mediaSession = null;
            this.normalParam.init();
            return;
        }
        EMediaManager.getInstance().publish(this.mediaSession, eMediaPublishConfiguration, this.codec, this.localRtcId, this);
        Log.d((String)TAG, (String)"Publish local stream end");
        this.setLogToConsole("Publish local stream end");
    }

    @JSMethod
    public void stop() {
        this.setLogToConsole("unPublish local stream start");
        Log.d((String)TAG, (String)"unPublish local stream start");
        if (this.mediaSession == null) {
            Log.d((String)TAG, (String)"unPublish failed localStreamId is null");
            this.setLogToConsole("unPublish failed localStreamId is null");
            return;
        }
        EMediaManager.getInstance().unpublish(this.mediaSession, this.localRtcId);
        this.setLogToConsole("unPublish local stream end");
        Log.d((String)TAG, (String)"unPublish local stream end");
        this.mediaSession = null;
        if (!this.reOpen) {
            this.normalParam.init();
        }
        this.reOpen = false;
    }

    @JSMethod
    public void setData(String string) {
        Log.i((String)TAG, (String)("publish setData:" + string));
        this.setLogToConsole("publish setData:" + string);
        if (string != null) {
            String string2;
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            if (jSONObject.containsKey((Object)"sdp")) {
                string2 = jSONObject.getString("sdp");
                EMediaManager.getInstance().setRemoteDescription(this.localRtcId, string2);
            }
            if (jSONObject.containsKey((Object)"cands") && (string2 = jSONObject.getJSONArray("cands")) != null && string2.size() > 0) {
                for (int k = 0; k < string2.size(); ++k) {
                    String string3 = string2.get(k).toString();
                    EMediaManager.getInstance().setRemoteIceCandidate(this.localRtcId, string3);
                }
            }
        }
    }

    public void setCallbackSdp(String string) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)LiveUntils.FEATURE);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("op", (Object)102);
        jSONObject3.put("rtcId", (Object)this.localRtcId);
        jSONObject3.put("sdp", (Object)string);
        JSONObject jSONObject4 = new JSONObject();
        jSONObject4.put("name", (Object)this.mediaSession.myName);
        jSONObject4.put("voff", (Object)(this.normalParam.isVideoOff() ? 1 : 0));
        jSONObject4.put("aoff", (Object)(this.normalParam.isAudioOff() ? 1 : 0));
        jSONObject4.put("type", (Object)this.normalParam.getStreamType().val);
        JSONObject jSONObject5 = new JSONObject();
        jSONObject5.put("w", (Object)this.normalParam.getVideoWidth());
        jSONObject5.put("h", (Object)this.normalParam.getVideoHeight());
        jSONObject4.put("resolution", (Object)jSONObject5);
        jSONObject3.put("pubS", (Object)jSONObject4);
        jSONObject3.put("cctx", (Object)1);
        jSONObject3.put("sessId", (Object)this.mediaSession.sessionId);
        String string2 = LiveUntils.getStringDate();
        jSONObject3.put("tsxTime", (Object)string2);
        String string3 = LiveUntils.generateTsxId();
        jSONObject3.put("tsxId", (Object)string3);
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.DATA.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setCallbackCand(String string) {
        Log.e((String)TAG, (String)("setCallbackCand11:" + string));
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)LiveUntils.FEATURE);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("op", (Object)105);
        jSONObject3.put("rtcId", (Object)this.localRtcId);
        JSONArray jSONArray = new JSONArray();
        string = string.replace("\\", "");
        Log.e((String)TAG, (String)("setCallbackCand11:" + string));
        jSONArray.add((Object)string);
        jSONObject3.put("cands", (Object)jSONArray);
        jSONObject3.put("sessId", (Object)this.mediaSession.sessionId);
        String string2 = LiveUntils.getStringDate();
        jSONObject3.put("tsxTime", (Object)string2);
        String string3 = LiveUntils.generateTsxId();
        jSONObject3.put("tsxId", (Object)string3);
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.DATA.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setOptionCallBack() {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)LiveUntils.FEATURE);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("op", (Object)400);
        jSONObject3.put("rtcId", (Object)this.localRtcId);
        jSONObject3.put("voff", (Object)(this.normalParam.isVideoOff() ? 1 : 0));
        jSONObject3.put("aoff", (Object)(this.normalParam.isAudioOff() ? 1 : 0));
        jSONObject3.put("sessId", (Object)this.mediaSession.sessionId);
        String string = LiveUntils.getStringDate();
        jSONObject3.put("tsxTime", (Object)string);
        String string2 = LiveUntils.generateTsxId();
        jSONObject3.put("tsxId", (Object)string2);
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.DATA.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setStateChange(int n, String string) {
        if (n >= LiveUntils.UniappNoticeCode.ICECONNECTION_NEW.noticeCode && n <= LiveUntils.UniappNoticeCode.ICECONNECTION_DISCONNECTED.noticeCode) {
            this.iceConntionCode = n;
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("code", (Object)n);
        jSONObject2.put("info", (Object)string);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.STATECHANGE.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setNetStatus(int n, String string) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("code", (Object)n);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("streamId", (Object)this.localRtcId);
        jSONObject3.put("description", (Object)string);
        jSONObject3.put("isPusher", (Object)true);
        jSONObject2.put("info", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.STATECHANGE.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setStats(RtcConnection rtcConnection, RtcConnection.RtcStatistics rtcStatistics) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("audioInputLevel", (Object)rtcStatistics.audioInputLevel);
        jSONObject3.put("vP", (Object)rtcStatistics.localVideoPacket);
        jSONObject3.put("vPL", (Object)rtcStatistics.localVideoPacketsLost);
        jSONObject3.put("vPLR", (Object)rtcStatistics.localVideoPacketsLostrate);
        jSONObject3.put("aKBps", (Object)rtcStatistics.localAudioBps);
        jSONObject3.put("aP", (Object)rtcStatistics.localAudioPacket);
        jSONObject3.put("aPL", (Object)rtcStatistics.localAudioPacketsLost);
        jSONObject3.put("aPLR", (Object)rtcStatistics.localAudioPacketsLostrate);
        jSONObject3.put("vKBps", (Object)rtcStatistics.localVideoActualBps);
        jSONObject3.put("vFps", (Object)rtcStatistics.localEncodedFps);
        jSONObject3.put("vW", (Object)rtcStatistics.localEncodedWidth);
        jSONObject3.put("vH", (Object)rtcStatistics.localEncodedHeight);
        jSONObject3.put("appCPUUsage", (Object)rtcStatistics.appCPUUsage);
        jSONObject3.put("systemCPUUsage", (Object)rtcStatistics.systemCPUUsage);
        jSONObject3.put("streamId", (Object)EMediaManager.getInstance().getStreamId(rtcConnection));
        jSONObject3.put("audioInputLevel", (Object)rtcStatistics.audioInputLevel);
        jSONObject3.put("streamType", (Object)((RtcConnectionExt)rtcConnection).pubType);
        jSONObject3.put("rtcId", (Object)rtcConnection.name);
        jSONObject3.put("isPub", (Object)true);
        jSONObject3.put("aCodec", (Object)rtcConnection.getLuseacodectype());
        jSONObject3.put("vCodec", (Object)rtcConnection.getLusevcodectype());
        jSONObject2.put("data", (Object)jSONObject3);
        jSONObject.put("detail", (Object)jSONObject2);
        Message message = Message.obtain();
        message.what = LiveUntils.LiveCallBackType.STATS.Code;
        message.obj = jSONObject;
        this.handler.sendMessage(message);
    }

    public void setLogToConsole(String string) {
        LogUtils.d((Object)(" EMLivePushWXModule  rtcId:" + this.localRtcId + " " + string));
        if (this.isLogToConsole) {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)LiveUntils.LOG);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("rtcId", (Object)this.localRtcId);
            jSONObject3.put("logInfo", (Object)string);
            jSONObject2.put("data", (Object)jSONObject3);
            jSONObject.put("detail", (Object)jSONObject2);
            Message message = Message.obtain();
            message.what = LiveUntils.LiveCallBackType.DATA.Code;
            message.obj = jSONObject;
            this.handler.sendMessage(message);
        }
    }

    private void createHandle() {
        this.handler = new Handler(this.mainContext.getMainLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 0: {
                        EMLivePushWXModule.this.fireEvent(LiveUntils.BIND_STATE_CHANGE, (Map)((JSONObject)message.obj));
                        break;
                    }
                    case 1: {
                        EMLivePushWXModule.this.fireEvent(LiveUntils.BIND_NET_STATUS, (Map)((JSONObject)message.obj));
                        break;
                    }
                    case 2: {
                        EMLivePushWXModule.this.fireEvent(LiveUntils.CALLBACK_DATA, (Map)((JSONObject)message.obj));
                        Log.e((String)EMLivePushWXModule.TAG, (String)("LivePusher setCallback data :" + message.obj.toString()));
                        break;
                    }
                    case 3: {
                        EMLivePushWXModule.this.fireEvent(LiveUntils.CALLBACK_STATS, (Map)((JSONObject)message.obj));
                    }
                }
            }
        };
    }

    public String getLoacalRtcId() {
        return this.localRtcId;
    }

    public EMUniStreamParam getNormalParam() {
        return this.normalParam;
    }

    public boolean isLogToConsole() {
        return this.isLogToConsole;
    }

    @TargetApi(value=23)
    private void requestPermissions() {
        PermissionsManager.getInstance().requestAllManifestPermissionsIfNecessary((Activity)this.mainContext, new PermissionsResultAction(){

            @Override
            public void onGranted() {
            }

            @Override
            public void onDenied(String string) {
            }
        });
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        PermissionsManager.getInstance().notifyPermissionsChange(stringArray, nArray);
    }

    public void onActivityResume() {
        super.onActivityResume();
    }

    public void onActivityPause() {
        super.onActivityPause();
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        this.stop();
    }
}

