/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalInputAudio;

import android.util.Log;
import com.superrtc.externalInputAudio.IInputAudioSource;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class ExternalAudioSource
implements IInputAudioSource {
    private static final String TAG = "ExternalInputAudio";
    private static final int CACHED_BUFFER_SIZE = 500;
    private static IInputAudioSource.LogListener sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
    private int channelCount = 1;
    private int sampleRate = 16000;
    private boolean micDisable = false;
    int writeBufferCount = 0;
    int readBufferCount = 0;
    int logBufferCount = 1000;
    private final ArrayDeque<ByteBuffer> pcmDataCachedQueue = new ArrayDeque(500);
    Object lock = new Object();

    public static void registerLogListener(IInputAudioSource.LogListener logListener) {
        if (logListener != null) {
            sLogListener = logListener;
        }
    }

    @Override
    public void setExternalAudioParam(boolean bl, int n, int n2) {
        sLogListener.onLog(6, "[ExternalInputAudio] Try to create ExternalAudio  Disabled: " + bl + ", SampleRate: " + n + ", channel: " + n2);
        this.micDisable = bl;
        this.sampleRate = n;
        this.channelCount = n2;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setChannelCount(int n) {
        this.channelCount = n;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public boolean getEnabled() {
        return this.micDisable;
    }

    @Override
    public ByteBuffer getDataForSend() {
        return this.readExternalAudioBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeExternalAudioBuffer(byte[] byArray) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pcmDataCachedQueue.size() == 500) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.pcmDataCachedQueue.size() < 500) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
                byteBuffer.put(byArray);
                byteBuffer.position(0);
                boolean bl = this.pcmDataCachedQueue.offerLast(byteBuffer);
                if (bl) {
                    ++this.writeBufferCount;
                    if (this.writeBufferCount == this.logBufferCount) {
                        sLogListener.onLog(6, "[ExternalInputAudio] writeExternalAudioBuffer Succeed  dataSize: " + byArray.length);
                        this.writeBufferCount = 0;
                    }
                    this.lock.notifyAll();
                    return 0;
                }
                sLogListener.onLog(6, "[ExternalInputAudio] writeExternalAudioBuffer Failed  dataSize: " + byArray.length);
                this.lock.notifyAll();
                return -1;
            }
            sLogListener.onLog(6, "[ExternalInputAudio] ExternalAudioBuffer is Full");
            this.lock.notifyAll();
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer readExternalAudioBuffer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pcmDataCachedQueue.isEmpty()) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (!this.pcmDataCachedQueue.isEmpty()) {
                ByteBuffer byteBuffer = this.pcmDataCachedQueue.pollFirst();
                ++this.readBufferCount;
                if (this.readBufferCount == this.logBufferCount) {
                    sLogListener.onLog(6, "[ExternalInputAudio] readExternalAudioBuffer Succeed bufferSize: " + byteBuffer.array().length);
                    this.readBufferCount = 0;
                }
                this.lock.notifyAll();
                return byteBuffer;
            }
            this.lock.notifyAll();
            return null;
        }
    }

    @Override
    public void release() {
        if (this.pcmDataCachedQueue != null) {
            this.pcmDataCachedQueue.clear();
        }
    }
}

