/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.JniCommon;

public class MediaSource {
    private long nativeSource;

    public MediaSource(long l) {
        this.nativeSource = l;
    }

    public State state() {
        this.checkMediaSourceExists();
        return MediaSource.nativeGetState(this.nativeSource);
    }

    public void dispose() {
        this.checkMediaSourceExists();
        JniCommon.nativeReleaseRef(this.nativeSource);
        this.nativeSource = 0L;
    }

    protected long getNativeMediaSource() {
        this.checkMediaSourceExists();
        return this.nativeSource;
    }

    private void checkMediaSourceExists() {
        if (this.nativeSource == 0L) {
            throw new IllegalStateException("MediaSource has been disposed.");
        }
    }

    private static native State nativeGetState(long var0);

    public static enum State {
        INITIALIZING,
        LIVE,
        ENDED,
        MUTED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int n) {
            return State.values()[n];
        }
    }
}

