/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.util.Log;
import com.superrtc.EglBase;
import com.superrtc.HardwareVideoEncoderFactory;
import com.superrtc.SoftwareVideoEncoderFactory;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoEncoder;
import com.superrtc.VideoEncoderFactory;
import com.superrtc.VideoEncoderFallback;
import com.superrtc.sdk.RtcConnection;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    private static final String TAG = "DefaultVideoEncoderFactory";
    private static RtcConnection.LogListener sLogListener = (n, string, string2) -> Log.i((String)TAG, (String)string2);
    public static int loglevel = 6;

    public DefaultVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(context, bl, bl2);
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.hardwareVideoEncoderFactory = videoEncoderFactory;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        VideoEncoder videoEncoder = this.softwareVideoEncoderFactory.createEncoder(videoCodecInfo);
        VideoEncoder videoEncoder2 = this.hardwareVideoEncoderFactory.createEncoder(videoCodecInfo);
        if (videoEncoder2 != null) {
            sLogListener.onLog(loglevel, TAG, ": hardware encoder is available");
        }
        if (videoEncoder2 != null && videoEncoder != null) {
            return new VideoEncoderFallback(videoEncoder, videoEncoder2);
        }
        return videoEncoder2 != null ? videoEncoder2 : videoEncoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

