/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import com.superrtc.ICameraInterface;
import com.superrtc.TextureBufferImpl;
import com.superrtc.VideoFrame;

interface CameraSession
extends ICameraInterface {
    public void stop();

    public static int getDeviceOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl textureBufferImpl, boolean bl, int n) {
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        if (bl) {
            matrix.preScale(-1.0f, 1.0f);
        }
        matrix.preRotate((float)n);
        matrix.preTranslate(-0.5f, -0.5f);
        return textureBufferImpl.applyTransformMatrix(matrix, textureBufferImpl.getWidth(), textureBufferImpl.getHeight());
    }

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

