/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.util.Range;
import android.view.Surface;
import com.superrtc.Camera2Enumerator;
import com.superrtc.CameraEnumerationAndroid;
import com.superrtc.CameraSession;
import com.superrtc.Histogram;
import com.superrtc.ICameraInterface;
import com.superrtc.Logging;
import com.superrtc.RendererCommon;
import com.superrtc.Size;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.TextureBufferImpl;
import com.superrtc.VideoFrame;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@TargetApi(value=21)
class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private Surface surface;
    @Nullable
    private CameraCaptureSession captureSession;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private final long constructionTimeNs;

    @Override
    public synchronized void takeCameraPicture(ICameraInterface.ITakeCallback iTakeCallback) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void handleZoom(Float f2) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void handleFocusMetering(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void handleManualFocus(int n, int n2, int n3, int n4, int n5, int n6, RendererCommon.ScalingType scalingType) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void handleManualZoom(boolean bl, int n) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void handleFlashLight(boolean bl) {
        throw new RuntimeException("Not implemented!");
    }

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string, int n, int n2, int n3) {
        new Camera2Session(createSessionCallback, events, context, cameraManager, surfaceTextureHelper, string, n, n2, n3);
    }

    private Camera2Session(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string, int n, int n2, int n3) {
        Logging.d(TAG, "Create new camera2 session on camera " + string);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = createSessionCallback;
        this.events = events;
        this.applicationContext = context;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = string;
        this.width = n;
        this.height = n2;
        this.framerate = n3;
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        surfaceTextureHelper.setCameraInfo(this.isCameraFrontFacing);
        surfaceTextureHelper.setTextureSize(this.captureFormat.width, this.captureFormat.height);
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("getCameraCharacteristics(): " + cameraAccessException.getMessage());
            return;
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Range[] rangeArray = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(rangeArray);
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list = Camera2Enumerator.convertFramerates(rangeArray, this.fpsUnitFactor);
        List<Size> list2 = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + list2);
        Logging.d(TAG, "Available fps ranges: " + list);
        if (list.isEmpty() || list2.isEmpty()) {
            this.reportError("No supported capture formats.");
            return;
        }
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list, this.framerate);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(list2, this.width, this.height);
        CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, size);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, framerateRange);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
    }

    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: " + (Object)((Object)cameraAccessException));
            return;
        }
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
            camera2StopTimeMsHistogram.addSample(n);
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    private void reportError(String string) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + string);
        boolean bl = this.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, string);
        } else {
            this.events.onCameraError(this, string);
        }
    }

    private int getFrameOrientation() {
        int n = CameraSession.getDeviceOrientation(this.applicationContext);
        if (!this.isCameraFrontFacing) {
            n = 360 - n;
        }
        return (this.cameraOrientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            cameraCaptureSession.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.this.captureSession = cameraCaptureSession;
            try {
                CaptureRequest.Builder builder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                builder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                this.chooseStabilizationMode(builder);
                this.chooseFocusMode(builder);
                builder.addTarget(Camera2Session.this.surface);
                cameraCaptureSession.setRepeatingRequest(builder.build(), (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)cameraAccessException));
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(videoFrame -> {
                Camera2Session.this.checkIsOnCameraThread();
                if (Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.this.firstFrameReported = true;
                    int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs);
                    camera2StartTimeMsHistogram.addSample(n);
                }
                VideoFrame videoFrame2 = Camera2Session.this.surfaceTextureHelper.GetWatermark() == null ? new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)videoFrame.getBuffer(), Camera2Session.this.isCameraFrontFacing, 0), Camera2Session.this.getFrameOrientation(), videoFrame.getTimestampNs()) : new VideoFrame(videoFrame.getBuffer(), Camera2Session.this.getFrameOrientation(), videoFrame.getTimestampNs());
                Camera2Session.this.surfaceTextureHelper.getVideoSink().onFrame(videoFrame2);
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, videoFrame2);
                videoFrame2.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder builder) {
            int[] nArray;
            int[] nArray2 = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray2 != null) {
                nArray = nArray2;
                int n = nArray.length;
                for (int k = 0; k < n; ++k) {
                    int n2 = nArray[k];
                    if (n2 != 1) continue;
                    builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            for (int n : nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) {
                if (n != 1) continue;
                builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder builder) {
            int[] nArray;
            for (int n : nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                if (n != 3) continue;
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int n) {
            switch (n) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + n;
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean bl = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.this.state = SessionState.STOPPED;
            Camera2Session.this.stopInternal();
            if (bl) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice cameraDevice, int n) {
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.this.reportError(this.getErrorDescription(n));
        }

        public void onOpened(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.this.cameraDevice = cameraDevice;
            Camera2Session.this.surface = new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture());
            try {
                cameraDevice.createCaptureSession(Arrays.asList(Camera2Session.this.surface), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)cameraAccessException));
                return;
            }
        }

        public void onClosed(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

