/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.support.v4.content.LocalBroadcastManager;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.a.a;
import com.hyphenate.analytics.EMCollector;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMHeartBeatReceiver;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAHeartBeatCustomizedParams;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.Utils;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class EMSmartHeartBeat {
    private static final String TAG = "smart ping";
    static boolean Debug = false;
    private int fixedInterval = -1;
    boolean useCustomizedParams = false;
    EMAHeartBeatCustomizedParams mCustomizedWifiParams = null;
    EMAHeartBeatCustomizedParams mCustomizedMobileParams = null;
    private Context mContext;
    private static final int PING_PONG_TIMEOUT = 8000;
    private int succeededInterval;
    private int currentInterval;
    private boolean dataReceivedDuringInterval = false;
    IParams params;
    private EMHeartBeatReceiver alarmIntentReceiver = null;
    private PendingIntent alarmIntent = null;
    private EMConnectionListener cnnListener = null;
    private EMMessageListener messageListener = null;
    private PowerManager.WakeLock wakeLock;
    private Object stateLock = new Object();
    private boolean inited = false;
    private boolean prevWifi = false;
    private String prevWIFISSID = "";
    private Timer disconnectTimer = null;
    private TimerTask disconnectTask = null;
    private AlarmManager alarmManager;
    private boolean isInBackground = false;
    private static final int GCM_DISCONNECT_CHECK_INTERVAL = 180000;
    private EMSmartPingState pingState = EMSmartPingState.EMReady;
    ExecutorService threadPool;
    private Runnable heartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            EMLog.d(EMSmartHeartBeat.TAG, "has network connection:" + NetUtils.hasNetwork(EMSmartHeartBeat.this.mContext) + " has data conn:" + NetUtils.hasDataConnection(EMSmartHeartBeat.this.mContext) + " isConnected to hyphenate server : " + EMClient.getInstance().isConnected());
            if (EMSmartHeartBeat.this.hasDataConnection()) {
                EMSmartHeartBeat.this.wakeLock.acquire();
                EMLog.d(EMSmartHeartBeat.TAG, "acquire wake lock");
                EMSmartHeartBeat.this.checkPingPong();
                EMSmartHeartBeat.this.releaseWakelock();
            } else {
                EMLog.d(EMSmartHeartBeat.TAG, "....no connection to server");
                if (!NetUtils.hasDataConnection(EMSmartHeartBeat.this.mContext) && EMClient.getInstance().isConnected()) {
                    if (Utils.isSdk14()) {
                        EMLog.d(EMSmartHeartBeat.TAG, "no data connection but im connection is connected, reconnect");
                        EMClient.getInstance().onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
                    } else {
                        EMClient.getInstance().forceReconnect();
                    }
                }
            }
            a.d();
            EMSmartHeartBeat.this.scheduleNextAlarm();
        }
    };

    public void setCustomizedParams(EMAHeartBeatCustomizedParams eMAHeartBeatCustomizedParams, EMAHeartBeatCustomizedParams eMAHeartBeatCustomizedParams2) {
        if (eMAHeartBeatCustomizedParams == null || eMAHeartBeatCustomizedParams2 == null) {
            return;
        }
        this.useCustomizedParams = true;
        this.mCustomizedWifiParams = eMAHeartBeatCustomizedParams;
        this.mCustomizedMobileParams = eMAHeartBeatCustomizedParams2;
    }

    public void setFixedInterval(int n) {
        this.fixedInterval = n * 1000;
    }

    private EMSmartHeartBeat(Context context) {
        this.mContext = context;
    }

    public static EMSmartHeartBeat create(Context context) {
        return new EMSmartHeartBeat(context);
    }

    public void onInit() {
        this.threadPool = Executors.newSingleThreadExecutor();
        this.changeState(EMSmartPingState.EMEvaluating);
        this.reset();
        this.disconnectTimer = new Timer();
        this.alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        if (this.cnnListener == null) {
            this.cnnListener = new EMConnectionListener(){

                @Override
                public void onDisconnected(int n) {
                    EMLog.d(EMSmartHeartBeat.TAG, " onDisconnected ..." + n);
                }

                @Override
                public void onConnected() {
                    EMLog.d(EMSmartHeartBeat.TAG, " onConnectred ...");
                    if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM && EMSmartHeartBeat.this.isInBackground) {
                        EMClient.getInstance().disconnect();
                        return;
                    }
                    EMSmartHeartBeat.this.calcDisconnectedInterval();
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }
            };
        }
        if (this.messageListener == null) {
            this.messageListener = new EMMessageListener(){

                @Override
                public void onMessageReceived(List<EMMessage> list) {
                    EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }

                @Override
                public void onCmdMessageReceived(List<EMMessage> list) {
                    EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }

                @Override
                public void onMessageRead(List<EMMessage> list) {
                    EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }

                @Override
                public void onMessageDelivered(List<EMMessage> list) {
                    EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }

                @Override
                public void onMessageRecalled(List<EMMessage> list) {
                    EMSmartHeartBeat.this.dataReceivedDuringInterval = true;
                    EMSmartHeartBeat.this.scheduleNextAlarm();
                }

                @Override
                public void onMessageChanged(EMMessage eMMessage, Object object) {
                }

                @Override
                public void onGroupMessageRead(List<EMGroupReadAck> list) {
                }

                @Override
                public void onReadAckForGroupMessageUpdated() {
                }
            };
        }
        EMClient.getInstance().addConnectionListener(this.cnnListener);
        EMClient.getInstance().chatManager().addMessageListener(this.messageListener);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        if (this.wakeLock == null) {
            this.wakeLock = powerManager.newWakeLock(1, "heartbeatlock");
        }
        if (Utils.isSdk14()) {
            EMClient.getInstance().setAppStateListener(new EMClient.AppStateListener(){

                @Override
                public void onForeground() {
                    EMLog.d(EMSmartHeartBeat.TAG, "app onForeground");
                    EMSmartHeartBeat.this.isInBackground = false;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM && EMSmartHeartBeat.this.disconnectTask != null) {
                                EMSmartHeartBeat.this.disconnectTask.cancel();
                            }
                            if (NetUtils.hasDataConnection(EMSmartHeartBeat.this.mContext)) {
                                if (!EMClient.getInstance().isConnected()) {
                                    EMClient.getInstance().onNetworkChanged();
                                } else {
                                    EMSmartHeartBeat.this.sendPingCheckConnection();
                                }
                            }
                        }
                    }).start();
                }

                @Override
                public void onBackground() {
                    EMSmartHeartBeat.this.isInBackground = true;
                    EMLog.d(EMSmartHeartBeat.TAG, "app onBackground");
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM) {
                                EMSmartHeartBeat.this.disconnectTask = EMSmartHeartBeat.this.getTask();
                                try {
                                    EMSmartHeartBeat.this.disconnectTimer.schedule(EMSmartHeartBeat.this.disconnectTask, 180000L);
                                    EMLog.d(EMSmartHeartBeat.TAG, "schedule disconnect task");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }).start();
                }
            });
        }
        this.inited = true;
    }

    void sendPingCheckConnection() {
        boolean bl = EMClient.getInstance().sendPing(true, 3000L);
        EMLog.d(TAG, "send check Ping " + (bl ? "success" : "timeout"));
        if (bl) {
            this.dataReceivedDuringInterval = true;
            this.scheduleNextAlarm();
        } else {
            EMClient.getInstance().forceReconnect();
        }
    }

    private TimerTask getTask() {
        return new TimerTask(){

            @Override
            public void run() {
                EMLog.d(EMSmartHeartBeat.TAG, "enter the disconnect task");
                if (EMClient.getInstance().isConnected()) {
                    EMClient.getInstance().disconnect();
                }
                try {
                    EMSmartHeartBeat.this.alarmManager.cancel(EMSmartHeartBeat.this.alarmIntent);
                    EMSmartHeartBeat.this.mContext.unregisterReceiver((BroadcastReceiver)EMSmartHeartBeat.this.alarmIntentReceiver);
                    EMSmartHeartBeat.this.alarmIntentReceiver = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    private void checkPingPong() {
        EMLog.d(TAG, "check pingpong ...");
        boolean bl = false;
        int n = 30000;
        int n2 = 3;
        for (int k = 0; k < n2; ++k) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                EMLog.e(TAG, "heartbeat thread be interrupt");
                Thread.currentThread().interrupt();
                return;
            }
            try {
                if (this.dataReceivedDuringInterval) {
                    return;
                }
                bl = this.sendPingPong();
                if (!bl) continue;
                EMLog.d(TAG, "success to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
                this.succeededInterval = this.currentInterval;
                EMLog.d(TAG, "send ping-pong successes");
                if (this.pingState == EMSmartPingState.EMHitted) {
                    EMLog.d(TAG, "that's already in the EMHitted state, just return...");
                    return;
                }
                if (this.succeededInterval == this.params.getMaxInterval() || this.pingState == EMSmartPingState.EMReevaluating) {
                    if (this.succeededInterval == this.params.getMaxInterval()) {
                        EMLog.d(TAG, "Find the best interval, interval is the max interval");
                    }
                    if (this.pingState == EMSmartPingState.EMReevaluating) {
                        EMLog.d(TAG, "success to pingping and current state is EMSmartPingState.EMReevaluating, so use current interval as final interval");
                    }
                    EMLog.d(TAG, "enter the ping state : " + (Object)((Object)this.pingState));
                    this.changeState(EMSmartPingState.EMHitted);
                    return;
                }
                this.currentInterval = this.params.getNextInterval(this.currentInterval, true);
                break;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (!bl) {
            EMLog.d(TAG, "failed to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
            if (this.hasDataConnection()) {
                EMLog.d(TAG, "failed to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
                if (this.pingState == EMSmartPingState.EMEvaluating || this.pingState == EMSmartPingState.EMHitted) {
                    EMLog.d(TAG, "send ping-pong failed, but has success interval candidate with ping state : " + (Object)((Object)this.pingState) + " enter EMSmartPingState.EMReevaluating");
                    this.changeState(EMSmartPingState.EMReevaluating);
                }
                this.succeededInterval = 0;
                EMClient.getInstance().forceReconnect();
            }
        }
    }

    private boolean hasDataConnection() {
        return NetUtils.hasDataConnection(this.mContext) && EMClient.getInstance().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakelock() {
        EMSmartHeartBeat eMSmartHeartBeat = this;
        synchronized (eMSmartHeartBeat) {
            if (this.wakeLock != null && this.wakeLock.isHeld()) {
                this.wakeLock.release();
                EMLog.d(TAG, "released the wake lock");
            }
        }
    }

    private boolean sendPingPong() {
        EMLog.d(TAG, "send ping-pong type heartbeat");
        if (!EMClient.getInstance().isConnected()) {
            return false;
        }
        return EMClient.getInstance().sendPing(true, 8000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.pingState == EMSmartPingState.EMStopped) {
            return;
        }
        if (!EMClient.getInstance().isConnected() && NetUtils.hasDataConnection(this.mContext)) {
            EMClient.getInstance().onNetworkChanged();
        }
        if (!EMClient.getInstance().isConnected() || !NetUtils.hasNetwork(this.mContext)) {
            if (this.dataReceivedDuringInterval) {
                this.dataReceivedDuringInterval = false;
            }
            this.scheduleNextAlarm();
            return;
        }
        if (this.dataReceivedDuringInterval) {
            this.dataReceivedDuringInterval = false;
            EMLog.d(TAG, "receiving packet...");
            return;
        }
        EMLog.d(TAG, "post heartbeat runnable");
        EMSmartHeartBeat eMSmartHeartBeat = this;
        synchronized (eMSmartHeartBeat) {
            if (this.threadPool != null && !this.threadPool.isShutdown()) {
                this.threadPool.execute(this.heartBeatRunnable);
            }
        }
    }

    public void scheduleNextAlarm() {
        try {
            Intent intent;
            EMLog.d(TAG, "schedule next alarm");
            EMLog.d(TAG, "current heartbeat interval : " + EMCollector.timeToString(this.currentInterval) + " smart ping state : " + (Object)((Object)this.pingState));
            this.dataReceivedDuringInterval = false;
            if (this.alarmIntent == null) {
                intent = new Intent("hyphenate.chat.heatbeat." + EMClient.getInstance().getChatConfigPrivate().l());
                this.alarmIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            }
            if (this.alarmIntentReceiver == null) {
                this.alarmIntentReceiver = new EMHeartBeatReceiver(this);
                intent = new IntentFilter("hyphenate.chat.heatbeat." + EMClient.getInstance().getChatConfigPrivate().l());
                LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver((BroadcastReceiver)this.alarmIntentReceiver, (IntentFilter)intent);
            }
            long l = System.currentTimeMillis() + 180000L;
            if (this.hasDataConnection()) {
                if (this.currentInterval <= 0) {
                    this.currentInterval = this.params.getDefaultInterval();
                    EMLog.d(TAG, "current heartbeat interval is not set, use default interval : " + EMCollector.timeToString(this.currentInterval));
                }
                l = System.currentTimeMillis() + (long)this.currentInterval;
            } else {
                l = System.currentTimeMillis() + 180000L;
                EMLog.d(TAG, "is not connected to server, so use idle interval : 3 mins");
            }
            if (Build.VERSION.SDK_INT >= 23) {
                this.alarmManager.setExactAndAllowWhileIdle(0, l, this.alarmIntent);
            } else if (Build.VERSION.SDK_INT >= 19) {
                this.alarmManager.setExact(0, l, this.alarmIntent);
            } else {
                this.alarmManager.set(0, l, this.alarmIntent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block8: {
            EMLog.d(TAG, "stop heart beat timer");
            if (!this.inited) {
                EMLog.w(TAG, "smart heartbeat is not inited!");
                return;
            }
            this.changeState(EMSmartPingState.EMStopped);
            EMSmartHeartBeat eMSmartHeartBeat = this;
            synchronized (eMSmartHeartBeat) {
                this.threadPool.shutdownNow();
            }
            this.reset();
            this.releaseWakelock();
            this.disconnectTimer.cancel();
            if (this.cnnListener != null) {
                EMClient.getInstance().removeConnectionListener(this.cnnListener);
            }
            if (this.messageListener != null) {
                EMClient.getInstance().chatManager().removeMessageListener(this.messageListener);
                this.messageListener = null;
            }
            try {
                this.alarmManager.cancel(this.alarmIntent);
                LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver((BroadcastReceiver)this.alarmIntentReceiver);
                this.alarmIntentReceiver = null;
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Receiver not registered")) break block8;
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(EMSmartPingState eMSmartPingState) {
        EMLog.d(TAG, "change smart ping state from : " + (Object)((Object)this.pingState) + " to : " + (Object)((Object)eMSmartPingState));
        Object object = this.stateLock;
        synchronized (object) {
            this.pingState = eMSmartPingState;
        }
    }

    private boolean isSameNet(boolean bl, String string) {
        EMLog.d(TAG, "prevWifi:" + this.prevWifi + " isWifi:" + bl + " prevWIFISSID:" + this.prevWIFISSID + " SSID:" + string);
        if (!bl) {
            return this.prevWifi == bl;
        }
        if (string == null || string.isEmpty()) {
            return false;
        }
        return string.equals(this.prevWIFISSID);
    }

    private void reset() {
        EMLog.d(TAG, "reset interval...");
        this.currentInterval = 0;
        this.succeededInterval = 0;
        this.dataReceivedDuringInterval = false;
        this.changeState(EMSmartPingState.EMEvaluating);
    }

    private void calcDisconnectedInterval() {
        EMLog.d(TAG, "reset interval...");
        boolean bl = NetUtils.isWifiConnected(this.mContext);
        boolean bl2 = NetUtils.isEthernetConnected(this.mContext);
        String string = "";
        if (bl) {
            string = NetUtils.getWiFiSSID(this.mContext);
        }
        this.params = Debug ? new EMParamsQuickTest() : (this.useCustomizedParams ? (bl2 ? new EMParams() : new EMParamsCustomized(bl ? this.mCustomizedWifiParams : this.mCustomizedMobileParams)) : new EMParams());
        boolean bl3 = this.isSameNet(bl, string);
        this.prevWifi = bl;
        this.prevWIFISSID = string;
        if (!bl3 || this.currentInterval == 0) {
            this.currentInterval = this.params.getDefaultInterval();
            this.succeededInterval = 0;
            this.changeState(EMSmartPingState.EMEvaluating);
        } else {
            this.currentInterval = this.params.getNextInterval(this.currentInterval, false);
            if (this.pingState == EMSmartPingState.EMHitted) {
                this.changeState(EMSmartPingState.EMEvaluating);
            } else {
                this.changeState(EMSmartPingState.EMReevaluating);
            }
            this.succeededInterval = 0;
        }
        this.dataReceivedDuringInterval = false;
        EMLog.d(TAG, "reset currentInterval:" + EMCollector.timeToString(this.currentInterval));
    }

    private static enum EMSmartPingState {
        EMReady,
        EMEvaluating,
        EMReevaluating,
        EMHitted,
        EMStopped;

    }

    class EMParamsCustomized
    extends IParams {
        private final int defaultInterval;
        private final int minInterval;
        private final int maxInterval;
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;

        EMParamsCustomized(EMAHeartBeatCustomizedParams eMAHeartBeatCustomizedParams) {
            this.defaultInterval = eMAHeartBeatCustomizedParams.defaultInterval;
            this.minInterval = eMAHeartBeatCustomizedParams.minInterval;
            this.maxInterval = eMAHeartBeatCustomizedParams.maxInterval;
        }

        @Override
        int getDefaultInterval() {
            if (EMSmartHeartBeat.this.fixedInterval != -1) {
                return EMSmartHeartBeat.this.fixedInterval;
            }
            EMLog.d(EMSmartHeartBeat.TAG, "get customized default: " + this.defaultInterval);
            return this.defaultInterval;
        }

        @Override
        int getMinInterval() {
            return this.minInterval;
        }

        @Override
        int getMaxInterval() {
            return this.maxInterval;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }
    }

    class EMParams
    extends IParams {
        static final int MOBILE_DEFAULT_INTERVAL = 180000;
        static final int WIFI_DEFAULT_INTERVAL = 120000;
        static final int MIN_INTERVAL = 30000;
        static final int MAX_INTERVAL = 270000;
        static final int MAX_MIN_INTERVAL_COUNTER = 3;
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;

        EMParams() {
        }

        @Override
        int getDefaultInterval() {
            if (EMSmartHeartBeat.this.fixedInterval != -1) {
                return EMSmartHeartBeat.this.fixedInterval;
            }
            int n = 0;
            n = NetUtils.isWifiConnected(EMSmartHeartBeat.this.mContext) ? 120000 : 180000;
            return n;
        }

        @Override
        int getMinInterval() {
            return 30000;
        }

        @Override
        int getMaxInterval() {
            return 270000;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }
    }

    class EMParamsQuickTest
    extends IParams {
        static final int MOBILE_DEFAULT_INTERVAL = 20000;
        static final int WIFI_DEFAULT_INTERVAL = 20000;
        static final int MIN_INTERVAL = 10000;
        static final int MAX_INTERVAL = 30000;
        static final int MAX_MIN_INTERVAL_COUNTER = 3;
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;

        EMParamsQuickTest() {
        }

        @Override
        int getDefaultInterval() {
            int n = 0;
            n = NetUtils.isWifiConnected(EMSmartHeartBeat.this.mContext) ? 20000 : 20000;
            return n;
        }

        @Override
        int getMinInterval() {
            return 10000;
        }

        @Override
        int getMaxInterval() {
            return 30000;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }

        @Override
        int getNextInterval(int n, boolean bl) {
            int n2 = n;
            int n3 = bl ? 1 : -1;
            n2 = n + n3 * 5 * 1000;
            if (n2 > this.getMaxInterval()) {
                n2 = this.getMaxInterval();
            }
            if (n2 < this.getMinInterval()) {
                n2 = this.getMinInterval();
            }
            return n2;
        }
    }

    abstract class IParams {
        IParams() {
        }

        abstract int getMinInterval();

        abstract int getMaxInterval();

        abstract int getDefaultInterval();

        abstract int getPingPongTimeout();

        abstract int getPingPongCheckInterval();

        int getNextInterval(int n, boolean bl) {
            int n2;
            if (EMSmartHeartBeat.this.fixedInterval != -1) {
                EMLog.d(EMSmartHeartBeat.TAG, "use fixed interval: " + EMSmartHeartBeat.this.fixedInterval);
                return EMSmartHeartBeat.this.fixedInterval;
            }
            int n3 = n;
            int n4 = n2 = bl ? 1 : -1;
            n3 = n2 < 0 ? (n <= 60000 ? n + n2 * 10 * 1000 : (n <= 120000 ? n + n2 * 30 * 1000 : n + n2 * 45 * 1000)) : (n < 60000 ? n + n2 * 10 * 1000 : (n < 120000 ? n + n2 * 30 * 1000 : n + n2 * 45 * 1000));
            if (n3 > this.getMaxInterval()) {
                n3 = this.getMaxInterval();
            }
            if (n3 < this.getMinInterval()) {
                n3 = this.getMinInterval();
            }
            return n3;
        }
    }
}

