/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.qualityReport;

import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.qualityReport.ReportBase;
import com.superrtc.qualityReport.ReportMsgBuffer;
import com.superrtc.qualityReport.ReportType;
import com.superrtc.qualityReport.ReportUtils;

public class SendReportRunnable
extends Thread
implements Runnable {
    private static final String TAG = "SendReportRunnable";
    private ReportMsgBuffer buffer;
    private boolean stop = false;
    private boolean isConnected = false;
    boolean firstSend = true;

    public SendReportRunnable(ReportMsgBuffer reportMsgBuffer) {
        this.buffer = reportMsgBuffer;
    }

    @Override
    public void run() {
        while (!this.stop) {
            if (this.isConnected) {
                try {
                    ReportBase reportBase = this.buffer.getReportMsg();
                    if (reportBase.type != ReportType.REPORT_OP_EXIT) {
                        if (reportBase.type == ReportType.REPORT_OP_INIT) {
                            ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, " Send initData msg:" + reportBase.toString());
                            EMediaManager.getInstance().sendReportMsg(reportBase);
                            this.setIsConnected(false);
                            continue;
                        }
                        if (this.firstSend) {
                            ReportUtils.counterId = ReportUtils.currentCounterId + 1;
                            this.firstSend = false;
                            ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "First Send ReportData counterId:" + ReportUtils.counterId);
                        }
                        reportBase.counterId = ReportUtils.counterId++;
                        EMediaManager.getInstance().sendReportMsg(reportBase);
                        continue;
                    }
                    ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "Recv stop msg to stop!");
                    this.isConnected = false;
                    this.stop = true;
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            this.firstSend = true;
            ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_ERROR.ordinal(), TAG, "Send ReportData sleep: 1s");
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        if (EMediaSession.report_websocket != null) {
            ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "report_websocket close");
            EMediaSession.report_websocket.close();
            EMediaSession.report_websocket = null;
            ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "reset report_websocket:" + EMediaSession.report_websocket);
        }
        ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "SendReportRunnable thread stop!");
    }

    public void setIsConnected(Boolean bl) {
        ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "setIsConnected: " + bl);
        this.isConnected = bl;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setStoped(Boolean bl) {
        ReportUtils.report_logcallback.onLog(ReportUtils.logLevel.LS_INFO.ordinal(), TAG, "setStoped: " + bl);
        this.stop = bl;
    }
}

