/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.qualityReport;

import android.util.Log;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.qualityReport.ReportBase;
import com.superrtc.qualityReport.ReportData;
import com.superrtc.qualityReport.ReportEvent;
import com.superrtc.qualityReport.ReportEvents.ReportEventCloseAudio;
import com.superrtc.qualityReport.ReportEvents.ReportEventCloseVideo;
import com.superrtc.qualityReport.ReportEvents.ReportEventExitConfr;
import com.superrtc.qualityReport.ReportEvents.ReportEventFirstAudioRecived;
import com.superrtc.qualityReport.ReportEvents.ReportEventFirstAudioSended;
import com.superrtc.qualityReport.ReportEvents.ReportEventFirstVideoRecived;
import com.superrtc.qualityReport.ReportEvents.ReportEventFirstVideoSended;
import com.superrtc.qualityReport.ReportEvents.ReportEventJoinConfr;
import com.superrtc.qualityReport.ReportEvents.ReportEventMemAdd;
import com.superrtc.qualityReport.ReportEvents.ReportEventMemRemove;
import com.superrtc.qualityReport.ReportEvents.ReportEventOpenAudio;
import com.superrtc.qualityReport.ReportEvents.ReportEventOpenVideo;
import com.superrtc.qualityReport.ReportEvents.ReportEventPCConnectState;
import com.superrtc.qualityReport.ReportEvents.ReportEventPoorQuality;
import com.superrtc.qualityReport.ReportEvents.ReportEventRoleChange;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamAdd;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamPub;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamPubFailed;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamRePub;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamRemove;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamSub;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamUnPub;
import com.superrtc.qualityReport.ReportEvents.ReportEventStreamUnSub;
import com.superrtc.qualityReport.ReportEvents.ReportEventUserBackCamera;
import com.superrtc.qualityReport.ReportInit;
import com.superrtc.qualityReport.ReportType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportUtils {
    public static int counterId = 0;
    public static int currentCounterId;
    public static XClientBridger.ReportLogcallbackfunc report_logcallback;

    public static String ReportBaseToString(ReportBase reportBase) {
        try {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            switch (reportBase.type) {
                case REPORT_OP_INIT: {
                    object = (ReportInit)reportBase;
                    hashMap.put("type", ReportType.REPORT_OP_INIT.getDesc());
                    hashMap.put("counterId", ((ReportInit)object).counterId);
                    hashMap.put("appkey", ((ReportInit)object).appkey);
                    hashMap.put("confrId", ((ReportInit)object).confrId);
                    hashMap.put("memId", ((ReportInit)object).memId);
                    hashMap.put("memName", ((ReportInit)object).memName);
                    hashMap.put("time", ((ReportInit)object).timestamp);
                    hashMap.put("networkType", ((ReportInit)object).networkType);
                    hashMap.put("sessionId", ((ReportInit)object).sessionId);
                    hashMap.put("sdkOS", ((ReportInit)object).sdkOS);
                    hashMap.put("sdkVersion", ((ReportInit)object).sdkVersion);
                    hashMap.put("deviceInfo", ((ReportInit)object).deviceInfo);
                    hashMap.put("osVersion", ((ReportInit)object).osVersion);
                    hashMap.put("joinConfrTime", ((ReportInit)object).joinConfrTime);
                    hashMap.put("result", ((ReportInit)object).result);
                    break;
                }
                case REPORT_OP_DATA: {
                    ReportData reportData = (ReportData)reportBase;
                    hashMap.put("type", ReportType.REPORT_OP_DATA.getDesc());
                    hashMap.put("counterId", reportData.counterId);
                    hashMap.put("appCpuUsage", reportData.appCPUUsage);
                    hashMap.put("systemCpuUsage", reportData.systemCPUUsage);
                    if (!reportData.isPub) {
                        hashMap.put("subMemId", reportData.subMemId);
                        hashMap.put("subMemName", reportData.subMemName);
                    }
                    hashMap.put("sId", reportData.streamId);
                    hashMap.put("streamType", reportData.streamType);
                    hashMap.put("rtcId", reportData.rtcId);
                    hashMap.put("isPub", reportData.isPub);
                    hashMap.put("time", reportData.timestamp);
                    hashMap.put("vKBps", reportData.vKBps);
                    hashMap.put("vFps", reportData.vFps);
                    hashMap.put("vW", reportData.vW);
                    hashMap.put("vH", reportData.vH);
                    hashMap.put("vP", reportData.vP);
                    hashMap.put("vPL", reportData.vPL);
                    hashMap.put("vPLR", reportData.vPLR);
                    hashMap.put("aKBps", reportData.aKBps);
                    hashMap.put("aP", reportData.aP);
                    hashMap.put("aPL", reportData.aPL);
                    hashMap.put("aPLR", reportData.aPLR);
                    hashMap.put("audioInputLevel", reportData.audioInputLevel);
                    hashMap.put("vCodec", reportData.vCodec);
                    hashMap.put("aCodec", reportData.aCodec);
                    break;
                }
                case REPORT_OP_EVENT: {
                    ReportEvent reportEvent = (ReportEvent)reportBase;
                    ReportUtils.ReportEventToJson(reportEvent, hashMap);
                    break;
                }
            }
            object = ReportUtils.convertMapToJSONObject(hashMap).toString();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    private static void ReportEventToJson(ReportEvent reportEvent, Map<String, Object> map) {
        map.put("type", ReportType.REPORT_OP_EVENT.getDesc());
        map.put("counterId", reportEvent.counterId);
        map.put("time", reportEvent.timestamp);
        map.put("event", reportEvent.eventType.getDesc());
        switch (reportEvent.eventType) {
            case JOIN_CONFR: {
                ReportEventJoinConfr reportEventJoinConfr = (ReportEventJoinConfr)reportEvent;
                map.put("ip", reportEventJoinConfr.ip);
                map.put("hopeVcode", reportEventJoinConfr.hopeVcode);
                break;
            }
            case EXIT_CONFR: {
                ReportEventExitConfr reportEventExitConfr = (ReportEventExitConfr)reportEvent;
                map.put("reason", reportEventExitConfr.reason);
                break;
            }
            case NETWORK_CONNECTED: {
                break;
            }
            case NETWORK_DISCONNECTED: {
                break;
            }
            case NETWORK_POORQUALITY: {
                ReportEventPoorQuality reportEventPoorQuality = (ReportEventPoorQuality)reportEvent;
                map.put("sId", reportEventPoorQuality.sId);
                map.put("rtcId", reportEventPoorQuality.rtcId);
                break;
            }
            case OPEN_AUDIO: {
                ReportEventOpenAudio reportEventOpenAudio = (ReportEventOpenAudio)reportEvent;
                map.put("sId", reportEventOpenAudio.sId);
                map.put("rtcId", reportEventOpenAudio.rtcId);
                break;
            }
            case OPEN_VIDEO: {
                ReportEventOpenVideo reportEventOpenVideo = (ReportEventOpenVideo)reportEvent;
                map.put("sId", reportEventOpenVideo.sId);
                map.put("rtcId", reportEventOpenVideo.rtcId);
                break;
            }
            case CLOSE_AUDIO: {
                ReportEventCloseAudio reportEventCloseAudio = (ReportEventCloseAudio)reportEvent;
                map.put("sId", reportEventCloseAudio.sId);
                map.put("rtcId", reportEventCloseAudio.rtcId);
                break;
            }
            case CLOSE_VIDEO: {
                ReportEventCloseVideo reportEventCloseVideo = (ReportEventCloseVideo)reportEvent;
                map.put("sId", reportEventCloseVideo.sId);
                map.put("rtcId", reportEventCloseVideo.rtcId);
                break;
            }
            case USE_BACKCAMERA: {
                ReportEventUserBackCamera reportEventUserBackCamera = (ReportEventUserBackCamera)reportEvent;
                map.put("sId", reportEventUserBackCamera.sId);
                map.put("rtcId", reportEventUserBackCamera.rtcId);
                map.put("cameraPos", reportEventUserBackCamera.cameraPos);
                break;
            }
            case MEM_ADD: {
                ReportEventMemAdd reportEventMemAdd = (ReportEventMemAdd)reportEvent;
                map.put("addMemId", reportEventMemAdd.addMemId);
                map.put("addMemName", reportEventMemAdd.addMemName);
                map.put("role", reportEventMemAdd.role);
                break;
            }
            case MEM_REMOVE: {
                ReportEventMemRemove reportEventMemRemove = (ReportEventMemRemove)reportEvent;
                map.put("removeMemId", reportEventMemRemove.removeMemId);
                map.put("removeMemName", reportEventMemRemove.removeMemName);
                map.put("role", reportEventMemRemove.role);
                break;
            }
            case STREAM_ADD: {
                ReportEventStreamAdd reportEventStreamAdd = (ReportEventStreamAdd)reportEvent;
                map.put("addMemId", reportEventStreamAdd.addMemId);
                map.put("addMemName", reportEventStreamAdd.addMemName);
                map.put("sId", reportEventStreamAdd.sId);
                map.put("streamType", reportEventStreamAdd.streamType);
                map.put("voff", reportEventStreamAdd.voff);
                map.put("aoff", reportEventStreamAdd.aoff);
                break;
            }
            case STREAM_REMOVE: {
                ReportEventStreamRemove reportEventStreamRemove = (ReportEventStreamRemove)reportEvent;
                map.put("removeMemId", reportEventStreamRemove.removeMemId);
                map.put("removeMemName", reportEventStreamRemove.removeMemName);
                map.put("sId", reportEventStreamRemove.sId);
                map.put("streamType", reportEventStreamRemove.streamType);
                break;
            }
            case STREAM_PUB: {
                ReportEventStreamPub reportEventStreamPub = (ReportEventStreamPub)reportEvent;
                map.put("sId", reportEventStreamPub.sId);
                map.put("streamType", reportEventStreamPub.streamType);
                map.put("rtcId", reportEventStreamPub.rtcId);
                map.put("voff", reportEventStreamPub.voff);
                map.put("aoff", reportEventStreamPub.aoff);
                map.put("w", reportEventStreamPub.w);
                map.put("h", reportEventStreamPub.h);
                map.put("result", reportEventStreamPub.result);
                map.put("vcode", reportEventStreamPub.vcode);
                break;
            }
            case STREAM_UNPUB: {
                ReportEventStreamUnPub reportEventStreamUnPub = (ReportEventStreamUnPub)reportEvent;
                map.put("sId", reportEventStreamUnPub.sId);
                map.put("streamType", reportEventStreamUnPub.streamType);
                map.put("rtcId", reportEventStreamUnPub.rtcId);
                map.put("result", reportEventStreamUnPub.result);
                break;
            }
            case STREAM_SUB: {
                ReportEventStreamSub reportEventStreamSub = (ReportEventStreamSub)reportEvent;
                map.put("rtcId", reportEventStreamSub.rtcId);
                map.put("sId", reportEventStreamSub.sId);
                map.put("result", reportEventStreamSub.result);
                map.put("streamType", reportEventStreamSub.streamType);
                map.put("subMemName", reportEventStreamSub.subMemName);
                map.put("subMemId", reportEventStreamSub.subMemId);
                break;
            }
            case STREAM_UNSUB: {
                ReportEventStreamUnSub reportEventStreamUnSub = (ReportEventStreamUnSub)reportEvent;
                map.put("rtcId", reportEventStreamUnSub.rtcId);
                map.put("sId", reportEventStreamUnSub.sId);
                map.put("result", reportEventStreamUnSub.result);
                map.put("streamType", reportEventStreamUnSub.streamType);
                map.put("unsubMemName", reportEventStreamUnSub.unsubMemName);
                map.put("unsubMemId", reportEventStreamUnSub.unsubMemId);
                break;
            }
            case STREAM_PUBFAIL: {
                ReportEventStreamPubFailed reportEventStreamPubFailed = (ReportEventStreamPubFailed)reportEvent;
                map.put("rtcId", reportEventStreamPubFailed.rtcId);
                map.put("reason", reportEventStreamPubFailed.reason);
                break;
            }
            case STREAM_REPUB: {
                ReportEventStreamRePub reportEventStreamRePub = (ReportEventStreamRePub)reportEvent;
                map.put("sId", reportEventStreamRePub.sId);
                map.put("streamType", reportEventStreamRePub.streamType);
                map.put("rtcId", reportEventStreamRePub.rtcId);
                map.put("voff", reportEventStreamRePub.voff);
                map.put("aoff", reportEventStreamRePub.aoff);
                map.put("w", reportEventStreamRePub.w);
                map.put("h", reportEventStreamRePub.h);
                map.put("result", reportEventStreamRePub.result);
                map.put("vcode", reportEventStreamRePub.vcode);
                map.put("reason", reportEventStreamRePub.reason);
                break;
            }
            case STREAM_PC_CONNECT_STATE: {
                ReportEventPCConnectState reportEventPCConnectState = (ReportEventPCConnectState)reportEvent;
                map.put("rtcId", reportEventPCConnectState.rtcId);
                map.put("connState", reportEventPCConnectState.connState);
                map.put("isPub", reportEventPCConnectState.isPub);
                map.put("sId", reportEventPCConnectState.sId);
                map.put("subSId", reportEventPCConnectState.subSId);
                map.put("rtcCfg", reportEventPCConnectState.rtcCfg);
                map.put("subVideo", reportEventPCConnectState.subVideo);
                map.put("subAudio", reportEventPCConnectState.subAudio);
                map.put("voff", reportEventPCConnectState.voff);
                map.put("aoff", reportEventPCConnectState.aoff);
                map.put("subMemName", reportEventPCConnectState.subMemName);
                map.put("subMemId", reportEventPCConnectState.subMemId);
                break;
            }
            case ROLE_CHANGE: {
                ReportEventRoleChange reportEventRoleChange = (ReportEventRoleChange)reportEvent;
                map.put("role", reportEventRoleChange.role);
                map.put("prerole", reportEventRoleChange.prerole);
                break;
            }
            case STREAM_SEND_FIRST_AUDIO_FRAME: {
                ReportEventFirstAudioSended reportEventFirstAudioSended = (ReportEventFirstAudioSended)reportEvent;
                map.put("sId", reportEventFirstAudioSended.sId);
                map.put("streamType", reportEventFirstAudioSended.streamType);
                map.put("rtcId", reportEventFirstAudioSended.rtcId);
                map.put("voff", reportEventFirstAudioSended.voff);
                map.put("aoff", reportEventFirstAudioSended.aoff);
                map.put("codec", reportEventFirstAudioSended.codec);
                break;
            }
            case STREAM_SEND_FIRST_VIDEO_FRAME: {
                ReportEventFirstVideoSended reportEventFirstVideoSended = (ReportEventFirstVideoSended)reportEvent;
                map.put("sId", reportEventFirstVideoSended.sId);
                map.put("streamType", reportEventFirstVideoSended.streamType);
                map.put("rtcId", reportEventFirstVideoSended.rtcId);
                map.put("voff", reportEventFirstVideoSended.voff);
                map.put("aoff", reportEventFirstVideoSended.aoff);
                map.put("codec", reportEventFirstVideoSended.codec);
                break;
            }
            case STREAM_RECIEVE_FIRST_AUDIO_FRAME: {
                ReportEventFirstAudioRecived reportEventFirstAudioRecived = (ReportEventFirstAudioRecived)reportEvent;
                map.put("sId", reportEventFirstAudioRecived.sId);
                map.put("streamType", reportEventFirstAudioRecived.streamType);
                map.put("rtcId", reportEventFirstAudioRecived.rtcId);
                map.put("voff", reportEventFirstAudioRecived.voff);
                map.put("aoff", reportEventFirstAudioRecived.aoff);
                map.put("subMemName", reportEventFirstAudioRecived.subMemName);
                map.put("subMemId", reportEventFirstAudioRecived.subMemId);
                break;
            }
            case STREAM_RECIEVE_FIRST_VIDEO_FRAME: {
                ReportEventFirstVideoRecived reportEventFirstVideoRecived = (ReportEventFirstVideoRecived)reportEvent;
                map.put("sId", reportEventFirstVideoRecived.sId);
                map.put("streamType", reportEventFirstVideoRecived.streamType);
                map.put("rtcId", reportEventFirstVideoRecived.rtcId);
                map.put("voff", reportEventFirstVideoRecived.voff);
                map.put("aoff", reportEventFirstVideoRecived.aoff);
                map.put("subMemName", reportEventFirstVideoRecived.subMemName);
                map.put("subMemId", reportEventFirstVideoRecived.subMemId);
                break;
            }
        }
    }

    private static JSONObject convertMapToJSONObject(Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object object;
            Object object2 = entry.getValue();
            if (object2 instanceof Map) {
                object = ReportUtils.convertMapToJSONObject((Map)object2);
            } else if (object2 instanceof List) {
                object = new JSONArray();
                for (Object e2 : (List)object2) {
                    ((JSONArray)object).put(e2);
                }
            } else if (object2 instanceof Object[]) {
                object = new JSONArray();
                for (Object object3 : (Object[])object2) {
                    ((JSONArray)object).put(object3);
                }
            } else {
                object = object2;
            }
            try {
                jSONObject.put(entry.getKey(), object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    static {
        report_logcallback = (n, string, string2) -> Log.i((String)string, (String)string2);
    }

    public static enum logLevel {
        LS_INFO,
        LS_DEBUG,
        LS_ERROR;

    }
}

