package com.hyphenate.chat;

/**
 * Created by lijian on 2020/05/08
 */

/**
 *  \~Chinese
 *  视频流在画布宽高及显示位置等参数
 *  x         在画布横坐标位置
 *  y         在画布纵坐标位置
 *  width     视频流宽度(64~1280)
 *  height    视频流高度(64~1280)
 *  zorder    视频流zorder层位置(最小值为 0（默认值），表示该区域图像位于最下层
 *                              最大值为 100，表示该区域图像位于最上层)
 *  style     视频流显示方式（fit模式或者fill模式)
 *  streamId  视频流ID
 *
 *
 *  \~English
 *  Video streaming in the canvas width and height and display location and other parameters
 *  x         On the horizontal position of the canvas
 *  y         On the vertical position of the canvas
 *  width     Video stream width
 *  height    Video stream height
 *  zorder    Video stream zorder layer location
 *  style     Video stream display mode (fit mode or fill mode)
 *  streamId  The video stream ID
 */
public class EMLiveRegion {
    private int x;
    private int y;
    private int width;
    private int height;
    private int zorder;
    private EMRegionStyle style;
    private String streamId;

    public EMLiveRegion(){}
    public EMLiveRegion(int x,int y, int width, int height, int zorder, EMRegionStyle style, String streamId){
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.zorder = zorder;
        this.style = style;
        this.streamId = streamId;
    }

    public enum EMRegionStyle {
        FIT, // fit模式
        FILL // fill模式
    }

    public String getStreamId() {
        return streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public int getX() {
        return x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getZorder() {
        return zorder;
    }

    public void setZorder(int zorder) {
        this.zorder = zorder;
    }

    public EMRegionStyle getStyle() {
        return style;
    }

    public void setStyle(EMRegionStyle style) {
        this.style = style;
    }
}
