package com.hyphenate.chat;


/**
 * Created by lijian on 2020/07/14
 */

/**
 \~chinese
 *  音频录制的配置信息
 *  bps        音频比特率，类型为 EMAudioBpsType枚举；
 *  channels   音频通道数,可选(1,2)，类型为ChannelsType枚举；
 *  samples    音频采样率，类型为 EMAudioSamplesType枚举；
 *
 *
 *  \~english
 *  The config of audio record.
 *  bps       audio bit rate,  type is EMAudioBpsType enum；
 *  channels  number of audio channels, optional (1,2), type is ChannelsType enum;
 *  samples   audio sampling rate, type is EMAudioSamplesType enum;
 *
 */

public class EMAudioConfig {
    EMAudioBpsType bps = EMAudioBpsType.BPS_64K;
    ChannelsType channels = ChannelsType.DUAL;
    EMAudioSamplesType samples = EMAudioSamplesType.SAMPLES_16K;

    public enum ChannelsType{
        SINGLE,  //单声道
        DUAL    //双声道
    }

    public EMAudioConfig(EMAudioBpsType bps, ChannelsType channels,EMAudioSamplesType samples){
        this.bps = bps;
        this.channels = channels;
        this.samples = samples;
    }

    public EMAudioConfig(){
    }

    public EMAudioBpsType getBps() {
        return bps;
    }

    public void setBps(EMAudioBpsType bps) {
        this.bps = bps;
    }

    public ChannelsType getChannels() {
        return channels;
    }

    public void setChannels(ChannelsType channels) {
        this.channels = channels;
    }

    public EMAudioSamplesType getSamples() {
        return samples;
    }

    public void setSamples(EMAudioSamplesType samples) {
        this.samples = samples;
    }
}
