/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.reporter;

import android.text.TextUtils;
import com.superrtc.StatsReport;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.reporter.RtcReportLogManager;
import com.superrtc.sdk.RtcConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class RtcReporterManager {
    private static final String TAG = "reporter";
    private static RtcReporterManager sInstance = new RtcReporterManager();
    private static final String TYPE_STREAM_VERSION = "11";
    private static final String TYPE_OPEN_CLOSE_CAMERA = "12";
    private static final String TYPE_OPEN_CLOSE_MIC = "13";
    private static final String TYPE_VIDEO_ACQUISITION_PARAMETERS = "14";
    private static final String TYPE_AUDIO_ACQUISITION_PARAMETERS = "15";
    private static final String TYPE_SUB_VIDEO_EVENT = "21";
    private static final String TYPE_SUB_AUDIO_EVENT = "22";
    private static final String TYPE_PUB_STREAM_EVENT = "23";
    private static final String TYPE_CANCEL_PUB_STREAM_EVENT = "24";
    private EMediaSession mediaSession;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public static RtcReporterManager getInstance() {
        return sInstance;
    }

    public void notifyInitVideoArgs(RtcConnection rtcConnection, final int n, final int n2, final int n3) {
        final String string = this.getStreamId(rtcConnection);
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_VIDEO_ACQUISITION_PARAMETERS, string, n + "", n2 + "", n3 + "");
            }
        });
    }

    public void notifyInitAudioArgs(final int n, final int n2, final int n3) {
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_AUDIO_ACQUISITION_PARAMETERS, n + "", n2 + "", n3 + "");
            }
        });
    }

    public void notifyJoinConference(final EMediaSession eMediaSession) {
        if (this.mediaSession != null) {
            this.notifyExit(this.mediaSession);
        }
        this.mediaSession = eMediaSession;
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().startWriteLog(RtcReporterManager.this.getSessionIdOrConfrId(eMediaSession));
            }
        });
    }

    private String getSessionIdOrConfrId(EMediaSession eMediaSession) {
        String string = eMediaSession.ticket;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.optString("confrId");
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    return string2;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return eMediaSession.instanceId;
    }

    public void notifyExit(EMediaSession eMediaSession) {
        this.mediaSession = null;
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().stopWriteLog();
            }
        });
    }

    public void notifyStreamVersion(final RtcConnection rtcConnection) {
        final String string = this.getStreamId(rtcConnection);
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_STREAM_VERSION, string, rtcConnection.getName(), RtcConnection.getVersion());
            }
        });
    }

    public void notifyStartCapture(RtcConnection rtcConnection, final boolean bl) {
        final String string = this.getStreamId(rtcConnection);
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_OPEN_CLOSE_CAMERA, string, "1", bl ? "0" : "1");
            }
        });
    }

    public void notifyStopCapture(RtcConnection rtcConnection, final boolean bl) {
        final String string = this.getStreamId(rtcConnection);
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_OPEN_CLOSE_CAMERA, string, "0", bl ? "0" : "1");
            }
        });
    }

    public void notifySetMute(RtcConnection rtcConnection, final boolean bl, final int n) {
        final String string = this.getStreamId(rtcConnection);
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                RtcReportLogManager.getInstance().writeLog(System.currentTimeMillis(), RtcReporterManager.TYPE_OPEN_CLOSE_MIC, string, !bl ? "1" : "0", n > 0 ? n + "" : "");
            }
        });
    }

    public void notifyStatsReport(final RtcConnection rtcConnection, final StatsReport[] statsReportArray) {
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                StatsEntity statsEntity = RtcReporterManager.this.convert(statsReportArray);
                String string = RtcReporterManager.this.getStreamId(rtcConnection);
                long l = System.currentTimeMillis();
                if (rtcConnection.getIsForPub()) {
                    if (statsEntity.sendAudioData != null) {
                        RtcReportLogManager.getInstance().writeLog(l, statsEntity.sendAudioData.type, string, statsEntity.sendAudioData.format());
                    }
                    if (statsEntity.sendVideoData != null) {
                        RtcReportLogManager.getInstance().writeLog(l, statsEntity.sendVideoData.type, string, statsEntity.sendVideoData.format());
                    }
                } else {
                    if (statsEntity.recvAudioData != null) {
                        RtcReportLogManager.getInstance().writeLog(l, statsEntity.recvAudioData.type, string, statsEntity.recvAudioData.format());
                    }
                    if (statsEntity.recvVideoData != null) {
                        RtcReportLogManager.getInstance().writeLog(l, statsEntity.recvVideoData.type, string, statsEntity.recvVideoData.format());
                    }
                }
            }
        });
    }

    private String getStreamId(RtcConnection rtcConnection) {
        String string = rtcConnection.pubStreamId;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = rtcConnection.streamId;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = rtcConnection.getName();
        }
        return string;
    }

    public void notifyPubArgs(final int n, final String string, final int n2) {
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                RtcReportLogManager.getInstance().writeLog(l, RtcReporterManager.TYPE_PUB_STREAM_EVENT, String.valueOf(n), string, n2 != 0 ? "0" : "1");
            }
        });
    }

    public void notifySubArgs(EMediaSession eMediaSession, final String string, final boolean bl, final int n) {
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                RtcReportLogManager.getInstance().writeLog(l, RtcReporterManager.TYPE_SUB_VIDEO_EVENT, string, bl ? "1" : "0", n != 0 ? "0" : "1");
                RtcReportLogManager.getInstance().writeLog(l, RtcReporterManager.TYPE_SUB_AUDIO_EVENT, string, "1", n != 0 ? "0" : "1");
            }
        });
    }

    public void notifyUnPubArgs(final int n, final String string, final int n2) {
        this.executeOnThread(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                RtcReportLogManager.getInstance().writeLog(l, RtcReporterManager.TYPE_CANCEL_PUB_STREAM_EVENT, String.valueOf(n), string, n2 != 0 ? "0" : "1");
            }
        });
    }

    private static Map<String, String> convertStatMap(StatsReport.Value[] valueArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (StatsReport.Value value : valueArray) {
            hashMap.put(value.name, value.value);
        }
        return hashMap;
    }

    public void executeOnThread(Runnable runnable) {
        this.executor.execute(runnable);
    }

    private StatsEntity convert(StatsReport[] statsReportArray) {
        StatsEntity statsEntity = new StatsEntity();
        RecvVideoData recvVideoData = null;
        RecvAudioData recvAudioData = null;
        SendAudioData sendAudioData = null;
        SendVideoData sendVideoData = null;
        for (StatsReport statsReport : statsReportArray) {
            String string = statsReport.id;
            double d2 = statsReport.timestamp;
            Map<String, String> map = RtcReporterManager.convertStatMap(statsReport.values);
            if (!statsReport.type.equals("ssrc")) continue;
            String string2 = this.valueFromMap(map, "mediaType");
            int n = 0;
            if ("audio".equalsIgnoreCase(string2)) {
                n = 1;
            } else if ("video".equalsIgnoreCase(string2)) {
                n = 2;
            }
            if (map.get("bytesReceived") != null) {
                if (n == 1) {
                    recvAudioData = new RecvAudioData();
                    recvAudioData.audioReceivedBytes = this.valueFromMap(map, "bytesReceived");
                    recvAudioData.audioReceivedPackets = this.valueFromMap(map, "packetsReceived");
                    recvAudioData.audioReceivedPacketLost = this.valueFromMap(map, "packetsLost");
                    recvAudioData.RTT = this.valueFromMap(map, "googRtt");
                    recvAudioData.audioOutputLevel = this.valueFromMap(map, "audioOutputLevel");
                    recvAudioData.audioReceivedEnergy = this.valueFromMap(map, "totalAudioEnergy");
                } else if (n == 2) {
                    recvVideoData = new RecvVideoData();
                    recvVideoData.videoReceivedBytes = this.valueFromMap(map, "bytesReceived");
                    recvVideoData.videoReceivedPackets = this.valueFromMap(map, "packetsReceived");
                    recvVideoData.videoReceivedPacketLost = this.valueFromMap(map, "packetsLost");
                    recvVideoData.RTT = this.valueFromMap(map, "googRtt");
                    recvVideoData.videoFramesDecoded = this.valueFromMap(map, "framesDecoded");
                    recvVideoData.googPlisSent = this.valueFromMap(map, "googPlisSent");
                    recvVideoData.googNacksSent = this.valueFromMap(map, "googNacksSent");
                    recvVideoData.googFrameWidthReceived = this.valueFromMap(map, "googFrameWidthReceived");
                    recvVideoData.googFrameHeightReceived = this.valueFromMap(map, "googFrameHeightReceived");
                }
            }
            if (map.get("bytesSent") == null) continue;
            if (n == 1) {
                sendAudioData = new SendAudioData();
                sendAudioData.audioSentBytes = this.valueFromMap(map, "bytesSent");
                sendAudioData.audioSentPackets = this.valueFromMap(map, "packetsSent");
                sendAudioData.audioSentPacketLost = this.valueFromMap(map, "packetsLost");
                sendAudioData.audioRTT = this.valueFromMap(map, "googRtt");
                sendAudioData.audioInputLevel = this.valueFromMap(map, "audioInputLevel");
                sendAudioData.audioSentEnergy = this.valueFromMap(map, "totalAudioEnergy");
                continue;
            }
            if (n != 2) continue;
            sendVideoData = new SendVideoData();
            sendVideoData.videoSentBytes = this.valueFromMap(map, "bytesSent");
            sendVideoData.videoSentPackets = this.valueFromMap(map, "packetsSent");
            sendVideoData.videoSentPacketLost = this.valueFromMap(map, "packetsLost");
            sendVideoData.videoRTT = this.valueFromMap(map, "googRtt");
            sendVideoData.videoFramesEncoded = this.valueFromMap(map, "framesEncoded");
            sendVideoData.googPlisReceived = this.valueFromMap(map, "googPlisReceived");
            sendVideoData.googNacksReceived = this.valueFromMap(map, "googNacksReceived");
            sendVideoData.googFrameWidthSent = this.valueFromMap(map, "googFrameWidthSent");
            sendVideoData.googFrameHeightSent = this.valueFromMap(map, "googFrameHeightSent");
        }
        statsEntity.recvAudioData = recvAudioData;
        statsEntity.recvVideoData = recvVideoData;
        statsEntity.sendAudioData = sendAudioData;
        statsEntity.sendVideoData = sendVideoData;
        return statsEntity;
    }

    private String valueFromMap(Map<String, String> map, String string) {
        try {
            String string2;
            if (map != null && string != null && (string2 = map.get(string)) != null) {
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    class RecvVideoData {
        String type = "34";
        String videoReceivedBytes;
        String videoReceivedPackets;
        String videoReceivedPacketLost;
        String RTT;
        String videoFramesDecoded;
        String googPlisSent;
        String googNacksSent;
        String googFrameWidthReceived;
        String googFrameHeightReceived;

        RecvVideoData() {
        }

        public String format() {
            return this.videoReceivedBytes + "," + this.videoReceivedPackets + "," + this.videoReceivedPacketLost + "," + this.RTT + "," + this.videoFramesDecoded + "," + this.googPlisSent + "," + this.googNacksSent + "," + this.googFrameWidthReceived + "," + this.googFrameHeightReceived;
        }
    }

    class RecvAudioData {
        String type = "33";
        String audioReceivedBytes;
        String audioReceivedPackets;
        String audioReceivedPacketLost;
        String RTT;
        String audioOutputLevel;
        String audioReceivedEnergy;

        RecvAudioData() {
        }

        public String format() {
            return this.audioReceivedBytes + "," + this.audioReceivedPackets + "," + this.audioReceivedPacketLost + "," + this.RTT + "," + this.audioOutputLevel + "," + this.audioReceivedEnergy;
        }
    }

    class SendVideoData {
        String type = "32";
        String videoSentBytes;
        String videoSentPackets;
        String videoSentPacketLost;
        String videoRTT;
        String videoFramesEncoded;
        String googPlisReceived;
        String googNacksReceived;
        String googFrameWidthSent;
        String googFrameHeightSent;

        SendVideoData() {
        }

        public String format() {
            return this.videoSentBytes + "," + this.videoSentPackets + "," + this.videoSentPacketLost + "," + this.videoRTT + "," + this.videoFramesEncoded + "," + this.googPlisReceived + "," + this.googNacksReceived + "," + this.googFrameWidthSent + "," + this.googFrameHeightSent;
        }
    }

    class SendAudioData {
        String type = "31";
        String audioSentBytes;
        String audioSentPackets;
        String audioSentPacketLost;
        String audioRTT;
        String audioInputLevel;
        String audioSentEnergy;

        SendAudioData() {
        }

        public String format() {
            return this.audioSentBytes + "," + this.audioSentPackets + "," + this.audioSentPacketLost + "," + this.audioRTT + "," + this.audioInputLevel + "," + this.audioSentEnergy;
        }
    }

    class StatsEntity {
        SendAudioData sendAudioData;
        SendVideoData sendVideoData;
        RecvAudioData recvAudioData;
        RecvVideoData recvVideoData;

        StatsEntity() {
        }
    }
}

