/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.OrientationEventListener;
import com.superrtc.Camera1Enumerator;
import com.superrtc.CameraEnumerationAndroid;
import com.superrtc.CameraSession;
import com.superrtc.Histogram;
import com.superrtc.ICameraInterface;
import com.superrtc.Logging;
import com.superrtc.NV21Buffer;
import com.superrtc.RendererCommon;
import com.superrtc.Size;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.TextureBufferImpl;
import com.superrtc.VideoFrame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported;
    private int lastSetCameraMagnification = 0;
    private boolean isTakePicture = false;
    static int myOrientation = 0;
    private static OrientationEventListener orientationEventListener = null;

    @Override
    public synchronized void takeCameraPicture(ICameraInterface.ITakeCallback iTakeCallback) {
        if (iTakeCallback == null) {
            return;
        }
        if (this.camera == null) {
            iTakeCallback.onError(100, "camera is null");
            return;
        }
        if (this.isTakePicture) {
            iTakeCallback.onError(102, "Previous take pic command do not execute finish.");
            return;
        }
        this.isTakePicture = true;
        this.camera.takePicture(null, null, (byArray, camera) -> {
            try {
                new Thread(() -> {
                    int n = this.getFrameOrientation();
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                    Matrix matrix = new Matrix();
                    matrix.reset();
                    matrix.postRotate((float)n);
                    Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    iTakeCallback.onTaken(bitmap2);
                }).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                iTakeCallback.onError(103, Log.getStackTraceString((Throwable)exception));
            }
            finally {
                camera.startPreview();
                this.isTakePicture = false;
            }
        });
    }

    @Override
    public void handleZoom(Float f2) {
        this.cameraThreadHandler.post(() -> {
            Camera.Parameters parameters;
            if (this.camera == null) {
                Logging.e(TAG, "camera is not Initialized");
            }
            if ((parameters = this.camera.getParameters()).isZoomSupported()) {
                int n = parameters.getMaxZoom();
                int n2 = parameters.getZoom();
                int n3 = f2.intValue();
                Logging.e(TAG, "handleZoom curzoom:" + n2 + ",last:" + this.lastSetCameraMagnification + " ,factor:" + n3);
                n2 = this.lastSetCameraMagnification == 0 ? (n2 *= n3) : (this.lastSetCameraMagnification < n3 ? (n2 *= n3 / this.lastSetCameraMagnification) : (n2 /= this.lastSetCameraMagnification / n3));
                if (n2 > n) {
                    n2 = n;
                } else if (n2 < 1) {
                    n2 = 1;
                }
                parameters.setZoom(n2);
                this.camera.setParameters(parameters);
                this.lastSetCameraMagnification = f2.intValue();
            } else {
                Logging.e(TAG, "zoom not supported");
            }
        });
    }

    @Override
    public void handleFocusMetering(int n, int n2, int n3, int n4, int n5, int n6) {
        this.cameraThreadHandler.post(() -> {
            ArrayList<Camera.Area> arrayList;
            int n5 = n;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            int[] nArray = new int[]{n5};
            int[] nArray2 = new int[]{n6};
            int[] nArray3 = new int[]{n7};
            int[] nArray4 = new int[]{n8};
            this.transformingPosition(nArray, nArray2, nArray3, nArray4);
            n5 = nArray[0];
            n6 = nArray2[0];
            n7 = nArray3[0];
            n8 = nArray4[0];
            Logging.e(TAG, "remote focus x:" + n5 + ", y:" + n6 + ",width:" + n7 + ", height:" + n8);
            Rect rect = Camera1Session.calculateTapArea(n5, n6, 1.0f, n7, n8);
            Rect rect2 = Camera1Session.calculateTapArea(n5, n6, 1.5f, n7, n8);
            Camera.Parameters parameters = this.camera.getParameters();
            String string = parameters.getFocusMode();
            if (parameters.getMaxNumFocusAreas() > 0) {
                this.camera.cancelAutoFocus();
                arrayList = new ArrayList<Camera.Area>();
                arrayList.add(new Camera.Area(rect, 800));
                parameters.setFocusAreas(arrayList);
            } else {
                Logging.e(TAG, "focus areas not supported");
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                arrayList = new ArrayList();
                arrayList.add(new Camera.Area(rect2, 800));
                parameters.setMeteringAreas(arrayList);
            } else {
                Logging.e(TAG, "metering areas not supported");
            }
            this.camera.setParameters(parameters);
            this.camera.autoFocus((bl, camera) -> {
                Logging.e(TAG, "onAutoFocus ok");
                Camera.Parameters parameters = camera.getParameters();
                parameters.setFocusMode(string);
                camera.setParameters(parameters);
            });
        });
    }

    @Override
    public void handleManualFocus(int n, int n2, int n3, int n4, int n5, int n6, RendererCommon.ScalingType scalingType) {
        this.cameraThreadHandler.post(() -> {
            ArrayList<Camera.Area> arrayList;
            if (this.camera == null) {
                Logging.e(TAG, "camera is not Initialized");
                return;
            }
            int n7 = n;
            int n8 = n2;
            int n9 = n3;
            int n10 = n4;
            int n11 = n5;
            int n12 = n6;
            if (scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
                if ((float)n3 / (float)n5 > (float)n4 / (float)n6) {
                    n12 = n4 * n5 / n3;
                    int n13 = (n6 - n12) / 2;
                    if (n2 < n13 || n2 > n6 - n13) {
                        return;
                    }
                    n8 = n2 - n13;
                } else {
                    n11 = n3 * n6 / n4;
                    int n14 = (n5 - n11) / 2;
                    if (n < n14 || n > n5 - n14) {
                        return;
                    }
                    n7 = n - n14;
                }
            } else if ((float)n3 / (float)n5 > (float)n4 / (float)n6) {
                n11 = n3 * n6 / n4;
                int n15 = (n11 - n5) / 2;
                n7 = n + n15;
            } else {
                n12 = n4 * n5 / n3;
                int n16 = (n12 - n6) / 2;
                n8 = n2 + n16;
            }
            int[] nArray = new int[]{n7};
            int[] nArray2 = new int[]{n8};
            int[] nArray3 = new int[]{n9};
            int[] nArray4 = new int[]{n10};
            this.transformPosition(nArray, nArray2, nArray3, nArray4, n11, n12);
            n7 = nArray[0];
            n8 = nArray2[0];
            n9 = nArray3[0];
            n10 = nArray4[0];
            Logging.e(TAG, "Manual focus x:" + n7 + ", y:" + n8 + ", width:" + n9 + ", height:" + n10);
            Rect rect = Camera1Session.calculateTapArea(n7, n8, 1.0f, n9, n10);
            Rect rect2 = Camera1Session.calculateTapArea(n7, n8, 1.5f, n9, n10);
            Camera.Parameters parameters = this.camera.getParameters();
            String string = parameters.getFocusMode();
            if (parameters.getMaxNumFocusAreas() > 0) {
                this.camera.cancelAutoFocus();
                arrayList = new ArrayList<Camera.Area>();
                arrayList.add(new Camera.Area(rect, 800));
                parameters.setFocusAreas(arrayList);
            } else {
                Logging.e(TAG, "focus areas not supported");
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                arrayList = new ArrayList();
                arrayList.add(new Camera.Area(rect2, 800));
                parameters.setMeteringAreas(arrayList);
            } else {
                Logging.e(TAG, "metering areas not supported");
            }
            this.camera.setParameters(parameters);
            this.camera.autoFocus((bl, camera) -> {
                Logging.e(TAG, "onAutoFocus ok");
                Camera.Parameters parameters = camera.getParameters();
                parameters.setFocusMode(string);
                camera.setParameters(parameters);
            });
        });
    }

    @Override
    public void handleManualZoom(boolean bl, int n) {
        this.cameraThreadHandler.post(() -> {
            if (this.camera == null) {
                Logging.e(TAG, "camera is not Initialized");
                return;
            }
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.isZoomSupported()) {
                int n2 = parameters.getMaxZoom();
                int n3 = parameters.getZoom();
                n3 = bl ? (n3 += n) : (n3 -= n);
                Logging.e(TAG, String.format("zoom camera max:%s, zoom:%s, scale:%s", n2, n3, n));
                if (n3 > n2) {
                    n3 = n2;
                } else if (n3 < 0) {
                    n3 = 0;
                }
                parameters.setZoom(n3);
                this.camera.setParameters(parameters);
            } else {
                Logging.e(TAG, "zoom not supported");
            }
        });
    }

    @Override
    public void handleFlashLight(boolean bl) {
        this.cameraThreadHandler.post(() -> {
            if (this.camera == null) {
                Logging.e(TAG, "camera is not Initialized");
                return;
            }
            Camera.Parameters parameters = this.camera.getParameters();
            if (bl) {
                parameters.setFlashMode("torch");
            } else {
                parameters.setFlashMode("off");
            }
            this.camera.setParameters(parameters);
        });
    }

    private void transformingPosition(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = this.getFrameOrientation();
        if (this.info.facing == 0) {
            if (n == 0) {
                nArray[0] = nArray3[0] * nArray[0] / 10000;
                nArray2[0] = nArray2[0] * nArray4[0] / 10000;
            } else if (n == 90) {
                int n2 = nArray3[0];
                nArray3[0] = nArray4[0];
                nArray4[0] = n2;
                n2 = nArray[0];
                nArray[0] = nArray2[0] * nArray3[0] / 10000;
                nArray2[0] = (10000 - n2) * nArray4[0] / 10000;
            } else if (n == 180) {
                nArray[0] = (10000 - nArray[0]) * nArray3[0] / 10000;
                nArray2[0] = (10000 - nArray2[0]) * nArray4[0] / 10000;
            } else if (n == 270) {
                int n3 = nArray3[0];
                nArray3[0] = nArray4[0];
                nArray4[0] = n3;
                n3 = nArray[0];
                nArray[0] = (10000 - nArray2[0]) * nArray3[0] / 10000;
                nArray2[0] = n3 * nArray4[0] / 10000;
            }
        } else if (n == 0) {
            nArray[0] = nArray[0] * nArray3[0] / 10000;
            nArray2[0] = nArray2[0] * nArray4[0] / 10000;
        } else if (n == 90) {
            int n4 = nArray3[0];
            nArray3[0] = nArray4[0];
            nArray4[0] = n4;
            n4 = nArray[0];
            nArray[0] = nArray2[0] * nArray3[0] / 10000;
            nArray2[0] = (10000 - n4) * nArray4[0] / 10000;
        } else if (n == 180) {
            nArray[0] = (10000 - nArray[0]) * nArray3[0] / 10000;
            nArray2[0] = (10000 - nArray2[0]) * nArray4[0] / 10000;
        } else if (n == 270) {
            int n5 = nArray3[0];
            nArray3[0] = nArray4[0];
            nArray4[0] = n5;
            n5 = nArray[0];
            nArray[0] = (10000 - nArray2[0]) * nArray3[0] / 10000;
            nArray2[0] = n5 * nArray4[0] / 10000;
        }
    }

    private static Rect calculateTapArea(float f2, float f3, float f4, int n, int n2) {
        float f5 = 300.0f;
        int n3 = Float.valueOf(f5 * f4).intValue();
        int n4 = (int)(f2 / (float)n * 2000.0f - 1000.0f);
        int n5 = (int)(f3 / (float)n2 * 2000.0f - 1000.0f);
        int n6 = n3 / 2;
        RectF rectF = new RectF((float)Camera1Session.clamp(n4 - n6, -1000, 1000), (float)Camera1Session.clamp(n5 - n6, -1000, 1000), (float)Camera1Session.clamp(n4 + n6, -1000, 1000), (float)Camera1Session.clamp(n5 + n6, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int n, int n2, int n3) {
        if (n > n3) {
            return n3;
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    private void transformPosition(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int n2) {
        int n3 = this.getFrameOrientation();
        if (this.info.facing == 1) {
            nArray[0] = n - nArray[0];
            if (n3 == 0) {
                nArray[0] = nArray3[0] * nArray[0] / n;
                nArray2[0] = nArray2[0] * nArray4[0] / n2;
            } else if (n3 == 90) {
                int n4 = nArray3[0];
                nArray3[0] = nArray4[0];
                nArray4[0] = n4;
                n4 = nArray[0];
                nArray[0] = nArray2[0] * nArray3[0] / n2;
                nArray2[0] = (n - n4) * nArray4[0] / n;
            } else if (n3 == 180) {
                nArray[0] = (n - nArray[0]) * nArray3[0] / n;
                nArray2[0] = (n2 - nArray2[0]) * nArray4[0] / n2;
            } else if (n3 == 270) {
                int n5 = nArray3[0];
                nArray3[0] = nArray4[0];
                nArray4[0] = n5;
                n5 = nArray[0];
                nArray[0] = (n2 - nArray2[0]) * nArray3[0] / n2;
                nArray2[0] = n5 * nArray4[0] / n;
            }
        } else if (n3 == 0) {
            nArray[0] = nArray[0] * nArray3[0] / n;
            nArray2[0] = nArray2[0] * nArray4[0] / n2;
        } else if (n3 == 90) {
            int n6 = nArray3[0];
            nArray3[0] = nArray4[0];
            nArray4[0] = n6;
            n6 = nArray[0];
            nArray[0] = nArray2[0] * nArray3[0] / n2;
            nArray2[0] = (n - n6) * nArray4[0] / n;
        } else if (n3 == 180) {
            nArray[0] = (n - nArray[0]) * nArray3[0] / n;
            nArray2[0] = (n2 - nArray2[0]) * nArray4[0] / n2;
        } else if (n3 == 270) {
            int n7 = nArray3[0];
            nArray3[0] = nArray4[0];
            nArray4[0] = n7;
            n7 = nArray[0];
            nArray[0] = (n2 - nArray2[0]) * nArray3[0] / n2;
            nArray2[0] = n7 * nArray4[0] / n;
        }
    }

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, boolean bl, Context context, final SurfaceTextureHelper surfaceTextureHelper, int n, final int n2, final int n3, int n4) {
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera camera;
        long l = System.nanoTime();
        Logging.d(TAG, "Open camera " + n);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)n);
        }
        catch (RuntimeException runtimeException) {
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
            return;
        }
        if (camera == null) {
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + n);
            return;
        }
        Logging.e(TAG, "camera open success");
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException exception) {
            camera.release();
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, exception.getMessage());
            return;
        }
        Logging.e(TAG, "setPreviewTexture -end-");
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        try {
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n2, n3, n4);
            Size size = Camera1Session.findClosestPictureSize(parameters, n2, n3);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, size, bl);
        }
        catch (RuntimeException runtimeException) {
            camera.release();
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
            return;
        }
        if (!bl) {
            int n5 = captureFormat.frameSize();
            for (int k = 0; k < 3; ++k) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
                camera.addCallbackBuffer(byteBuffer.array());
            }
        }
        if ((orientationEventListener = new OrientationEventListener(context){

            public void onOrientationChanged(int n) {
                if (n == -1) {
                    return;
                }
                if (n > 350 || n < 10) {
                    myOrientation = 0;
                    surfaceTextureHelper.setTextureSize(n2, n3);
                } else if (n > 80 && n < 100) {
                    myOrientation = 90;
                    surfaceTextureHelper.setTextureSize(n3, n2);
                } else if (n > 170 && n < 190) {
                    myOrientation = 180;
                    surfaceTextureHelper.setTextureSize(n2, n3);
                } else if (n > 260 && n < 280) {
                    myOrientation = 270;
                    surfaceTextureHelper.setTextureSize(n3, n2);
                }
                camera.setDisplayOrientation(myOrientation);
            }
        }).canDetectOrientation()) {
            orientationEventListener.enable();
        } else {
            orientationEventListener.disable();
        }
        createSessionCallback.onDone(new Camera1Session(events, bl, context, surfaceTextureHelper, n, camera, cameraInfo, captureFormat, l));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size size, boolean bl) {
        List list = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(size.width, size.height);
        if (!bl) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int n, int n2, int n3) {
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + list);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list, n3);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), n, n2);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, size);
        return new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, framerateRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int n, int n2) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), n, n2);
    }

    private Camera1Session(CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, int n, Camera camera, Camera.CameraInfo cameraInfo, CameraEnumerationAndroid.CaptureFormat captureFormat, long l) {
        Logging.d(TAG, "Create new camera1 session on camera " + n);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = bl;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n;
        this.camera = camera;
        this.info = cameraInfo;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = l;
        surfaceTextureHelper.setCameraInfo(cameraInfo.facing == 1);
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l = System.nanoTime();
            this.stopInternal();
            int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
            camera1StopTimeMsHistogram.addSample(n);
        }
    }

    private void startCapturing() {
        Logging.d(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int n, Camera camera) {
                String string = n == 100 ? "Camera server died!" : "Camera error: " + n;
                Logging.e(Camera1Session.TAG, string);
                Camera1Session.this.stopInternal();
                if (n == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, string);
                }
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
        }
        catch (RuntimeException runtimeException) {
            this.stopInternal();
            this.events.onCameraError(this, runtimeException.getMessage());
        }
        Logging.e(TAG, "Camera Start preview");
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        orientationEventListener.disable();
        orientationEventListener.canDetectOrientation();
        this.camera.stopPreview();
        this.camera.release();
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(videoFrame -> {
            this.checkIsOnCameraThread();
            if (this.state != SessionState.RUNNING) {
                Logging.d(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs);
                camera1StartTimeMsHistogram.addSample(n);
                this.firstFrameReported = true;
            }
            VideoFrame videoFrame2 = this.surfaceTextureHelper.GetWatermark() == null ? new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)videoFrame.getBuffer(), this.info.facing == 1, 0), this.getFrameOrientation(), videoFrame.getTimestampNs()) : new VideoFrame(videoFrame.getBuffer(), this.getFrameOrientation(), videoFrame.getTimestampNs());
            this.surfaceTextureHelper.getVideoSink().onFrame(videoFrame2);
            this.events.onFrameCaptured(this, videoFrame2);
            videoFrame2.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] byArray, Camera camera) {
                Camera1Session.this.checkIsOnCameraThread();
                if (camera != Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long l = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    int n = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(n);
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer nV21Buffer = new NV21Buffer(byArray, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(byArray);
                    }
                }));
                VideoFrame videoFrame = new VideoFrame(nV21Buffer, Camera1Session.this.getFrameOrientation(), l);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, videoFrame);
                videoFrame.release();
            }
        });
    }

    private int getFrameOrientation() {
        int n = CameraSession.getDeviceOrientation(this.applicationContext);
        if (this.info.facing == 0) {
            n = 360 - n;
        }
        return (this.info.orientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

