/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import internal.org.java_websocket.WebSocket;
import internal.org.java_websocket.a;
import internal.org.java_websocket.b.d;
import internal.org.java_websocket.b.f;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.drafts.c;
import internal.org.java_websocket.exceptions.InvalidHandshakeException;
import internal.org.java_websocket.framing.Framedata;
import internal.org.java_websocket.h;
import internal.org.java_websocket.i;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public abstract class SRWebSocket
extends a
implements WebSocket,
Runnable {
    protected URI uri = null;
    private h engine = null;
    private Socket socket = null;
    private InputStream istream;
    private OutputStream ostream;
    private Proxy proxy = Proxy.NO_PROXY;
    private Thread writeThread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    private int connectTimeout = 0;

    public SRWebSocket(URI uRI) {
        this(uRI, new c());
    }

    public SRWebSocket(URI uRI, Draft draft) {
        this(uRI, draft, null, 0);
    }

    public SRWebSocket(URI uRI, Draft draft, Map<String, String> map, int n) {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = uRI;
        this.draft = draft;
        this.headers = map;
        this.connectTimeout = n;
        this.setTcpNoDelay(true);
        this.engine = new h((i)this, draft);
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void connect() {
        if (this.writeThread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.writeThread = new Thread(this);
        this.writeThread.start();
    }

    public boolean connectBlocking() throws InterruptedException {
        this.connect();
        this.connectLatch.await();
        return this.engine.isOpen();
    }

    @Override
    public void close() {
        if (this.writeThread != null) {
            this.engine.close(1000);
        }
    }

    public void closeBlocking() throws InterruptedException {
        this.close();
        this.closeLatch.await();
    }

    @Override
    public void send(String string) throws NotYetConnectedException {
        this.engine.send(string);
    }

    @Override
    public void send(byte[] byArray) throws NotYetConnectedException {
        this.engine.send(byArray);
    }

    @Override
    protected Collection<WebSocket> connections() {
        return Collections.singletonList(this.engine);
    }

    @Override
    public void sendPing() throws NotYetConnectedException {
        this.engine.sendPing();
    }

    @Override
    public void run() {
        try {
            if (this.socket == null) {
                this.socket = new Socket(this.proxy);
            } else if (this.socket.isClosed()) {
                throw new IOException();
            }
            this.socket.setTcpNoDelay(this.isTcpNoDelay());
            if (!this.socket.isBound()) {
                this.socket.connect(new InetSocketAddress(this.uri.getHost(), this.getPort()), this.connectTimeout);
            }
            this.istream = this.socket.getInputStream();
            this.ostream = this.socket.getOutputStream();
            this.sendHandshake();
        }
        catch (Exception exception) {
            this.onWebsocketError(this.engine, exception);
            this.engine.closeConnection(-1, exception.getMessage());
            return;
        }
        this.writeThread = new Thread(new WebsocketWriteThread());
        this.writeThread.start();
        byte[] byArray = new byte[h.c];
        try {
            int n;
            while (!this.isClosing() && !this.isClosed() && (n = this.istream.read(byArray)) != -1) {
                this.engine.a(ByteBuffer.wrap(byArray, 0, n));
            }
            this.engine.b();
        }
        catch (IOException iOException) {
            this.engine.b();
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
            this.engine.closeConnection(1006, runtimeException.getMessage());
        }
        assert (this.socket.isClosed());
    }

    private int getPort() {
        int n = this.uri.getPort();
        if (n == -1) {
            String string = this.uri.getScheme();
            if (string.equals("wss")) {
                return 443;
            }
            if (string.equals("ws")) {
                return 80;
            }
            throw new RuntimeException("unknown scheme: " + string);
        }
        return n;
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String string = this.uri.getRawPath();
        String string2 = this.uri.getRawQuery();
        String string3 = string == null || string.length() == 0 ? "/" : string;
        if (string2 != null) {
            string3 = string3 + "?" + string2;
        }
        int n = this.getPort();
        String string4 = this.uri.getHost() + (n != 80 ? ":" + n : "");
        d d2 = new d();
        d2.a(string3);
        d2.a("Host", string4);
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                d2.a(entry.getKey(), entry.getValue());
            }
        }
        this.engine.a(d2);
    }

    @Override
    public WebSocket.READYSTATE getReadyState() {
        return this.engine.getReadyState();
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        this.onMessage(string);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.onMessage(byteBuffer);
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket webSocket, Framedata framedata) {
        this.onFragment(framedata);
    }

    @Override
    public final void onWebsocketOpen(WebSocket webSocket, f f2) {
        this.startConnectionLostTimer();
        this.onOpen((internal.org.java_websocket.b.h)f2);
        this.connectLatch.countDown();
    }

    @Override
    public final void onWebsocketClose(WebSocket webSocket, int n, String string, boolean bl) {
        this.stopConnectionLostTimer();
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            this.onWebsocketError(this, iOException);
        }
        this.onClose(n, string, bl);
        this.connectLatch.countDown();
        this.closeLatch.countDown();
    }

    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        this.onError(exception);
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n, String string) {
        this.onCloseInitiated(n, string);
    }

    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n, String string, boolean bl) {
        this.onClosing(n, string, bl);
    }

    public void onCloseInitiated(int n, String string) {
    }

    public void onClosing(int n, String string, boolean bl) {
    }

    public WebSocket getConnection() {
        return this.engine;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket webSocket) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket webSocket) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        return null;
    }

    public abstract void onOpen(internal.org.java_websocket.b.h var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer byteBuffer) {
    }

    public void onFragment(Framedata framedata) {
    }

    public void setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        this.proxy = proxy;
    }

    public void setSocket(Socket socket) {
        if (this.socket != null) {
            throw new IllegalStateException("socket has already been set");
        }
        this.socket = socket;
    }

    @Override
    public void sendFragmentedFrame(Framedata.Opcode opcode, ByteBuffer byteBuffer, boolean bl) {
        this.engine.sendFragmentedFrame(opcode, byteBuffer, bl);
    }

    @Override
    public boolean isOpen() {
        return this.engine.isOpen();
    }

    @Override
    public boolean isFlushAndClose() {
        return this.engine.isFlushAndClose();
    }

    @Override
    public boolean isClosed() {
        return this.engine.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.engine.isClosing();
    }

    @Override
    public boolean isConnecting() {
        return this.engine.isConnecting();
    }

    @Override
    public boolean hasBufferedData() {
        return this.engine.hasBufferedData();
    }

    @Override
    public void close(int n) {
        this.engine.close();
    }

    @Override
    public void close(int n, String string) {
        this.engine.close(n, string);
    }

    @Override
    public void closeConnection(int n, String string) {
        this.engine.closeConnection(n, string);
    }

    @Override
    public void send(ByteBuffer byteBuffer) throws IllegalArgumentException, NotYetConnectedException {
        this.engine.send(byteBuffer);
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.engine.sendFrame(framedata);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.engine.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.engine.getRemoteSocketAddress();
    }

    @Override
    public String getResourceDescriptor() {
        return this.uri.getPath();
    }

    private class WebsocketWriteThread
    implements Runnable {
        private WebsocketWriteThread() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebsocketWriteThread");
            try {
                while (!Thread.interrupted()) {
                    ByteBuffer byteBuffer = ((SRWebSocket)SRWebSocket.this).engine.e.take();
                    SRWebSocket.this.ostream.write(byteBuffer.array(), 0, byteBuffer.limit());
                    SRWebSocket.this.ostream.flush();
                }
            }
            catch (IOException iOException) {
                SRWebSocket.this.engine.b();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

