/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.JniCommon;
import com.superrtc.RefCountDelegate;
import com.superrtc.VideoFrame;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final RefCountDelegate refCountDelegate;

    private JavaI420Buffer(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, @Nullable Runnable runnable) {
        this.width = n;
        this.height = n2;
        this.dataY = byteBuffer;
        this.dataU = byteBuffer2;
        this.dataV = byteBuffer3;
        this.strideY = n3;
        this.strideU = n4;
        this.strideV = n5;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    private static void checkCapacity(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4 = n3 * (n2 - 1) + n;
        if (byteBuffer.capacity() < n4) {
            throw new IllegalArgumentException("Buffer must be at least " + n4 + " bytes, but was " + byteBuffer.capacity());
        }
    }

    public static JavaI420Buffer wrap(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, @Nullable Runnable runnable) {
        if (byteBuffer == null || byteBuffer2 == null || byteBuffer3 == null) {
            throw new IllegalArgumentException("Data buffers cannot be null.");
        }
        if (!(byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect())) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        byteBuffer = byteBuffer.slice();
        byteBuffer2 = byteBuffer2.slice();
        byteBuffer3 = byteBuffer3.slice();
        int n6 = (n + 1) / 2;
        int n7 = (n2 + 1) / 2;
        JavaI420Buffer.checkCapacity(byteBuffer, n, n2, n3);
        JavaI420Buffer.checkCapacity(byteBuffer2, n6, n7, n4);
        JavaI420Buffer.checkCapacity(byteBuffer3, n6, n7, n5);
        return new JavaI420Buffer(n, n2, byteBuffer, n3, byteBuffer2, n4, byteBuffer3, n5, runnable);
    }

    public static JavaI420Buffer allocate(int n, int n2) {
        int n3 = (n2 + 1) / 2;
        int n4 = (n + 1) / 2;
        int n5 = 0;
        int n6 = n5 + n * n2;
        int n7 = n6 + n4 * n3;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n * n2 + 2 * n4 * n3);
        byteBuffer.position(n5);
        byteBuffer.limit(n6);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n6);
        byteBuffer.limit(n7);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n7);
        byteBuffer.limit(n7 + n4 * n3);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        return new JavaI420Buffer(n, n2, byteBuffer2, n, byteBuffer3, n4, byteBuffer4, n4, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        return JavaI420Buffer.cropAndScaleI420(this, n, n2, n3, n4, n5, n6);
    }

    public static VideoFrame.Buffer cropAndScaleI420(VideoFrame.I420Buffer i420Buffer, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 == n5 && n4 == n6) {
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            byteBuffer.position(n + n2 * i420Buffer.getStrideY());
            byteBuffer2.position(n / 2 + n2 / 2 * i420Buffer.getStrideU());
            byteBuffer3.position(n / 2 + n2 / 2 * i420Buffer.getStrideV());
            i420Buffer.retain();
            return JavaI420Buffer.wrap(n5, n6, byteBuffer.slice(), i420Buffer.getStrideY(), byteBuffer2.slice(), i420Buffer.getStrideU(), byteBuffer3.slice(), i420Buffer.getStrideV(), i420Buffer::release);
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n5, n6);
        JavaI420Buffer.nativeCropAndScaleI420(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), n, n2, n3, n4, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), n5, n6);
        return javaI420Buffer;
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);
}

