/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.VideoCodecInfo;
import java.util.HashMap;
import java.util.Map;

class H264Utils {
    public static final String H264_FMTP_PROFILE_LEVEL_ID = "profile-level-id";
    public static final String H264_FMTP_LEVEL_ASYMMETRY_ALLOWED = "level-asymmetry-allowed";
    public static final String H264_FMTP_PACKETIZATION_MODE = "packetization-mode";
    public static final String H264_PROFILE_CONSTRAINED_BASELINE = "42e0";
    public static final String H264_PROFILE_CONSTRAINED_HIGH = "640c";
    public static final String H264_LEVEL_3_1 = "1f";
    public static final String H264_CONSTRAINED_HIGH_3_1 = "640c1f";
    public static final String H264_CONSTRAINED_BASELINE_3_1 = "42e01f";
    public static VideoCodecInfo DEFAULT_H264_BASELINE_PROFILE_CODEC = new VideoCodecInfo("H264", H264Utils.getDefaultH264Params(false));
    public static VideoCodecInfo DEFAULT_H264_HIGH_PROFILE_CODEC = new VideoCodecInfo("H264", H264Utils.getDefaultH264Params(true));

    H264Utils() {
    }

    public static Map<String, String> getDefaultH264Params(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(H264_FMTP_LEVEL_ASYMMETRY_ALLOWED, "1");
        hashMap.put(H264_FMTP_PACKETIZATION_MODE, "1");
        hashMap.put(H264_FMTP_PROFILE_LEVEL_ID, bl ? H264_CONSTRAINED_HIGH_3_1 : H264_CONSTRAINED_BASELINE_3_1);
        return hashMap;
    }

    public static boolean isSameH264Profile(Map<String, String> map, Map<String, String> map2) {
        return H264Utils.nativeIsSameH264Profile(map, map2);
    }

    private static native boolean nativeIsSameH264Profile(Map<String, String> var0, Map<String, String> var1);
}

