package com.hyphenate.chat;

/**
 * Created by lijian on 2020/04/22.
 */

/**
 *  \~Chinese
 *  CDN推流设置
 *  cdnurl     cdn推流地址
 *  cdnCanvas  画布设置 （cdnCanvas可以缺省）
 *  record     设置是否录制推往CDN的流
 *  audioConfig  设置音频录制的配置信息
 *  liveLayoutStyle 设置CDN推流使用的画布类型
 *
 *  \~English
 *  The CDN push stream config
 *  cdnurl      cdn push stream address
 *  cdnCanvas   canvas settings (cdnCanvas can be default)
 *  record      whether to enable the recording push network CDN to remain
 *  audioConfig   set the audio recording configuration information
 *  liveLayoutStyle  sets the canvas type used by the CDN push stream
 */

public class EMLiveConfig {
    private String cdnurl;
    private EMCDNCanvas cdnCanvas = null;
    private boolean record = false;
    private EMAudioConfig audioConfig = null;

    private EMLiveLayoutStyle liveLayoutStyle = EMLiveLayoutStyle.GRID;

    public EMLiveConfig(){

    }

    public EMLiveConfig(String cdnurl, EMCDNCanvas cdnCanvas){
        this.cdnurl = cdnurl;
        this.cdnCanvas = cdnCanvas;
    }

    public String getCdnurl() {
        return cdnurl;
    }

    public void setCdnurl(String cdnurl) {
        this.cdnurl = cdnurl;
    }

    public EMCDNCanvas getCdnCanvas() {
        return cdnCanvas;
    }

    public void setCdnCanvas(EMCDNCanvas cdnCanvas) {
        this.cdnCanvas = cdnCanvas;
    }

    public EMLiveLayoutStyle getLiveLayoutStyle() { return liveLayoutStyle; }

    void setLiveLayoutStyle(EMLiveLayoutStyle liveLayoutStyle) { this.liveLayoutStyle = liveLayoutStyle; }

    public boolean isRecord() { return record; }

    public void setRecord(boolean record) { this.record = record; }

    public EMAudioConfig getAudioConfig() { return audioConfig; }

    public void setAudioConfig(EMAudioConfig audioConfig) { this.audioConfig = audioConfig; }
}
