/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import java.io.File;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

/**
 * \~chinese
 * 图片消息体
 *
 * EMImageMessageBody body = new EMImageMessageBody(imageFile);
 *
 * \~english
 * the image message body class
 *
 * EMImageMessageBody body = new EMImageMessageBody(imageFile);
 *
 */
public class EMImageMessageBody extends EMFileMessageBody implements Parcelable {
	private static final String TAG = EMImageMessageBody.class.getSimpleName();
	
	private boolean sendOriginalImage = false;
    
    /**
     * \~chinese
     * 创建一个图片消息体
     * @param imageFile 图片文件
	 * @deprecated 使用 {@link #EMImageMessageBody(Uri)}
     * 
     * \~english
     * create a image message body
	 *
     * @param imageFile the image file
	 * @deprecated Use {@link #EMImageMessageBody(Uri)}
     */
    @Deprecated
    public EMImageMessageBody(File imageFile){
    	super(Uri.fromFile(imageFile), EMAMessageBody.EMAMessageBodyType_IMAGE);
    }

    /**
     * \~chinese
     * 创建一个图片消息体
     * @param imageUri 图片uri
     *
     * \~english
     * create a image message body
	 *
     * @param imageUri the image uri
     */
    public EMImageMessageBody(Uri imageUri){
    	super(imageUri, EMAMessageBody.EMAMessageBodyType_IMAGE);
    }

	/**
	 * \~chinese
	 * 创建一个图片消息体
	 *
	 * @param imageFile 	图片文件
	 * @param imageFile 	缩略图
	 * @deprecated 使用 {@link #EMImageMessageBody(Uri, Uri)}
	 *
	 * \~english
	 * create a image message body with original image, but also upload thumbnail to server
	 *
	 * @param imageFile 		the original image file
	 * @param thumbnailFile		the thumbnail image file
	 * @deprecated Use {@link #EMImageMessageBody(Uri, Uri)}
	 */
	@Deprecated
    public EMImageMessageBody(File imageFile, File thumbnailFile) {
        super(Uri.fromFile(imageFile), EMAMessageBody.EMAMessageBodyType_IMAGE);
        ((EMAImageMessageBody)emaObject).setThumbnailLocalPath(thumbnailFile == null ?
				"" : Uri.fromFile(thumbnailFile).toString());
    }

	/**
	 * \~chinese
	 * 创建一个图片消息体
	 *
	 * @param imageLocalPath 	图片uri
	 * @param thumbnailPath 	缩略图uri
	 *
	 * \~english
	 * create a image message body with original image, but also upload thumbnail to server
	 *
	 * @param imageLocalPath 		the original image uri
	 * @param thumbnailPath		the thumbnail image uri
	 */
    public EMImageMessageBody(Uri imageLocalPath, Uri thumbnailPath) {
        super(imageLocalPath, EMAMessageBody.EMAMessageBodyType_IMAGE);
        ((EMAImageMessageBody)emaObject).setThumbnailLocalPath(thumbnailPath != null ?
				thumbnailPath.toString() : "");
    }

    public EMImageMessageBody(EMAImageMessageBody body) {
    	super(body);
	}
    
    /**
     * create EMImageMessageBody from incoming message
	 *
     * @param fileName
     * @param remoteUrl
     * @param thumbnailUrl
     */
    EMImageMessageBody(String fileName, String remoteUrl, String thumbnailUrl) {
    	super((Uri) null, EMAMessageBody.EMAMessageBodyType_IMAGE);
    	emaObject = new EMAImageMessageBody((Uri) null, (Uri) null);
    	((EMAImageMessageBody)emaObject).setDisplayName(fileName);
    	((EMAImageMessageBody)emaObject).setRemotePath(remoteUrl);
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    /**
     * \~chinese
     * 获取缩略图的url
     * 接受消息时，接收方会自动根据thumbnailRemotePath下载缩略图，存储到本地
     * @return
     * 
     * \~english
     * Server url path of thumbnail
     * Image receiver will get thumbnail stored under thumbnailRemotePath after a successful download automatically.
     * @return
     */
    public String getThumbnailUrl() {
		return ((EMAImageMessageBody) emaObject).thumbnailRemotePath();
    }
    
    /**
     * \~chinese
     * 设置缩略图路径
     * @param thumbnailUrl
     * 
     * \~english
     * set the thumbnail url
     * @param thumbnailUrl
     */
    public void setThumbnailUrl(String thumbnailUrl) {
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    public String toString() {
        return "image: " + ((EMAImageMessageBody)emaObject).displayName() +
				", localurl: " + ((EMAImageMessageBody)emaObject).getLocalUrl() +
				", remoteurl: " + ((EMAImageMessageBody)emaObject).getRemoteUrl() +
				", thumbnail: " + ((EMAImageMessageBody)emaObject).thumbnailRemotePath();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        //members from FileMessageBody
        dest.writeString(((EMAImageMessageBody)emaObject).displayName());
        dest.writeString(((EMAImageMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMAImageMessageBody)emaObject).getRemoteUrl());
        dest.writeString(((EMAImageMessageBody)emaObject).thumbnailRemotePath());
        
        dest.writeInt(((EMAImageMessageBody)emaObject).width());
        dest.writeInt(((EMAImageMessageBody)emaObject).height());
        
    }
    
    public static final Parcelable.Creator<EMImageMessageBody> CREATOR
            = new Parcelable.Creator<EMImageMessageBody>() {
        public EMImageMessageBody createFromParcel(Parcel in) {
            return new EMImageMessageBody(in);
        }

        public EMImageMessageBody[] newArray(int size) {
            return new EMImageMessageBody[size];
        }
    };

    private EMImageMessageBody(Parcel in) {
    	super((Uri) null, EMAMessageBody.EMAMessageBodyType_IMAGE);
        //members from FileMessageBody
    	((EMAImageMessageBody)emaObject).setDisplayName(in.readString());
    	((EMAImageMessageBody)emaObject).setLocalPath(in.readString());
    	((EMAImageMessageBody)emaObject).setRemotePath(in.readString());
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(in.readString());
		int width = in.readInt();
		int height = in.readInt();
		((EMAImageMessageBody) emaObject).setSize(width, height);
    }
    
    public void setThumbnailSecret(String secret) {
    	((EMAImageMessageBody)emaObject).setThumbnailSecretKey(secret);
    }
    
    public String getThumbnailSecret() {
    	return ((EMAImageMessageBody)emaObject).thumbnailSecretKey();
    }
    
    /**
     * \~chinese
     * 设置发送图片时，是否发送原图，默认是发送压缩过后的图(图片超过100k会被压缩)
     * @param sendOriginalImage
     * 
     * \~english
     * set whether send original image when sending image, 
     * the default is to send the figure after the compression(image greater than 100k will be compress)
     * @param sendOriginalImage
     */
    public void setSendOriginalImage(boolean sendOriginalImage) {
    	this.sendOriginalImage = sendOriginalImage;
    }
    
    /**
     * \~chinese
     * 获取发送图片时，是否发送原图
     * @return
     * 
     * \~english
     * get whether send original image
     */
    public boolean isSendOriginalImage(){
    	return sendOriginalImage;
    }
    
    /**
     * \~chinese
     * 获取图片的宽度
     * @return
     * 
     * \~english
     * get image width
     * @return
     */
    public int getWidth() {
		return ((EMAImageMessageBody)emaObject).width();
	}

    /**
     * \~chinese
     * 获取图片的高度
     * @return
     * 
     * \~english
     * get image height
     * @return
     */
	public int getHeight() {
		return ((EMAImageMessageBody)emaObject).height();
	}
	
	/**
     * \~chinese
     * 获取图片文件名字
     * @return
     * 
     * \~english
     * get image file name
     * @return
     */
	public String getFileName() {
		return ((EMAImageMessageBody)emaObject).displayName();
	}
	
	void setSize(int width, int height) {
		((EMAImageMessageBody)emaObject).setSize(width, height);
	}
	
	/**
     * \~chinese
     * 获取缩略图本地路径
     * @return
	 * @deprecated 使用 {@link #thumbnailLocalUri()}
     * 
     * \~english
     * get local path of thumbnail
     * @return
	 * @deprecated Use {@link #thumbnailLocalUri()}
     */
	@Deprecated
	public String thumbnailLocalPath() {
		Uri uri = thumbnailLocalUri();
		String filePath = UriUtils.getFilePath(EMClient.getInstance().getContext(), uri);
		if(TextUtils.isEmpty(filePath) && VersionUtils.isTargetQ(EMClient.getInstance().getContext())) {
			EMLog.e(TAG, "请调用thumbnailLocalPathUri()");
			return uri != null ? uri.toString() : "";
		}
		return filePath;
	}

	/**
     * \~chinese
     * 获取缩略图本地路径
     * @return
     *
     * \~english
     * get local path of thumbnail
     * @return
     */
	public Uri thumbnailLocalUri() {
		return UriUtils.getLocalUriFromString(((EMAImageMessageBody)emaObject).thumbnailLocalPath());
	}

	/**
     * \~chinese
     * 设置缩略图本地路径
     *
     * \~english
     * set local path of thumbnail
     */
    public void setThumbnailLocalPath(String localPath) {
		Uri eUri = UriUtils.getLocalUriFromString(localPath);
		((EMAImageMessageBody)emaObject).setThumbnailLocalPath(eUri != null ? eUri.toString() : "");
    }

	/**
     * \~chinese
     * 设置缩略图本地路径
     *
     * \~english
     * set local path of thumbnail
     */
    public void setThumbnailLocalPath(Uri localPath) {
        ((EMAImageMessageBody)emaObject).setThumbnailLocalPath(UriUtils.getUriString(localPath));
    }

	/**
	 * \~chinese
	 * 设置缩略图的宽和高
	 *
	 * \~english
	 * set the width and height of the thumbnail image
	 */
    public void setThumbnailSize(int width, int height) {
		((EMAImageMessageBody)emaObject).setThumbnailSize(width, height);
	}

	/**
	 * \~chinese
	 * 获取缩略图的下载状态
	 * @return
	 * 
	 * \~english
	 * get the download status of the thumbnail
	 * @return
	 */
	public EMDownloadStatus thumbnailDownloadStatus() {
	    EMADownloadStatus _status = ((EMAImageMessageBody)emaObject).thumbnailDownloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
	
	void setThumbnailDownloadStatus(EMDownloadStatus status) {
		((EMAImageMessageBody)emaObject).setThumbnailDownloadStatus(EMADownloadStatus.valueOf(status.name()));
    }
}
