package com.hyphenate.chat;

/**
 * Created by lijian on 2020/04/22.
 */

/**
 *  \~chinese
 *  CDN 画布设置，创建会议时使用
 *  注意：width或height设置为0时候，为纯音频推流 ，width和height必须都大于0才是音视频推流
 *
 *
 *  width (画布 宽)
 *  height(画布 高)
 * 	bgclr (画布 背景色 ,格式为 RGB 定义下的 Hex 值，不要带 # 号，
 * 	       如 0xFFB6C1 表示浅粉色。默认0x000000，黑色)
 *  fps (推流帧率，可设置范围10-30 )
 *  kpbs (推流码率，单位kbps，width和height较大时，码率需要提高，可设置范围1-5000)
 *  codec (推流编码格式，目前只支持"H264")
 *
 *  \~english
 *  The cdn canvas config
 *  Note: When width or height is set to 0, it is a pure audio stream. Width and
 *                  height must both be greater than 0 for an audio stream to be pushed
 *
 *
 *  width (Canvas width)
 *  height(Canvas height)
 *  bgclr (Canvas background color, Hex value defined by RGB, no #,
 *         such as 0xFFB6C1 means light pink.Default 0x000000, black))
 *  fps （The fps of cdn live，valid valuei is 10-30）
 *  kpbs (The birateBps of cdn live，the unit is kbps,valid value is 1-5000 )
 *  codec (The codec of cdn live，now only support H264)
 */
public class EMCDNCanvas {
    private  int  width = -1;
    private  int  height = -1;
    private  int  bgclr = 0;
    private  int  fps = -1;
    private  int  kpbs = -1;
    private  String  codec = null;

    public EMCDNCanvas(){

    }
    public EMCDNCanvas(int width, int height, int bgclr,int fps,int kpbs,String codec){
        this.width = width;
        this.height = height;
        this.bgclr = bgclr;
        this.fps = fps;
        this.kpbs = kpbs;
        this.codec  = codec;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() { return width; }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() { return height; }

    public int getBgclr() { return bgclr; }

    public void setBgclr(int bgclr) { this.bgclr = bgclr; }

    public void setFps(int fps) { this.fps = fps; }

    public int getFps() {
        return fps;
    }

    public void setVideoKbps(int kbps) { this.kpbs = kbps; }

    public int getVideoKbps() { return kpbs; }

    public void setCodec(String codec) {this.codec = codec;}

    public String getCodec() { return codec; }
}
