package com.hyphenate.chat;


/**
 * \~chinese
 * 音频录制的配置信息中音频采样率
 *   采样率可选项为(8000, 16000, 32000, 44100, 48000);
 *
 *
 * \~english
 * the audio sampling rate in the audio recording configuration information
 *   The samples of audio.value in one of(8000, 16000, 32000, 44100, 48000);
 */
public enum  EMAudioSamplesType {
    SAMPLES_8K("SAMPLES_8K",8000),
    SAMPLES_16K("SAMPLES_16K",16000),
    SAMPLES_32K("SAMPLES_32K",32000),
    SAMPLES_44K("SAMPLES_44K",44100),
    SAMPLES_48K("SAMPLES_48K",48000);

    private String value;
    private int desc;

    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
    public int getDesc() {
        return desc;
    }
    public void setDesc(int desc) {
        this.desc = desc;
    }
    private EMAudioSamplesType(String value, int desc) {
        this.value = value;
        this.desc = desc;
    }
}
