/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.content.Context;
import android.util.Log;
import com.superrtc.CapturerObserver;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.VideoCapturer;
import com.superrtc.VideoFrame;

public class ExternalVideoCapturer
implements VideoCapturer {
    private static final String TAG = "ExternalVideoDataCaptur";
    private CapturerObserver capturerObserver;
    private boolean isStart;

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(int n, int n2, int n3) {
        Log.i((String)TAG, (String)("startCapture: " + n + "x" + n2 + "@" + n3));
        this.capturerObserver.onCapturerStarted(true);
        this.isStart = true;
    }

    @Override
    public void stopCapture() throws InterruptedException {
        this.capturerObserver.onCapturerStopped();
        this.isStart = false;
    }

    @Override
    public void changeCaptureFormat(int n, int n2, int n3) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void inputExternalVideoData(VideoFrame videoFrame) {
        if (this.isStart) {
            this.capturerObserver.onFrameCaptured(videoFrame);
        }
    }
}

