/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.reporter;

import android.util.Log;
import com.superrtc.reporter.RtcReporterManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtcReportLogManager {
    private static final String TAG = "rtclog";
    private static final int LOG_FILE_SIZE_LIMIT = 10;
    private static RtcReportLogManager sInstance = new RtcReportLogManager();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private String username;
    private String dirPath;
    private File logFile;
    private String suffixStr = ".log";
    private EventListener mListener;

    public static RtcReportLogManager getInstance() {
        return sInstance;
    }

    private RtcReportLogManager() {
    }

    public void setFileSuffix(String string) {
        this.suffixStr = string;
    }

    public void setUsernameAndDirectoryPath(String string, String string2) {
        this.username = string;
        this.dirPath = string2;
    }

    public void setEventListener(EventListener eventListener) {
        this.mListener = eventListener;
    }

    synchronized void startWriteLog(String string) {
        String string2 = this.dateFormat.format(new Date()) + "-" + this.username + "-" + string + this.suffixStr;
        this.createAndOpenFile(string2);
        RtcReporterManager.getInstance().executeOnThread(() -> {
            if (this.mListener != null) {
                this.mListener.startEvent(string2);
            }
        });
    }

    private synchronized void createAndOpenFile(String string) {
        if (this.dirPath != null) {
            this.logFile = new File(this.dirPath, string);
        }
    }

    synchronized void writeLog(long l, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        for (String string : stringArray) {
            stringBuilder.append(",").append(string);
        }
        stringBuilder.append("\r\n");
        this.realWriteLogToFile(stringBuilder.toString());
    }

    synchronized void stopWriteLog() {
        this.logFile = null;
        RtcReporterManager.getInstance().executeOnThread(() -> {
            if (this.mListener != null) {
                this.mListener.stopEvent();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realWriteLogToFile(String string) {
        if (this.logFile == null) {
            Log.w((String)TAG, (String)"log file is null");
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            long l;
            if (!this.logFile.exists()) {
                this.logFile.getParentFile().mkdirs();
                this.logFile.createNewFile();
            }
            if ((l = (fileOutputStream = new FileOutputStream(this.logFile, true)).getChannel().size()) >= 0xA00000L) {
                fileOutputStream.close();
                Log.w((String)TAG, (String)"The file size has reached 10M");
                return;
            }
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static interface EventListener {
        public void startEvent(String var1);

        public void stopEvent();
    }
}

