/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import com.superrtc.FBOobjects.FBOFrameRect;
import com.superrtc.FBOobjects.FrameBuffer;
import com.superrtc.FBOobjects.FrameRect;
import com.superrtc.FBOobjects.WaterSignature;
import com.superrtc.FBOprogram.FrameRectSProgram;
import com.superrtc.FBOprogram.WaterSignSProgram;
import com.superrtc.GlGenericDrawer;
import com.superrtc.GlShader;
import com.superrtc.GlTextureFrameBuffer;
import com.superrtc.GlUtil;
import com.superrtc.JavaI420Buffer;
import com.superrtc.JniCommon;
import com.superrtc.NV21Buffer;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.VideoFrameDrawer;
import com.superrtc.util.BitmapUtil;
import com.superrtc.watermark.Watermark;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private Watermark watermark = null;
    private final FrameRect mFrameRect = new FrameRect();
    private final WaterSignature mWaterSign = new WaterSignature();
    private final FBOFrameRect mFBOFrameRect = new FBOFrameRect();
    private FrameBuffer fbo = new FrameBuffer();
    private int mSignTexId;
    private boolean isFrontCamera;
    private Bitmap bitmap = null;
    private int frameWidth = 0;
    private int frameHeight = 0;

    public void setWatermark(Watermark watermark, boolean bl, int n, int n2) {
        if (this.watermark != watermark || this.isFrontCamera != bl) {
            this.watermark = watermark;
            this.isFrontCamera = bl;
            this.mFrameRect.setShaderProgram(new FrameRectSProgram());
            this.mFrameRect.setCameraInfo(bl);
            this.mWaterSign.setShaderProgram(new WaterSignSProgram());
            this.mWaterSign.setCameraInfo(bl);
            this.mFBOFrameRect.setShaderProgram(new WaterSignSProgram());
            this.mFBOFrameRect.setCameraInfo(bl);
            this.mSignTexId = GlUtil.loadTexture(watermark.markImg);
            this.fbo.reSize(n, n2);
        }
    }

    public YuvConverter() {
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        int n = textureBuffer.getWidth();
        int n2 = textureBuffer.getHeight();
        int n3 = (n + 7) / 8 * 8;
        int n4 = (n2 + 1) / 2;
        int n5 = n2 + n4;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n3 * n5);
        int n6 = n3 / 4;
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preScale(1.0f, -1.0f);
        matrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(n6, n5);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, matrix, n, n2, 0, 0, n6, n2);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, matrix, n, n2, 0, n2, n6 / 2, n4);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, matrix, n, n2, n6 / 2, n2, n6 / 2, n4);
        GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        boolean bl = false;
        int n7 = 0 + n3 * n2;
        int n8 = n7 + n3 / 2;
        byteBuffer.position(0);
        byteBuffer.limit(0 + n3 * n2);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n7);
        int n9 = n3 * (n4 - 1) + n3 / 2;
        byteBuffer.limit(n7 + n9);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n8);
        byteBuffer.limit(n8 + n9);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        return JavaI420Buffer.wrap(n, n2, byteBuffer2, n3, byteBuffer3, n3, byteBuffer4, n3, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    public NV21Buffer convert(int n, int n2, float[] fArray, int n3) {
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n * n2 * 4);
        if (this.frameWidth != n) {
            this.fbo.reSize(n, n2);
        }
        this.fbo.begin();
        GLES20.glClear((int)16640);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        this.mFrameRect.drawFrame(n3, fArray);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
        this.mWaterSign.drawFrame(this.mSignTexId, this.watermark, n, n2);
        this.fbo.end();
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        this.mFBOFrameRect.drawFrame(this.fbo.getTextureId());
        this.fbo.begin();
        GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
        this.fbo.end();
        if (this.frameWidth == 0 || this.frameHeight == 0 || this.frameWidth != n || this.frameHeight != n2) {
            this.frameWidth = n;
            this.frameHeight = n2;
            this.bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        this.bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        if (this.isFrontCamera) {
            this.bitmap = BitmapUtil.convert(this.bitmap, n, n2);
        }
        int n4 = n % 2 == 0 ? n : n - 1;
        int n5 = n2 % 2 == 0 ? n2 : n2 - 1;
        int[] nArray = new int[n4 * n5];
        this.bitmap.getPixels(nArray, 0, n4, 0, 0, n4, n5);
        JniCommon.nativeFreeByteBuffer(byteBuffer);
        byte[] byArray = new byte[n4 * n5 * 3 / 2];
        BitmapUtil.encodeYUV420SP(byArray, nArray, n4, n5);
        assert (byArray.length == n4 * n5 * 3 / 2);
        NV21Buffer nV21Buffer = new NV21Buffer(byArray, n4, n5, null);
        return nV21Buffer;
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.threadChecker.detachThread();
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader glShader) {
            this.xUnitLoc = glShader.getUniformLocation("xUnit");
            this.coeffsLoc = glShader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader glShader, float[] fArray, int n, int n2, int n3, int n4) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * fArray[0] / (float)n), (float)(this.stepSize * fArray[1] / (float)n));
        }
    }
}

