/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.graphics.ImageFormat;
import com.superrtc.Histogram;
import com.superrtc.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraEnumerationAndroid {
    private static final String TAG = "CameraEnumerationAndroid";
    static final ArrayList<Size> COMMON_RESOLUTIONS = new ArrayList<Size>(Arrays.asList(new Size(160, 120), new Size(240, 160), new Size(320, 240), new Size(400, 240), new Size(480, 320), new Size(640, 360), new Size(640, 480), new Size(768, 480), new Size(854, 480), new Size(800, 600), new Size(960, 540), new Size(960, 640), new Size(1024, 576), new Size(1024, 600), new Size(1280, 720), new Size(1280, 1024), new Size(1920, 1080), new Size(1920, 1440), new Size(2560, 1440), new Size(3840, 2160)));

    public static CaptureFormat.FramerateRange getClosestSupportedFramerateRange(List<CaptureFormat.FramerateRange> list, final int n) {
        return Collections.min(list, new ClosestComparator<CaptureFormat.FramerateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int n5, int n2, int n3, int n4) {
                return n5 < n2 ? n5 * n3 : n2 * n3 + (n5 - n2) * n4;
            }

            @Override
            int diff(CaptureFormat.FramerateRange framerateRange) {
                int n3 = this.progressivePenalty(framerateRange.min, 8000, 1, 4);
                int n2 = this.progressivePenalty(Math.abs(n * 1000 - framerateRange.max), 5000, 1, 3);
                return n3 + n2;
            }
        });
    }

    public static Size getClosestSupportedSize(List<Size> list, final int n, final int n2) {
        return Collections.min(list, new ClosestComparator<Size>(){

            @Override
            int diff(Size size) {
                return Math.abs(n - size.width) + Math.abs(n2 - size.height);
            }
        });
    }

    static void reportCameraResolution(Histogram histogram, Size size) {
        int n = COMMON_RESOLUTIONS.indexOf(size);
        histogram.addSample(n + 1);
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t, T t2) {
            return this.diff(t) - this.diff(t2);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final FramerateRange framerate;
        public final int imageFormat = 17;

        public CaptureFormat(int n, int n2, int n3, int n4) {
            this.width = n;
            this.height = n2;
            this.framerate = new FramerateRange(n3, n4);
        }

        public CaptureFormat(int n, int n2, FramerateRange framerateRange) {
            this.width = n;
            this.height = n2;
            this.framerate = framerateRange;
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, 17);
        }

        public static int frameSize(int n, int n2, int n3) {
            if (n3 != 17) {
                throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
            }
            return n * n2 * ImageFormat.getBitsPerPixel((int)n3) / 8;
        }

        public String toString() {
            return this.width + "x" + this.height + "@" + this.framerate;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CaptureFormat)) {
                return false;
            }
            CaptureFormat captureFormat = (CaptureFormat)object;
            return this.width == captureFormat.width && this.height == captureFormat.height && this.framerate.equals(captureFormat.framerate);
        }

        public int hashCode() {
            return 1 + (this.width * 65497 + this.height) * 251 + this.framerate.hashCode();
        }

        public static class FramerateRange {
            public int min;
            public int max;

            public FramerateRange(int n, int n2) {
                this.min = n;
                this.max = n2;
            }

            public String toString() {
                return "[" + (float)this.min / 1000.0f + ":" + (float)this.max / 1000.0f + "]";
            }

            public boolean equals(Object object) {
                if (!(object instanceof FramerateRange)) {
                    return false;
                }
                FramerateRange framerateRange = (FramerateRange)object;
                return this.min == framerateRange.min && this.max == framerateRange.max;
            }

            public int hashCode() {
                return 1 + 65537 * this.min + this.max;
            }
        }
    }
}

