/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.view.Surface;
import com.superrtc.EglBase;
import com.superrtc.EncodedImage;
import com.superrtc.JavaI420Buffer;
import com.superrtc.Logging;
import com.superrtc.MediaCodecUtils;
import com.superrtc.MediaCodecWrapper;
import com.superrtc.MediaCodecWrapperFactory;
import com.superrtc.NV12Buffer;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoCodecStatus;
import com.superrtc.VideoCodecType;
import com.superrtc.VideoDecoder;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;
import com.superrtc.YuvHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "AndroidVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    @Nullable
    private final EglBase.Context sharedContext;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface;
    private final Object renderedTextureMetadataLock = new Object();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec;

    AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string, VideoCodecType videoCodecType, int n, @Nullable EglBase.Context context) {
        if (!this.isSupportedColorFormat(n)) {
            throw new IllegalArgumentException("Unsupported color format: " + n);
        }
        Logging.d(TAG, "ctor name: " + string + " type: " + (Object)((Object)videoCodecType) + " color format: " + n + " context: " + context);
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = string;
        this.codecType = videoCodecType;
        this.colorFormat = n;
        this.sharedContext = context;
        this.frameInfos = new LinkedBlockingDeque<FrameInfo>();
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        this.callback = callback;
        if (this.sharedContext != null) {
            this.surfaceTextureHelper = this.createSurfaceTextureHelper();
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
        }
        return this.initDecodeInternal(settings.width, settings.height);
    }

    private VideoCodecStatus initDecodeInternal(int n, int n2) {
        this.decoderThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initDecodeInternal name: " + this.codecName + " type: " + (Object)((Object)this.codecType) + " width: " + n + " height: " + n2);
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.width = n;
        this.height = n2;
        this.stride = n;
        this.sliceHeight = n2;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException exception) {
            Logging.e(TAG, "Cannot create media decoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)n, (int)n2);
            if (this.sharedContext == null) {
                mediaFormat.setInteger("color-format", this.colorFormat);
            }
            this.codec.configure(mediaFormat, this.surface, null, 0);
            this.codec.start();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        Logging.d(TAG, "initDecodeInternal done");
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(EncodedImage encodedImage, VideoDecoder.DecodeInfo decodeInfo) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        int n3;
        this.decoderThreadChecker.checkIsOnValidThread();
        if (this.codec == null || this.callback == null) {
            Logging.d(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (encodedImage.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        int n4 = encodedImage.buffer.remaining();
        if (n4 == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            n3 = this.width;
            n2 = this.height;
        }
        if (encodedImage.encodedWidth * encodedImage.encodedHeight > 0 && (encodedImage.encodedWidth != n3 || encodedImage.encodedHeight != n2) && (object = this.reinitDecode(encodedImage.encodedWidth, encodedImage.encodedHeight)) != VideoCodecStatus.OK) {
            return object;
        }
        if (this.keyFrameRequired) {
            if (encodedImage.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!encodedImage.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        try {
            n = this.codec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (n < 0) {
            Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
            return VideoCodecStatus.ERROR;
        }
        try {
            byteBuffer = this.codec.getInputBuffers()[n];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (byteBuffer.capacity() < n4) {
            Logging.e(TAG, "decode() - HW buffer too small");
            return VideoCodecStatus.ERROR;
        }
        byteBuffer.put(encodedImage.buffer);
        this.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), encodedImage.rotation));
        try {
            this.codec.queueInputBuffer(n, 0, n4, TimeUnit.NANOSECONDS.toMicros(encodedImage.captureTimeNs), 0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            this.frameInfos.pollLast();
            return VideoCodecStatus.ERROR;
        }
        if (this.keyFrameRequired) {
            this.keyFrameRequired = false;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.d(TAG, "release");
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (this.surface != null) {
            this.releaseSurface();
            this.surface = null;
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        this.frameInfos.clear();
        return videoCodecStatus;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            Logging.d(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int n, int n2) {
        this.decoderThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        return this.initDecodeInternal(n, n2);
    }

    private Thread createOutputThread() {
        return new Thread("AndroidVideoDecoder.outputThread"){

            @Override
            public void run() {
                AndroidVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (AndroidVideoDecoder.this.running) {
                    AndroidVideoDecoder.this.deliverDecodedFrame();
                }
                AndroidVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.codec.dequeueOutputBuffer(bufferInfo, 100000L);
            if (n == -2) {
                this.reformat(this.codec.getOutputFormat());
                return;
            }
            if (n < 0) {
                Logging.v(TAG, "dequeueOutputBuffer returned " + n);
                return;
            }
            FrameInfo frameInfo = this.frameInfos.poll();
            Integer n2 = null;
            int n3 = 0;
            if (frameInfo != null) {
                n2 = (int)(SystemClock.elapsedRealtime() - frameInfo.decodeStartTimeMs);
                n3 = frameInfo.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(n, bufferInfo, n3, n2);
            } else {
                this.deliverByteFrame(n, bufferInfo, n3, n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverDecodedFrame failed", illegalStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int n, MediaCodec.BufferInfo bufferInfo, int n2, Integer n3) {
        int n4;
        int n5;
        Object object = this.dimensionLock;
        synchronized (object) {
            n5 = this.width;
            n4 = this.height;
        }
        object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata != null) {
                this.codec.releaseOutputBuffer(n, false);
                return;
            }
            this.surfaceTextureHelper.setTextureSize(n5, n4);
            this.surfaceTextureHelper.setFrameRotation(n2);
            this.renderedTextureMetadata = new DecodedTextureMetadata(bufferInfo.presentationTimeUs, n3);
            this.codec.releaseOutputBuffer(n, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame videoFrame) {
        int n;
        long l;
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            l = this.renderedTextureMetadata.presentationTimestampUs * 1000L;
            n = this.renderedTextureMetadata.decodeTimeMs;
            this.renderedTextureMetadata = null;
        }
        object = new VideoFrame(videoFrame.getBuffer(), videoFrame.getRotation(), l);
        this.callback.onDecodedFrame((VideoFrame)object, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int n, MediaCodec.BufferInfo bufferInfo, int n2, Integer n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        Object object = this.dimensionLock;
        synchronized (object) {
            n7 = this.width;
            n6 = this.height;
            n5 = this.stride;
            n4 = this.sliceHeight;
        }
        if (bufferInfo.size < n7 * n6 * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + bufferInfo.size);
            return;
        }
        if (bufferInfo.size < n5 * n6 * 3 / 2 && n4 == n6 && n5 > n7) {
            n5 = bufferInfo.size * 2 / (n6 * 3);
        }
        object = this.codec.getOutputBuffers()[n];
        ((ByteBuffer)object).position(bufferInfo.offset);
        ((ByteBuffer)object).limit(bufferInfo.offset + bufferInfo.size);
        object = ((ByteBuffer)object).slice();
        VideoFrame.Buffer buffer = this.colorFormat == 19 ? this.copyI420Buffer((ByteBuffer)object, n5, n4, n7, n6) : this.copyNV12ToI420Buffer((ByteBuffer)object, n5, n4, n7, n6);
        this.codec.releaseOutputBuffer(n, false);
        long l = bufferInfo.presentationTimeUs * 1000L;
        VideoFrame videoFrame = new VideoFrame(buffer, n2, l);
        this.callback.onDecodedFrame(videoFrame, n3, null);
        videoFrame.release();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        return new NV12Buffer(n3, n4, n, n2, byteBuffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        ByteBuffer byteBuffer2;
        if (n % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + n));
        }
        int n5 = (n3 + 1) / 2;
        int n6 = n2 % 2 == 0 ? (n4 + 1) / 2 : n4 / 2;
        int n7 = n / 2;
        boolean bl = false;
        int n8 = 0 + n * n4;
        int n9 = 0 + n * n2;
        int n10 = n9 + n7 * n6;
        int n11 = n9 + n7 * n2 / 2;
        int n12 = n11 + n7 * n6;
        VideoFrame.I420Buffer i420Buffer = this.allocateI420Buffer(n3, n4);
        byteBuffer.limit(n8);
        byteBuffer.position(0);
        this.copyPlane(byteBuffer.slice(), n, i420Buffer.getDataY(), i420Buffer.getStrideY(), n3, n4);
        byteBuffer.limit(n10);
        byteBuffer.position(n9);
        this.copyPlane(byteBuffer.slice(), n7, i420Buffer.getDataU(), i420Buffer.getStrideU(), n5, n6);
        if (n2 % 2 == 1) {
            byteBuffer.position(n9 + n7 * (n6 - 1));
            byteBuffer2 = i420Buffer.getDataU();
            byteBuffer2.position(i420Buffer.getStrideU() * n6);
            byteBuffer2.put(byteBuffer);
        }
        byteBuffer.limit(n12);
        byteBuffer.position(n11);
        this.copyPlane(byteBuffer.slice(), n7, i420Buffer.getDataV(), i420Buffer.getStrideV(), n5, n6);
        if (n2 % 2 == 1) {
            byteBuffer.position(n11 + n7 * (n6 - 1));
            byteBuffer2 = i420Buffer.getDataV();
            byteBuffer2.position(i420Buffer.getStrideV() * n6);
            byteBuffer2.put(byteBuffer);
        }
        return i420Buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat mediaFormat) {
        int n;
        int n2;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
        if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            n2 = 1 + mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            n = 1 + mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            n2 = mediaFormat.getInteger("width");
            n = mediaFormat.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != n2 || this.height != n)) {
                this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n2 + "*" + n));
                return;
            }
            this.width = n2;
            this.height = n;
        }
        if (this.surfaceTextureHelper == null && mediaFormat.containsKey("color-format")) {
            this.colorFormat = mediaFormat.getInteger("color-format");
            Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
            if (!this.isSupportedColorFormat(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        object = this.dimensionLock;
        synchronized (object) {
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = mediaFormat.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = mediaFormat.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception exception) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = exception;
    }

    private boolean isSupportedColorFormat(int n) {
        for (int n2 : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int n, int n2) {
        return JavaI420Buffer.allocate(n, n2);
    }

    protected void copyPlane(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3, int n4) {
        YuvHelper.copyPlane(byteBuffer, n, byteBuffer2, n2, n3, n4);
    }

    private static class DecodedTextureMetadata {
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        DecodedTextureMetadata(long l, Integer n) {
            this.presentationTimestampUs = l;
            this.decodeTimeMs = n;
        }
    }

    private static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        FrameInfo(long l, int n) {
            this.decodeStartTimeMs = l;
            this.rotation = n;
        }
    }
}

