/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.provider.DocumentFile;
import android.text.TextUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.FileUtils;
import com.hyphenate.util.VersionUtils;
import java.io.File;

public class UriUtils {
    private static final String TAG = UriUtils.class.getSimpleName();

    public static boolean isFileExistByUri(Context context, Uri uri) {
        if (uri == null) {
            return false;
        }
        if (!VersionUtils.isTargetQ(context)) {
            String string = UriUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return new File(string).exists();
            }
            return false;
        }
        if (UriUtils.uriStartWithFile(uri)) {
            String string = uri.getPath();
            boolean bl = new File(string).exists();
            long l = new File(string).length();
            EMLog.d(TAG, "file uri exist = " + bl + " file length = " + l);
            return bl;
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            return uri.toString().startsWith("/") && new File(uri.toString()).exists();
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        return documentFile != null && documentFile.exists();
    }

    public static boolean uriStartWithFile(Uri uri) {
        return TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file") && uri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri uri) {
        return TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"content");
    }

    public static String getFileNameByUri(Context context, Uri uri) {
        if (uri == null) {
            return "";
        }
        if (!VersionUtils.isTargetQ(context)) {
            String string = UriUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)string) && new File(string).exists()) {
                return new File(string).getName();
            }
            return "";
        }
        if (UriUtils.uriStartWithFile(uri)) {
            File file = new File(uri.getPath());
            return file.exists() ? file.getName() : "";
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            if (uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
                return new File(uri.toString()).getName();
            }
            return "";
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return "";
        }
        return documentFile.getName();
    }

    public static long getFileLength(Context context, Uri uri) {
        if (uri == null) {
            return 0L;
        }
        if (!VersionUtils.isTargetQ(context)) {
            String string = UriUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)string) && new File(string).exists()) {
                return new File(string).length();
            }
            return 0L;
        }
        if (UriUtils.uriStartWithFile(uri) && new File(uri.getPath()).exists()) {
            return new File(uri.getPath()).length();
        }
        if (!UriUtils.uriStartWithContent(uri) && uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
            return new File(uri.toString()).length();
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return 0L;
        }
        return documentFile.length();
    }

    public static String getFileMimeType(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (!VersionUtils.isTargetQ(context)) {
            String string = UriUtils.getFilePath(context, uri);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return FileUtils.getMIMEType(new File(string));
            }
            return null;
        }
        if (UriUtils.uriStartWithFile(uri)) {
            return FileUtils.getMIMEType(new File(uri.getPath()));
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            if (uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
                return FileUtils.getMIMEType(new File(uri.toString()));
            }
            return null;
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return null;
        }
        return documentFile.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVideoOrAudioDuration(Context context, Uri uri) {
        String[] stringArray = new String[]{"duration"};
        Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
        long l = 0L;
        if (cursor != null && cursor.moveToFirst()) {
            l = cursor.getLong(cursor.getColumnIndex("duration"));
            cursor.close();
            cursor = null;
        }
        if (l <= 0L) {
            MediaMetadataRetriever mediaMetadataRetriever = null;
            String string = "";
            try {
                mediaMetadataRetriever = new MediaMetadataRetriever();
                mediaMetadataRetriever.setDataSource(context, uri);
                string = mediaMetadataRetriever.extractMetadata(9);
                l = Integer.valueOf(string).intValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            finally {
                if (mediaMetadataRetriever != null) {
                    mediaMetadataRetriever.release();
                }
            }
        }
        if (l <= 0L) {
            l = 0L;
        }
        EMLog.d(TAG, "duration:" + l);
        return (int)l;
    }

    private static DocumentFile getDocumentFile(Context context, Uri uri) {
        if (uri == null) {
            EMLog.e(TAG, "uri is null");
            return null;
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        if (documentFile == null) {
            EMLog.e(TAG, "DocumentFile is null");
            return null;
        }
        return documentFile;
    }

    public static String getUriString(Uri uri) {
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public static Uri getLocalUriFromString(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.startsWith("content")) {
            return Uri.parse((String)string);
        }
        if (string.startsWith("file") && string.length() > 7) {
            return Uri.fromFile((File)new File(Uri.parse((String)string).getPath()));
        }
        if (string.startsWith("/")) {
            return Uri.fromFile((File)new File(string));
        }
        return null;
    }

    public static String getMimeType(Context context, Uri uri) {
        String string = UriUtils.getFilePath(context, uri);
        if (!TextUtils.isEmpty((CharSequence)string) && new File(string).exists()) {
            return UriUtils.getMimeType(new File(string));
        }
        return context.getContentResolver().getType(uri);
    }

    public static String getMimeType(File file) {
        String string = file.getName();
        return UriUtils.getMimeType(string);
    }

    public static String getMimeType(String string) {
        if (string.endsWith(".3gp") || string.endsWith(".amr")) {
            return "audio/3gp";
        }
        if (string.endsWith(".jpe") || string.endsWith(".jpeg") || string.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".amr")) {
            return "audio/amr";
        }
        if (string.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (string.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        return "application/octet-stream";
    }

    public static String getFilePath(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        Uri uri = Uri.parse((String)string);
        return UriUtils.getFilePath(context, uri);
    }

    public static String getFilePath(Context context, Uri uri) {
        boolean bl;
        if (uri == null) {
            return "";
        }
        boolean bl2 = bl = Build.VERSION.SDK_INT >= 19;
        if (!VersionUtils.isTargetQ(context)) {
            if (bl && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
                if (UriUtils.isExternalStorageDocument(uri)) {
                    String string = DocumentsContract.getDocumentId((Uri)uri);
                    String[] stringArray = string.split(":");
                    String string2 = stringArray[0];
                    if ("primary".equalsIgnoreCase(string2)) {
                        return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    }
                } else {
                    if (UriUtils.isDownloadsDocument(uri)) {
                        String string = DocumentsContract.getDocumentId((Uri)uri);
                        Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(string));
                        return UriUtils.getDataColumn(context, uri2, null, null);
                    }
                    if (UriUtils.isMediaDocument(uri)) {
                        String string = DocumentsContract.getDocumentId((Uri)uri);
                        String[] stringArray = string.split(":");
                        String string3 = stringArray[0];
                        Uri uri3 = null;
                        if ("image".equals(string3)) {
                            uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(string3)) {
                            uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(string3)) {
                            uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String string4 = "_id=?";
                        String[] stringArray2 = new String[]{stringArray[1]};
                        return UriUtils.getDataColumn(context, uri3, "_id=?", stringArray2);
                    }
                }
            } else {
                if (UriUtils.isFileProvider(context, uri)) {
                    return uri.getPath();
                }
                if ("content".equalsIgnoreCase(uri.getScheme())) {
                    return UriUtils.getDataColumn(context, uri, null, null);
                }
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    return uri.getPath();
                }
                if (uri.toString().startsWith("/")) {
                    return uri.toString();
                }
            }
        } else {
            if (UriUtils.uriStartWithFile(uri)) {
                return uri.getPath();
            }
            if (uri.toString().startsWith("/")) {
                return uri.toString();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String string, String[] stringArray) {
        Cursor cursor = null;
        String string2 = "_data";
        String[] stringArray2 = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, stringArray2, string, stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n = cursor.getColumnIndexOrThrow("_data");
                String string3 = cursor.getString(n);
                return string3;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isFileProvider(Context context, Uri uri) {
        return (context.getApplicationInfo().packageName + ".fileProvider").equals(uri.getAuthority());
    }
}

