/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalaudio;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.superrtc.externalaudio.IAudioSource;
import com.superrtc.mediamanager.EMediaManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class DecoderSource
implements IAudioSource {
    private static final String TAG = "DecoderSource";
    private static final int CACHED_BUFFER_SIZE = 6;
    private static final int MAX_DECODER_RETRY_COUNT = 100;
    private static IAudioSource.LogListener sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
    private Context mContext;
    private MediaCodec mMediaCodec = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 0;
    private int mChannels = 0;
    private long mFileLength;
    private int mRetryCount = 0;
    private String targetFilename;
    private int targetLoopTimes;
    private boolean targetSendMix;
    private Thread decodeThread;
    private HttpURLConnection httpURLConnection;
    private int _10msLength = 0;
    private final byte[][] bytesForRead = new byte[2][];
    private final ByteBuffer[] resultBuffer = new ByteBuffer[2];
    private final ByteBuffer[] currentBuffer = new ByteBuffer[2];
    private final ArrayDeque<ByteBuffer>[] decodedDataCachedQueue = new ArrayDeque[2];
    private final LinkedBlockingDeque<Integer> decodeNotifier = new LinkedBlockingDeque(6);
    private boolean needRewind = false;
    private boolean needRelease = false;

    public DecoderSource() {
        this.mContext = EMediaManager.getContext();
    }

    public static void registerLogListener(IAudioSource.LogListener logListener) {
        if (logListener != null) {
            sLogListener = logListener;
        }
    }

    @Override
    public boolean canDecode(String string) {
        return true;
    }

    @Override
    public void create(String string, int n, boolean bl) {
        sLogListener.onLog(6, "[DecoderSource] Try to create decoder source: " + string + ", loop times: " + n);
        this.targetFilename = string;
        this.targetLoopTimes = n;
        this.targetSendMix = bl;
        try {
            int n2;
            int n3;
            this.mRetryCount = 0;
            boolean bl2 = string.startsWith("/assets/");
            boolean bl3 = string.toLowerCase().startsWith("http");
            this.mExtractor = new MediaExtractor();
            if (bl2) {
                if (this.mContext == null) {
                    sLogListener.onLog(6, "[DecoderSource] mContext is null, return.");
                    return;
                }
                string = string.substring("/assets/".length());
                AssetFileDescriptor assetFileDescriptor = this.mContext.getAssets().openFd(string);
                this.mExtractor.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            } else if (bl3) {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    this.httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                    this.httpURLConnection.setConnectTimeout(3000);
                    this.httpURLConnection.setReadTimeout(3000);
                    this.httpURLConnection.connect();
                    if (this.httpURLConnection.getResponseCode() != 200) {
                        sLogListener.onLog(6, "[DecoderSource] Connect to URL : " + string + " return response " + this.httpURLConnection.getResponseCode());
                        return;
                    }
                    this.mExtractor.setDataSource(string);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    sLogListener.onLog(6, "[DecoderSource] Connect timeout on URL : " + string);
                    return;
                }
                catch (IOException iOException) {
                    sLogListener.onLog(6, "[DecoderSource] Connect IOException on URL : " + string);
                    return;
                }
            } else {
                this.mExtractor.setDataSource(string);
            }
            int n4 = this.mExtractor.getTrackCount();
            for (n3 = 0; n3 < n4; ++n3) {
                this.mExtractor.unselectTrack(n3);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(n3);
                String string2 = this.mTrackFormat.getString("mime");
                if (!string2.contains("audio/")) continue;
                this.mExtractor.selectTrack(n3);
                this.mMediaCodec = MediaCodec.createDecoderByType((String)string2);
                this.mMediaCodec.configure(this.mTrackFormat, null, null, 0);
                break;
            }
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
            this._10msLength = this.mSampleRate / 100 * 2 * this.mChannels;
            n3 = 1;
            if (this.targetSendMix) {
                n3 = 2;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.bytesForRead[n2] = new byte[this._10msLength];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.resultBuffer[n2] = ByteBuffer.allocateDirect(this._10msLength);
                this.resultBuffer[n2].order(ByteOrder.nativeOrder());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.decodedDataCachedQueue[n2] = new ArrayDeque(6);
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.decodeNotifier.offerLast(0);
            }
            sLogListener.onLog(6, "[DecoderSource] Decoder header: " + this.mTrackFormat.toString() + ", 10ms buffer size: " + this._10msLength);
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when creating audio file decoder, " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        this.startDecodeFrameInThread();
    }

    @Override
    public void release() {
        int n;
        if (this.decodeThread != null) {
            this.decodeThread.interrupt();
            this.decodeThread = null;
        }
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        if (this.mExtractor != null) {
            this.mExtractor.release();
            this.mExtractor = null;
        }
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
            this.httpURLConnection = null;
        }
        this.targetFilename = null;
        this.targetLoopTimes = 0;
        this.decodeNotifier.clear();
        for (n = 0; n < this.decodedDataCachedQueue.length; ++n) {
            if (this.decodedDataCachedQueue[n] == null) continue;
            this.decodedDataCachedQueue[n].clear();
            this.decodedDataCachedQueue[n] = null;
        }
        for (n = 0; n < this.currentBuffer.length; ++n) {
            if (this.currentBuffer[n] == null) continue;
            this.currentBuffer[n].clear();
            this.currentBuffer[n] = null;
        }
        for (n = 0; n < this.bytesForRead.length; ++n) {
            this.bytesForRead[n] = null;
        }
        for (n = 0; n < this.resultBuffer.length; ++n) {
            if (this.resultBuffer[n] == null) continue;
            this.resultBuffer[n].clear();
            this.resultBuffer[n] = null;
        }
        this.mChannels = 0;
        this.mSampleRate = 0;
        this.eoOutputStream = false;
        this.eoInputStream = false;
        sLogListener.onLog(6, "[DecoderSource] DecoderSource released.");
    }

    @Override
    public int getChannelCount() {
        return this.mChannels;
    }

    @Override
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public ByteBuffer getDataForPlayout() {
        return this.prepareResultBuffer(0);
    }

    @Override
    public ByteBuffer getDataForSend() {
        return this.prepareResultBuffer(1);
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    public void setCurrentFilePosition(long l) {
        this.mExtractor.seekTo(l, 2);
    }

    private void rewind() {
        try {
            this.mExtractor.seekTo(0L, 1);
            this.mMediaCodec.flush();
            this.eoInputStream = false;
            this.eoOutputStream = false;
            sLogListener.onLog(6, "[DecoderSource] Source restarted by rewind.");
        }
        catch (Exception exception) {
            String string = this.targetFilename;
            int n = this.targetLoopTimes;
            boolean bl = this.targetSendMix;
            this.release();
            this.create(string, n, bl);
            sLogListener.onLog(6, "[DecoderSource] Source restarted by recreate.");
        }
    }

    private ByteBuffer prepareResultBuffer(int n) {
        if (n + 1 > this.currentBuffer.length) {
            return null;
        }
        if (this.currentBuffer[n] != null && this.currentBuffer[n].remaining() > 0) {
            int n2 = Math.min(this._10msLength, this.currentBuffer[n].remaining());
            this.currentBuffer[n].get(this.bytesForRead[n], 0, n2);
            if (this.currentBuffer[n].remaining() == 0) {
                this.currentBuffer[n] = this.pollFirstFromCachedQueue(n);
                if (this.currentBuffer[n] != null && n2 < this._10msLength) {
                    int n3 = Math.min(this._10msLength - n2, this.currentBuffer[n].remaining());
                    this.currentBuffer[n].get(this.bytesForRead[n], n2, n3);
                }
            }
            this.resultBuffer[n].clear();
            this.resultBuffer[n].put(this.bytesForRead[n]);
            return this.resultBuffer[n];
        }
        this.currentBuffer[n] = this.pollFirstFromCachedQueue(n);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer pollFirstFromCachedQueue(int n) {
        ByteBuffer byteBuffer;
        if (this.decodedDataCachedQueue[n] == null) {
            return null;
        }
        boolean bl = true;
        ArrayDeque<ByteBuffer> arrayDeque = this.decodedDataCachedQueue[n];
        synchronized (arrayDeque) {
            byteBuffer = this.decodedDataCachedQueue[n].pollFirst();
        }
        for (int k = 0; k < this.decodedDataCachedQueue.length; ++k) {
            if (k == n || this.decodedDataCachedQueue[k] == null) continue;
            ArrayDeque<ByteBuffer> arrayDeque2 = this.decodedDataCachedQueue[k];
            synchronized (arrayDeque2) {
                int n2 = this.decodedDataCachedQueue[k].size();
                bl = n2 < 6;
            }
            if (!bl) break;
        }
        if (bl) {
            this.decodeNotifier.offerLast(0);
        }
        return byteBuffer;
    }

    private void startDecodeFrameInThread() {
        sLogListener.onLog(6, "[DecoderSource] Start audio frame decode thread.");
        if (this.decodeThread != null) {
            sLogListener.onLog(6, "[DecoderSource] Audio frame decode thread already started, return.");
            return;
        }
        this.decodeThread = new Thread(() -> {
            while (true) {
                try {
                    this.decodeNotifier.takeFirst();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                try {
                    this.decodeFrame();
                }
                catch (Exception exception) {
                    sLogListener.onLog(6, "[DecoderSource] Error when decoding audio file stream: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }, "AudioDecodeThread");
        this.decodeThread.start();
    }

    private void decodeFrame() {
        if (!this.eoInputStream) {
            int n = this.mMediaCodec.dequeueInputBuffer(1000L);
            while (n < 0) {
                ++this.mRetryCount;
                if (this.mRetryCount >= 100) {
                    sLogListener.onLog(6, "[DecoderSource] dequeueInputBuffer failed after 100 times retry.");
                    this.eoOutputStream = true;
                    break;
                }
                n = this.mMediaCodec.dequeueInputBuffer(1000L);
            }
            if (n >= 0) {
                ByteBuffer byteBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getInputBuffer(n);
                } else {
                    ByteBuffer[] byteBufferArray = this.mMediaCodec.getInputBuffers();
                    byteBuffer = byteBufferArray[n];
                }
                int n2 = this.mExtractor.readSampleData(byteBuffer, 0);
                if (n2 <= 0) {
                    n2 = 0;
                    sLogListener.onLog(6, "[DecoderSource] Touch the end of the input stream, current loop times: " + this.targetLoopTimes);
                    if (this.targetLoopTimes-- != 0) {
                        this.needRewind = true;
                    } else {
                        this.eoInputStream = true;
                    }
                }
                long l = this.mExtractor.getSampleTime();
                int n3 = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    n3 |= 4;
                }
                this.mMediaCodec.queueInputBuffer(n, 0, n2, l, n3);
                this.mExtractor.advance();
            }
        }
        this.mRetryCount = 0;
        if (!this.eoOutputStream) {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 1000L);
            while (n < 0) {
                ++this.mRetryCount;
                if (this.mRetryCount >= 100) {
                    sLogListener.onLog(6, "[DecoderSource] dequeueOutputBuffer failed after 100 times retry.");
                    this.decodeNotifier.offerLast(0);
                    break;
                }
                n = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 1000L);
            }
            if (n >= 0) {
                this.mRetryCount = 0;
                if ((bufferInfo.flags & 4) == 4) {
                    sLogListener.onLog(6, "[DecoderSource] Touch the end of the output stream");
                    boolean bl = this.needRelease = !this.needRewind;
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    ByteBuffer byteBuffer = this.mMediaCodec.getOutputBuffer(n);
                    this.cloneByteBuffer(byteBuffer);
                } else {
                    ByteBuffer[] byteBufferArray = this.mMediaCodec.getOutputBuffers();
                    ByteBuffer byteBuffer = byteBufferArray[n];
                    this.cloneByteBufferByLength(byteBuffer, bufferInfo.size);
                }
                this.mMediaCodec.releaseOutputBuffer(n, false);
            }
        }
        if (this.needRelease) {
            sLogListener.onLog(6, "[DecoderSource] decodeFrame, need to release DecoderSource");
            this.needRelease = false;
            this.release();
        }
        if (this.needRewind) {
            sLogListener.onLog(6, "[DecoderSource] decodeFrame, need to rewind DecoderSource");
            this.needRewind = false;
            this.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneByteBuffer(ByteBuffer byteBuffer) {
        try {
            for (int k = 0; k < this.decodedDataCachedQueue.length; ++k) {
                if (this.decodedDataCachedQueue[k] == null) continue;
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.limit());
                byteBuffer.position(0);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.position(0);
                ArrayDeque<ByteBuffer> arrayDeque = this.decodedDataCachedQueue[k];
                synchronized (arrayDeque) {
                    this.decodedDataCachedQueue[k].offerLast(byteBuffer2);
                    continue;
                }
            }
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when clone byte buffer: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneByteBufferByLength(ByteBuffer byteBuffer, int n) {
        try {
            for (int k = 0; k < this.decodedDataCachedQueue.length; ++k) {
                if (this.decodedDataCachedQueue[k] == null) continue;
                byteBuffer.limit(n);
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
                byteBuffer.position(0);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.position(0);
                ArrayDeque<ByteBuffer> arrayDeque = this.decodedDataCachedQueue[k];
                synchronized (arrayDeque) {
                    this.decodedDataCachedQueue[k].offerLast(byteBuffer2);
                    continue;
                }
            }
        }
        catch (Exception exception) {
            sLogListener.onLog(6, "[DecoderSource] Error when clone byte buffer: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

