/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.database.Cursor;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.support.v4.provider.DocumentFile;
import android.text.TextUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.FileUtils;
import java.io.File;

public class UriUtils {
    private static final String TAG = UriUtils.class.getSimpleName();

    public static boolean isFileExistByUri(Context context, Uri uri) {
        if (uri == null) {
            return false;
        }
        if (UriUtils.uriStartWithFile(uri)) {
            String string = uri.getPath();
            boolean bl = new File(string).exists();
            long l = new File(string).length();
            EMLog.d(TAG, "file uri exist = " + bl + " file length = " + l);
            return bl;
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            return uri.toString().startsWith("/") && new File(uri.toString()).exists();
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        return documentFile != null && documentFile.exists();
    }

    public static boolean uriStartWithFile(Uri uri) {
        return TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file") && uri.toString().length() > 7;
    }

    public static boolean uriStartWithContent(Uri uri) {
        return TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"content");
    }

    public static String getFileNameByUri(Context context, Uri uri) {
        if (uri == null) {
            return "";
        }
        if (UriUtils.uriStartWithFile(uri)) {
            File file = new File(uri.getPath());
            return file.exists() ? file.getName() : "";
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            if (uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
                return new File(uri.toString()).getName();
            }
            return "";
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return "";
        }
        return documentFile.getName();
    }

    public static long getFileLength(Context context, Uri uri) {
        if (uri == null) {
            return 0L;
        }
        if (UriUtils.uriStartWithFile(uri) && new File(uri.getPath()).exists()) {
            return new File(uri.getPath()).length();
        }
        if (!UriUtils.uriStartWithContent(uri) && uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
            return new File(uri.toString()).length();
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return 0L;
        }
        return documentFile.length();
    }

    public static String getFileMimeType(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (UriUtils.uriStartWithFile(uri)) {
            return FileUtils.getMIMEType(new File(uri.getPath()));
        }
        if (!UriUtils.uriStartWithContent(uri)) {
            if (uri.toString().startsWith("/") && new File(uri.toString()).exists()) {
                return FileUtils.getMIMEType(new File(uri.toString()));
            }
            return null;
        }
        DocumentFile documentFile = UriUtils.getDocumentFile(context, uri);
        if (documentFile == null) {
            return null;
        }
        return documentFile.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVideoOrAudioDuration(Context context, Uri uri) {
        String[] stringArray = new String[]{"duration"};
        Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
        long l = 0L;
        if (cursor != null && cursor.moveToFirst()) {
            l = cursor.getLong(cursor.getColumnIndex("duration"));
            cursor.close();
            cursor = null;
        }
        if (l <= 0L) {
            MediaMetadataRetriever mediaMetadataRetriever = null;
            String string = "";
            try {
                mediaMetadataRetriever = new MediaMetadataRetriever();
                mediaMetadataRetriever.setDataSource(context, uri);
                string = mediaMetadataRetriever.extractMetadata(9);
                l = Integer.valueOf(string).intValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            finally {
                if (mediaMetadataRetriever != null) {
                    mediaMetadataRetriever.release();
                }
            }
        }
        if (l <= 0L) {
            l = 0L;
        }
        EMLog.d(TAG, "duration:" + l);
        return (int)l;
    }

    private static DocumentFile getDocumentFile(Context context, Uri uri) {
        if (uri == null) {
            EMLog.e(TAG, "uri is null");
            return null;
        }
        DocumentFile documentFile = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        if (documentFile == null) {
            EMLog.e(TAG, "DocumentFile is null");
            return null;
        }
        return documentFile;
    }

    public static String getUriString(Uri uri) {
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public static Uri getLocalUriFromString(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.startsWith("content")) {
            return Uri.parse((String)string);
        }
        if (string.startsWith("file") && string.length() > 7) {
            return Uri.fromFile((File)new File(Uri.parse((String)string).getPath()));
        }
        if (string.startsWith("/")) {
            return Uri.fromFile((File)new File(string));
        }
        return null;
    }

    public static String getMimeType(Context context, Uri uri) {
        String string = UriUtils.getFilePath(uri);
        if (!TextUtils.isEmpty((CharSequence)string) && new File(string).exists()) {
            return UriUtils.getMimeType(new File(string));
        }
        return context.getContentResolver().getType(uri);
    }

    public static String getMimeType(File file) {
        String string = file.getName();
        return UriUtils.getMimeType(string);
    }

    public static String getMimeType(String string) {
        if (string.endsWith(".3gp") || string.endsWith(".amr")) {
            return "audio/3gp";
        }
        if (string.endsWith(".jpe") || string.endsWith(".jpeg") || string.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".amr")) {
            return "audio/amr";
        }
        if (string.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (string.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        return "application/octet-stream";
    }

    public static String getFilePath(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        if (string.startsWith("file") && string.length() > 7) {
            return Uri.parse((String)string).getPath();
        }
        if (string.startsWith("/")) {
            return string;
        }
        return "";
    }

    public static String getFilePath(Uri uri) {
        if (uri == null) {
            return "";
        }
        if (UriUtils.uriStartWithFile(uri)) {
            return uri.getPath();
        }
        if (uri.toString().startsWith("/")) {
            return uri.toString();
        }
        return "";
    }
}

