/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.HttpCallback;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.UriUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

class HttpClientController {
    private static final String a = HttpClientController.class.getSimpleName();
    private final Context b;
    private URL c;
    private HttpURLConnection d;
    private boolean e;
    private static final String[] f = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    private static int g = 60000;
    private static int h = 60000;
    private static final String i = UUID.randomUUID().toString();
    private static final String j = "--";
    private static final String k = "\r\n";
    private static final String l = "Android";

    public HttpClientController(Context context) {
        this.b = context;
    }

    public void a(String string) throws IOException {
        this.a(string, 443);
    }

    public void a(String string, int n) throws IOException {
        String[] stringArray;
        Object object;
        string = HttpClientConfig.getFileRemoteUrl(string);
        string = HttpClientConfig.processUrl(string);
        boolean bl = false;
        if (string != null && string.toLowerCase().startsWith("https://")) {
            this.e = true;
            object = string.substring("https://".length());
            stringArray = ((String)object).split("\\.");
            if (stringArray.length > 3) {
                try {
                    int n2 = Integer.parseInt(stringArray[0]);
                    if (0 > n2 || n2 > 255) {
                        throw new NumberFormatException();
                    }
                    n2 = Integer.parseInt(stringArray[1]);
                    if (0 > n2 || n2 > 255) {
                        throw new NumberFormatException();
                    }
                    n2 = Integer.parseInt(stringArray[2]);
                    if (0 > n2 || n2 > 255) {
                        throw new NumberFormatException();
                    }
                    if (stringArray[3].indexOf(58) != -1) {
                        String string2 = stringArray[3].substring(0, stringArray[3].indexOf(58));
                        n2 = Integer.parseInt(string2);
                        if (0 > n2 || n2 > 255) {
                            throw new NumberFormatException();
                        }
                        String string3 = stringArray[3].substring(stringArray[3].indexOf(58) + 1);
                        String string4 = string3.indexOf(47) != -1 ? string3.substring(0, string3.indexOf(47)) : string3;
                        try {
                            n = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        if (TextUtils.equals((CharSequence)(stringArray = ((URL)(object = new URL(string))).getProtocol()), (CharSequence)"http")) {
            n = 80;
        }
        this.c = new URL((String)stringArray, ((URL)object).getHost(), n, ((URL)object).getFile());
        this.d = (HttpURLConnection)this.c.openConnection();
        if (this.d instanceof HttpsURLConnection) {
            SSLCustomSocketFactory sSLCustomSocketFactory = new SSLCustomSocketFactory(bl ? SSLCustomSocketFactory.getSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault());
            ((HttpsURLConnection)this.d).setSSLSocketFactory(sSLCustomSocketFactory);
            if (bl) {
                ((HttpsURLConnection)this.d).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        EMLog.d(a, "Waning: URL Host:" + string + " vs. " + sSLSession.getPeerHost());
                        return true;
                    }
                });
            }
        }
    }

    public void b(String string) throws ProtocolException {
        this.d.setRequestMethod(string);
    }

    public void a(int n) {
        if (n <= 0) {
            n = g;
        }
        this.d.setConnectTimeout(n);
    }

    public void b(int n) {
        if (n <= 0) {
            n = h;
        }
        this.d.setReadTimeout(n);
    }

    public void a(boolean bl) {
        this.d.setInstanceFollowRedirects(bl);
    }

    public void a() {
        this.d.setRequestProperty("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
    }

    public void b() {
        this.d.setRequestProperty("User-agent", HttpClientConfig.getDefaultUserAgent());
        this.d.setRequestProperty("Connection", "Keep-Alive");
    }

    public void c() {
        this.d.setRequestProperty("Charset", "UTF-8");
        this.d.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + i);
    }

    public void d() {
        this.d.setChunkedStreamingMode(0);
    }

    public void e() {
        this.d.setDoInput(true);
    }

    public void f() {
        this.d.setDoOutput(true);
        this.d.setDoInput(true);
        this.d.setUseCaches(false);
    }

    public HttpURLConnection g() {
        return this.d;
    }

    public void a(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.d.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void a(Map<String, String> map, OutputStream outputStream) throws IOException {
        if (map == null || map.size() <= 0) {
            return;
        }
        String string = this.b(map);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    public void a(String string, OutputStream outputStream) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    public void a(Uri uri, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
        this.a("file", uri, null, outputStream, httpCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(String string, Uri uri, String string2, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "file";
        }
        if (!UriUtils.isFileExistByUri(this.b, uri)) {
            throw new FileNotFoundException("file not exist");
        }
        String string3 = UriUtils.getFileNameByUri(this.b, uri);
        String string4 = UriUtils.getMimeType(this.b, uri);
        long l = UriUtils.getFileLength(this.b, uri);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string2;
        }
        outputStream.write(this.a(string, string3, string4, l).getBytes());
        String string5 = UriUtils.getFilePath(uri);
        try (InputStream inputStream = null;){
            int n;
            inputStream = !TextUtils.isEmpty((CharSequence)string5) && new File(string5).exists() ? new FileInputStream(new File(string5)) : this.b.getContentResolver().openInputStream(uri);
            byte[] byArray = new byte[2048];
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                l2 += (long)n;
                if (httpCallback == null) continue;
                httpCallback.onProgress(l, l2);
            }
        }
        outputStream.write(this.m().getBytes());
        outputStream.flush();
    }

    public HttpURLConnection h() throws IOException {
        this.b(false);
        this.d.connect();
        return this.d;
    }

    private void b(boolean bl) throws IllegalStateException {
        if (!bl || this.d != null) {
            // empty if block
        }
    }

    public HttpResponse i() throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.code = this.d.getResponseCode();
        if (httpResponse.code == 200) {
            httpResponse.contentLength = this.d.getContentLength();
            httpResponse.inputStream = this.d.getInputStream();
            httpResponse.content = this.a(httpResponse.inputStream);
        } else {
            httpResponse.errorStream = this.d.getErrorStream();
            httpResponse.content = this.a(httpResponse.errorStream);
        }
        this.a(false, httpResponse);
        return httpResponse;
    }

    public HttpResponse j() throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.code = this.d.getResponseCode();
        httpResponse.contentLength = this.d.getContentLength();
        httpResponse.inputStream = this.d.getInputStream();
        httpResponse.errorStream = this.d.getErrorStream();
        if (httpResponse.code != 200) {
            httpResponse.content = this.a(httpResponse.errorStream);
        }
        this.a(false, httpResponse);
        return httpResponse;
    }

    private void a(boolean bl, HttpResponse httpResponse) {
        if (this.d == null || httpResponse == null) {
            return;
        }
        if (!bl) {
            EMLog.d(a, "response code: " + httpResponse.code);
            if (httpResponse.code != 200) {
                EMLog.d(a, "error message: " + httpResponse.content);
            }
        }
    }

    public HttpResponse a(Exception exception) throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        if (this.d != null) {
            httpResponse.code = this.d.getResponseCode();
            httpResponse.contentLength = this.d.getContentLength();
            httpResponse.errorStream = this.d.getErrorStream();
            this.d.disconnect();
        }
        httpResponse.exception = exception;
        return httpResponse;
    }

    private String l() {
        return this.d.getHeaderField("Location");
    }

    private String a(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String b(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            stringBuffer.append(j);
            stringBuffer.append(i);
            stringBuffer.append(k);
            stringBuffer.append("Content-Disposition: form-data; name=\"" + string + "\"");
            stringBuffer.append(k);
            stringBuffer.append("Content-Type: text/plain");
            stringBuffer.append(k);
            stringBuffer.append("Content-Length: " + map.get(string).length());
            stringBuffer.append(k);
            stringBuffer.append(k);
            stringBuffer.append(map.get(string));
            stringBuffer.append(k);
        }
        return stringBuffer.toString();
    }

    private String a(String string, String string2, String string3, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(k);
        stringBuffer.append(j);
        stringBuffer.append(i);
        stringBuffer.append(k);
        stringBuffer.append("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string2 + "\"");
        stringBuffer.append(k);
        stringBuffer.append("Content-Type: " + string3);
        stringBuffer.append(k);
        stringBuffer.append("Content-Length: " + l);
        stringBuffer.append(k);
        stringBuffer.append(k);
        return stringBuffer.toString();
    }

    private String m() {
        return "\r\n--" + i + j + k;
    }

    private void c(String string) {
        HttpClientConfig.checkAndProcessSSL(string, this.d);
    }

    public static class HttpParams {
        public final Context mContext;
        public String mRequestMethod;
        public int mPort = 443;
        public int mConnectTimeout;
        public int mReadTimeout;
        public boolean followRedirect = true;
        public boolean canRetry;
        public int mRetryTimes;
        public Map<String, String> mHeaders = new HashMap<String, String>();
        public Map<String, String> mParams = new HashMap<String, String>();
        public String mParamsString;
        public String mUrl;
        public String mLocalFileUri;
        public String mDownloadPath;
        public String mFilename;
        public String mFileKey;
        public boolean isUploadFile;
        public boolean isDownloadFile;
        public boolean isCheckSSL;
        public boolean isNotUseToken;
        public boolean isTokenExceeded;
        public boolean isDefaultRetry;

        public HttpParams(Context context) {
            this.mContext = context;
        }

        public void apply(HttpClientController httpClientController) throws IOException {
            if (this.mPort != 443) {
                httpClientController.a(this.mUrl, this.mPort);
            } else {
                httpClientController.a(this.mUrl);
            }
            httpClientController.b(this.mRequestMethod);
            if (TextUtils.equals((CharSequence)this.mRequestMethod, (CharSequence)"GET")) {
                httpClientController.e();
            } else {
                httpClientController.f();
            }
            httpClientController.a(this.mConnectTimeout);
            httpClientController.b(this.mReadTimeout);
            httpClientController.b();
            if (!this.isNotUseToken) {
                httpClientController.a();
            }
            httpClientController.a(this.followRedirect);
            if (this.isUploadFile) {
                httpClientController.c();
                httpClientController.d();
            }
            if (this.isDownloadFile) {
                if (TextUtils.isEmpty((CharSequence)this.mDownloadPath)) {
                    throw new FileNotFoundException("file download path is empty");
                }
                this.checkDownloadProperty();
            }
            httpClientController.c(this.mUrl);
            this.checkToken();
            httpClientController.a(this.mHeaders);
        }

        public void addFile(HttpClientController httpClientController, OutputStream outputStream, HttpCallback httpCallback) throws IOException {
            if (this.isUploadFile) {
                httpClientController.a(this.mFileKey, UriUtils.getLocalUriFromString(this.mLocalFileUri), this.mFilename, outputStream, httpCallback);
            }
        }

        public HttpResponse getResponse(HttpClientController httpClientController) throws IOException {
            return this.isDownloadFile ? httpClientController.j() : httpClientController.i();
        }

        public String getRedirectionUrl(HttpClientController httpClientController) {
            return httpClientController.l();
        }

        public HttpResponse getExceptionResponse(HttpClientController httpClientController, IOException iOException) throws IOException {
            if (httpClientController != null) {
                return httpClientController.a(iOException);
            }
            return null;
        }

        public void checkDownloadProperty() {
            if (this.isDownloadFile) {
                this.mHeaders.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
                this.mHeaders.put("Accept", "application/octet-stream");
            }
        }

        public void checkToken() {
            if (this.mHeaders.keySet().contains("Authorization") && TextUtils.isEmpty((CharSequence)this.mHeaders.get("Authorization"))) {
                this.mHeaders.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
            }
        }
    }

    public static class SSLCustomSocketFactory
    extends SSLSocketFactory {
        private static final String TAG = "SSLCustomSocketFactory";
        private static final String[] TLS_SUPPORT_VERSION = new String[]{"TLSv1.1", "TLSv1.2"};
        private static final String KEY_PASS = "";
        final SSLSocketFactory delegate;
        static SSLContext sslContext;
        static SSLSocketFactory mSocketFactory;

        public SSLCustomSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.delegate = sSLSocketFactory;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            return this.patch(this.delegate.createSocket(socket, string, n, bl));
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            return this.patch(this.delegate.createSocket(string, n));
        }

        @Override
        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
            return this.patch(this.delegate.createSocket(string, n, inetAddress, n2));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.patch(this.delegate.createSocket(inetAddress, n));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.patch(this.delegate.createSocket(inetAddress, n, inetAddress2, n2));
        }

        private Socket patch(Socket socket) {
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).setEnabledProtocols(TLS_SUPPORT_VERSION);
            }
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized SSLSocketFactory getSocketFactory() {
            if (mSocketFactory == null) {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    AssetManager assetManager = EMClient.getInstance().getContext().getAssets();
                    String[] stringArray = assetManager.list("hyphenate_certs");
                    String string = KeyStore.getDefaultType();
                    KeyStore keyStore = KeyStore.getInstance(string);
                    keyStore.load(null, null);
                    for (int k = 0; k < stringArray.length; ++k) {
                        String string2 = stringArray[k];
                        try (InputStream inputStream = null;){
                            inputStream = assetManager.open("hyphenate_certs/" + string2);
                            Certificate certificate = certificateFactory.generateCertificate(inputStream);
                            System.out.println("ca=" + ((X509Certificate)certificate).getSubjectDN());
                            keyStore.setCertificateEntry("ca" + k, certificate);
                            continue;
                        }
                    }
                    EMLog.d(TAG, "keystore type:" + keyStore.getType());
                    sslContext = SSLContext.getInstance("TLS");
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                    mSocketFactory = sslContext.getSocketFactory();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    EMLog.e(TAG, throwable.getMessage());
                }
            }
            return mSocketFactory;
        }
    }
}

