/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.MediaStreamTrack;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RtpParameters {
    public final String transactionId;
    private final Rtcp rtcp;
    private final List<HeaderExtension> headerExtensions;
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    @CalledByNative
    RtpParameters(String string, Rtcp rtcp, List<HeaderExtension> list, List<Encoding> list2, List<Codec> list3) {
        this.transactionId = string;
        this.rtcp = rtcp;
        this.headerExtensions = list;
        this.encodings = list2;
        this.codecs = list3;
    }

    @CalledByNative
    String getTransactionId() {
        return this.transactionId;
    }

    @CalledByNative
    public Rtcp getRtcp() {
        return this.rtcp;
    }

    @CalledByNative
    public List<HeaderExtension> getHeaderExtensions() {
        return this.headerExtensions;
    }

    @CalledByNative
    List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class HeaderExtension {
        private final String uri;
        private final int id;
        private final boolean encrypted;

        @CalledByNative(value="HeaderExtension")
        HeaderExtension(String string, int n, boolean bl) {
            this.uri = string;
            this.id = n;
            this.encrypted = bl;
        }

        @CalledByNative(value="HeaderExtension")
        public String getUri() {
            return this.uri;
        }

        @CalledByNative(value="HeaderExtension")
        public int getId() {
            return this.id;
        }

        @CalledByNative(value="HeaderExtension")
        public boolean getEncrypted() {
            return this.encrypted;
        }
    }

    public static class Rtcp {
        private final String cname;
        private final boolean reducedSize;

        @CalledByNative(value="Rtcp")
        Rtcp(String string, boolean bl) {
            this.cname = string;
            this.reducedSize = bl;
        }

        @CalledByNative(value="Rtcp")
        public String getCname() {
            return this.cname;
        }

        @CalledByNative(value="Rtcp")
        public boolean getReducedSize() {
            return this.reducedSize;
        }
    }

    public static class Codec {
        public int payloadType;
        public String name;
        MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;
        public Map<String, String> parameters;

        @CalledByNative(value="Codec")
        Codec(int n, String string, MediaStreamTrack.MediaType mediaType, Integer n2, Integer n3, Map<String, String> map) {
            this.payloadType = n;
            this.name = string;
            this.kind = mediaType;
            this.clockRate = n2;
            this.numChannels = n3;
            this.parameters = map;
        }

        @CalledByNative(value="Codec")
        int getPayloadType() {
            return this.payloadType;
        }

        @CalledByNative(value="Codec")
        String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        Integer getNumChannels() {
            return this.numChannels;
        }

        @CalledByNative(value="Codec")
        Map getParameters() {
            return this.parameters;
        }
    }

    public static class Encoding {
        public boolean active = true;
        @Nullable
        public Integer maxBitrateBps;
        @Nullable
        public Integer minBitrateBps;
        @Nullable
        public Integer maxFramerate;
        @Nullable
        public Integer numTemporalLayers;
        public Long ssrc;

        @CalledByNative(value="Encoding")
        Encoding(boolean bl, Integer n, Integer n2, Integer n3, Integer n4, Long l) {
            this.active = bl;
            this.maxBitrateBps = n;
            this.minBitrateBps = n2;
            this.maxFramerate = n3;
            this.numTemporalLayers = n4;
            this.ssrc = l;
        }

        @CalledByNative(value="Encoding")
        boolean getActive() {
            return this.active;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMaxFramerate() {
            return this.maxFramerate;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getNumTemporalLayers() {
            return this.numTemporalLayers;
        }

        @CalledByNative(value="Encoding")
        Long getSsrc() {
            return this.ssrc;
        }
    }
}

