/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.support.annotation.NonNull;
import com.hyphenate.util.EMLog;
import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.MultipartEntity;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class CustomMultiPartEntity
extends MultipartEntity {
    private ProgressListener listener;

    public CustomMultiPartEntity(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public CustomMultiPartEntity(HttpMultipartMode httpMultipartMode, ProgressListener progressListener) {
        super(httpMultipartMode);
        this.listener = progressListener;
    }

    public CustomMultiPartEntity(HttpMultipartMode httpMultipartMode, String string, Charset charset, ProgressListener progressListener) {
        super(httpMultipartMode, string, charset);
        this.listener = progressListener;
    }

    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            super.writeTo(new CountingOutputStream(outputStream, this.listener));
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("Connection reset")) {
                EMLog.e("CustomMultiPartEntity", "WriteToException: Connection reset");
                if (this.listener != null) {
                    this.listener.onConnectionResetException();
                }
            }
            throw iOException;
        }
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(OutputStream outputStream, ProgressListener progressListener) {
            super(outputStream);
            this.listener = progressListener;
            this.transferred = 0L;
        }

        @Override
        public void write(@NonNull byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.transferred += (long)n2;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);

        public void onConnectionResetException();
    }
}

